/*
 * Decompiled with CFR 0.152.
 */
package gui;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import gui.PGSMouseListener;
import gui.PhysicalGameStateMouseJFrame;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class MouseController
extends AbstractionLayerAI {
    PhysicalGameStateMouseJFrame m_frame;
    PGSMouseListener m_mouseListener;

    public MouseController(PhysicalGameStateMouseJFrame frame) {
        super(new BFSPathFinding());
        this.m_frame = frame;
        this.reset();
    }

    public void setFrame(PhysicalGameStateMouseJFrame frame) {
        this.m_frame = frame;
        this.reset();
    }

    @Override
    public void reset() {
        if (this.m_frame != null) {
            MouseListener[] mla;
            for (MouseListener ml : mla = this.m_frame.getMouseListeners()) {
                if (!(ml instanceof PGSMouseListener)) continue;
                this.m_frame.removeMouseListener(ml);
            }
            this.m_mouseListener = new PGSMouseListener(this, this.m_frame, null, -1);
            this.m_frame.addMouseListener(this.m_mouseListener);
            this.m_frame.addMouseMotionListener(this.m_mouseListener);
            this.m_frame.addKeyListener(this.m_mouseListener);
        }
    }

    @Override
    public AI clone() {
        return new MouseController(this.m_frame);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        this.m_mouseListener.setPlayer(player);
        this.m_mouseListener.setGameState(gs);
        PhysicalGameState pgs = gs.getPhysicalGameState();
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player) continue;
            AbstractAction aa = (AbstractAction)this.actions.get(u);
            if (aa == null) {
                this.idle(u);
                continue;
            }
            if (!aa.completed(gs)) continue;
            this.idle(u);
        }
        return this.translateActions(player, gs);
    }

    @Override
    public PlayerAction translateActions(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        PlayerAction pa = new PlayerAction();
        LinkedList<Integer> usedCells = new LinkedList<Integer>();
        ResourceUsage r = gs.getResourceUsage();
        LinkedList<Unit> toDelete = new LinkedList<Unit>();
        for (AbstractAction aa : this.actions.values()) {
            UnitAction ua;
            if (!pgs.getUnits().contains(aa.getUnit())) {
                toDelete.add(aa.getUnit());
                continue;
            }
            if (gs.getActionAssignment(aa.getUnit()) != null || (ua = aa.execute(gs)) == null) continue;
            pa.addUnitAction(aa.getUnit(), ua);
            ResourceUsage r2 = ua.resourceUsage(aa.getUnit(), pgs);
            for (Integer cell : r2.getPositionsUsed()) {
                int celly;
                int cellx = cell % pgs.getWidth();
                if (pgs.getTerrain(cellx, celly = cell / pgs.getWidth()) != 0) continue;
                usedCells.add(cell);
                pgs.setTerrain(cellx, celly, 1);
            }
            ResourceUsage r_merged = r.mergeIntoNew(r2);
            if (!pa.consistentWith(r_merged, gs)) {
                pa.removeUnitAction(aa.getUnit(), ua);
                continue;
            }
            r = r_merged;
        }
        for (Unit u : toDelete) {
            this.actions.remove(u);
        }
        for (Integer cell : usedCells) {
            int cellx = cell % pgs.getWidth();
            int celly = cell / pgs.getWidth();
            pgs.setTerrain(cellx, celly, 0);
        }
        pa.fillWithNones(gs, player, 1);
        return pa;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }
}

