/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class MouseControllerPanel
extends JPanel {
    public int offset_x = 16;
    public int offset_y = 16;
    public int separation_x = 16;
    List<String> buttons = new LinkedList<String>();
    List<Character> buttonQuickKeys = new LinkedList<Character>();
    List<Rectangle2D> buttonRectangles = new LinkedList<Rectangle2D>();
    List<String> toHighlight = new LinkedList<String>();

    public void clearButtons() {
        this.buttons.clear();
        this.buttonQuickKeys.clear();
        this.buttonRectangles.clear();
    }

    public void highlight(String b) {
        this.toHighlight.add(b);
    }

    public void clearHighlight() {
        this.toHighlight.clear();
    }

    public void addButton(String b, Character qk) {
        this.buttons.add(b);
        this.buttonQuickKeys.add(qk);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 72.0, 32.0);
        this.buttonRectangles.add(r);
    }

    public String getContentAtCoordinates(int x, int y) {
        int bx = this.offset_x;
        int by = this.offset_y;
        for (int i = 0; i < this.buttons.size(); ++i) {
            String button = this.buttons.get(i);
            Rectangle2D r = this.buttonRectangles.get(i);
            if ((double)x >= (double)bx + r.getX() && (double)x < (double)bx + r.getX() + r.getWidth() && (double)y >= (double)by + r.getY() && (double)y < (double)by + r.getY() + r.getHeight()) {
                return button;
            }
            bx = (int)((double)bx + ((double)this.separation_x + r.getWidth()));
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        int x = this.offset_x;
        int y = this.offset_y;
        for (int i = 0; i < this.buttons.size(); ++i) {
            String button = this.buttons.get(i);
            Character quickKey = this.buttonQuickKeys.get(i);
            int idx = -1;
            if (quickKey != null) {
                for (int j = 0; j < button.length(); ++j) {
                    Character c = Character.valueOf(button.charAt(j));
                    if (!(c = Character.valueOf(Character.toLowerCase(c.charValue()))).equals(quickKey)) continue;
                    idx = j;
                    break;
                }
            }
            Rectangle2D r = this.buttonRectangles.get(i);
            g2d.setColor(Color.darkGray);
            if (this.toHighlight.contains(button)) {
                g2d.setColor(Color.green);
            }
            g2d.fillRect(x, y, (int)r.getWidth(), (int)r.getHeight());
            g2d.setColor(Color.lightGray);
            g2d.fillRect(x + 1, y + 1, (int)r.getWidth() - 2, (int)r.getHeight() - 2);
            g2d.setColor(Color.black);
            if (idx == -1) {
                g2d.drawString(button, x + 10, y + 22);
            } else {
                String s1 = button.substring(0, idx);
                String s2 = button.substring(idx, idx + 1);
                String s3 = button.substring(idx + 1);
                g2d.drawString(s1, x + 10, y + 22);
                FontMetrics fm = g2d.getFontMetrics();
                int w1 = fm.stringWidth(s1);
                g2d.setColor(Color.red);
                g2d.drawString(s2, x + 10 + w1, y + 22);
                int w2 = fm.stringWidth(s2);
                g2d.setColor(Color.black);
                g2d.drawString(s3, x + 10 + w1 + w2, y + 22);
            }
            x += (int)r.getWidth();
            x += this.separation_x;
        }
    }
}

