/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MouseController;
import gui.MouseControllerPanel;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public class PGSMouseListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    MouseController AI;
    PhysicalGameStateMouseJFrame frame;
    GameState gs;
    int playerID = -1;
    List<Unit> selectedUnits = new ArrayList<Unit>();
    String selectedButton;
    HashMap<Character, String> unitTypeQuickKeys = new HashMap();

    public PGSMouseListener(MouseController a_AI, PhysicalGameStateMouseJFrame a_frame, GameState a_gs, int a_playerID) {
        this.AI = a_AI;
        this.frame = a_frame;
        this.gs = a_gs;
        this.playerID = a_playerID;
    }

    public void setGameState(GameState a_gs) {
        this.gs = a_gs;
    }

    public void setPlayer(int a_playerID) {
        this.playerID = a_playerID;
    }

    public void clearQuickKeys() {
        this.unitTypeQuickKeys.clear();
    }

    public Character addQuickKey(String unitTypeName) {
        for (int i = 0; i < unitTypeName.length(); ++i) {
            Character c = Character.valueOf(unitTypeName.charAt(i));
            c = Character.valueOf(Character.toLowerCase(c.charValue()));
            boolean found = false;
            for (Character qk : this.unitTypeQuickKeys.keySet()) {
                if (!qk.equals(c)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.unitTypeQuickKeys.put(c, unitTypeName);
            return c;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        UnitType ut;
        int x = e.getX();
        int y = e.getY();
        Pair coordinates = null;
        Unit rawUnit = null;
        Unit unit = null;
        String button = null;
        if (this.gs == null) {
            return;
        }
        PhysicalGameStatePanel panel = this.frame.getPanel();
        MouseControllerPanel mousePanel = this.frame.getMousePanel();
        Object tmp = this.frame.getContentAtCoordinates(x, y);
        if (tmp != null) {
            if (tmp instanceof Pair) {
                coordinates = (Pair)tmp;
                rawUnit = this.gs.getPhysicalGameState().getUnitAt((Integer)coordinates.m_a, (Integer)coordinates.m_b);
                if (rawUnit != null && rawUnit.getPlayer() == this.playerID) {
                    unit = rawUnit;
                    coordinates = null;
                }
            } else if (tmp instanceof String) {
                button = (String)tmp;
            }
        }
        if (e.getButton() == 1) {
            if (unit != null) {
                this.selectedUnits.clear();
                this.selectedUnits.add(unit);
                this.selectedButton = null;
                this.updateButtons();
            } else if (button != null) {
                this.selectedButton = button;
                for (Unit selectedUnit : this.selectedUnits) {
                    if (selectedUnit.getType().canMove || (ut = this.gs.getUnitTypeTable().getUnitType(this.selectedButton)) == null) continue;
                    this.AI.train(selectedUnit, ut);
                    this.selectedButton = null;
                }
            } else if (this.insideOfGameArea(e.getX(), e.getY())) {
                this.selectedUnits.clear();
                this.selectedButton = null;
                mousePanel.clearButtons();
                this.clearQuickKeys();
            }
        } else if (e.getButton() == 3) {
            for (Unit selectedUnit : this.selectedUnits) {
                if (coordinates == null) continue;
                if (rawUnit != null) {
                    if (rawUnit.getType().isResource) {
                        if (!selectedUnit.getType().canHarvest) continue;
                        Unit base = null;
                        double bestD = 0.0;
                        for (Unit u : this.gs.getPhysicalGameState().getUnits()) {
                            if (u.getPlayer() != this.playerID || !u.getType().isStockpile) continue;
                            double d = selectedUnit.getX() - u.getX() + (selectedUnit.getY() - u.getY());
                            if (base != null && !(d < bestD)) continue;
                            base = u;
                            bestD = d;
                        }
                        if (base == null) continue;
                        this.AI.harvest(selectedUnit, rawUnit, base);
                        continue;
                    }
                    if (rawUnit.getType().isResource || rawUnit.getPlayer() == this.playerID || !selectedUnit.getType().canAttack) continue;
                    this.AI.attack(selectedUnit, rawUnit);
                    continue;
                }
                ut = this.gs.getUnitTypeTable().getUnitType(this.selectedButton);
                if (ut == null) {
                    if (!selectedUnit.getType().canMove) continue;
                    this.AI.move(selectedUnit, (Integer)coordinates.m_a, (Integer)coordinates.m_b);
                    continue;
                }
                if (!selectedUnit.getType().canMove) continue;
                this.AI.build(selectedUnit, ut, (Integer)coordinates.m_a, (Integer)coordinates.m_b);
            }
        }
        panel.clearHighlights();
        mousePanel.clearHighlight();
        for (Unit selectedUnit : this.selectedUnits) {
            panel.highlight(selectedUnit);
        }
        if (unit != null) {
            panel.highlight(unit);
        }
        if (this.selectedButton != null) {
            mousePanel.highlight(this.selectedButton);
        }
        if (button != null) {
            mousePanel.highlight(button);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            Insets insets = this.frame.getInsets();
            this.frame.panel.m_mouse_selection_x0 = this.frame.panel.m_mouse_selection_x1 = e.getX() - insets.left;
            this.frame.panel.m_mouse_selection_y0 = this.frame.panel.m_mouse_selection_y1 = e.getY() - insets.top;
            this.frame.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.insideOfGameArea(e.getX(), e.getY())) {
            this.frame.panel.m_mouse_selection_x1 = -1;
            this.frame.panel.m_mouse_selection_x0 = -1;
            this.frame.panel.m_mouse_selection_y1 = -1;
            this.frame.panel.m_mouse_selection_y0 = -1;
            return;
        }
        if (e.getButton() == 1) {
            int x0 = Math.min(this.frame.panel.m_mouse_selection_x0, this.frame.panel.m_mouse_selection_x1);
            int x1 = Math.max(this.frame.panel.m_mouse_selection_x0, this.frame.panel.m_mouse_selection_x1);
            int y0 = Math.min(this.frame.panel.m_mouse_selection_y0, this.frame.panel.m_mouse_selection_y1);
            int y1 = Math.max(this.frame.panel.m_mouse_selection_y0, this.frame.panel.m_mouse_selection_y1);
            Pair<Integer, Integer> tmp0 = this.frame.panel.getContentAtCoordinatesBounded(x0, y0);
            Pair<Integer, Integer> tmp1 = this.frame.panel.getContentAtCoordinatesBounded(x1, y1);
            this.frame.panel.m_mouse_selection_x1 = -1;
            this.frame.panel.m_mouse_selection_x0 = -1;
            this.frame.panel.m_mouse_selection_y1 = -1;
            this.frame.panel.m_mouse_selection_y0 = -1;
            if (tmp0 != null && tmp1 != null) {
                PhysicalGameStatePanel panel = this.frame.getPanel();
                MouseControllerPanel mousePanel = this.frame.getMousePanel();
                panel.clearHighlights();
                mousePanel.clearHighlight();
                this.selectedUnits.clear();
                Pair<Integer, Integer> coordinates0 = tmp0;
                Pair<Integer, Integer> coordinates1 = tmp1;
                for (int i = ((Integer)coordinates0.m_b).intValue(); i <= (Integer)coordinates1.m_b; ++i) {
                    for (int j = ((Integer)coordinates0.m_a).intValue(); j <= (Integer)coordinates1.m_a; ++j) {
                        Unit u = this.gs.getPhysicalGameState().getUnitAt(j, i);
                        if (u == null || u.getPlayer() != this.playerID) continue;
                        panel.highlight(u);
                        this.selectedUnits.add(u);
                    }
                }
                this.updateButtons();
            }
            this.frame.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getButton() == 1) {
            Insets insets = this.frame.getInsets();
            this.frame.panel.m_mouse_selection_x1 = e.getX() - insets.left;
            this.frame.panel.m_mouse_selection_y1 = e.getY() - insets.top;
            this.frame.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object tmp;
        int x = e.getX();
        int y = e.getY();
        if (this.gs == null) {
            return;
        }
        PhysicalGameStatePanel panel = this.frame.getPanel();
        MouseControllerPanel mousePanel = this.frame.getMousePanel();
        panel.clearHighlights();
        mousePanel.clearHighlight();
        for (Unit selectedUnit : this.selectedUnits) {
            panel.highlight(selectedUnit);
        }
        if (this.selectedButton != null) {
            mousePanel.highlight(this.selectedButton);
        }
        if ((tmp = this.frame.getContentAtCoordinates(x, y)) != null) {
            if (tmp instanceof Pair) {
                Pair coordinates = (Pair)tmp;
                Unit u = this.gs.getPhysicalGameState().getUnitAt((Integer)coordinates.m_a, (Integer)coordinates.m_b);
                if (u != null && u.getPlayer() == this.playerID) {
                    panel.highlight(u);
                }
            } else if (tmp instanceof String) {
                mousePanel.highlight((String)tmp);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        char kc = keyEvent.getKeyChar();
        String button = this.unitTypeQuickKeys.get(Character.valueOf(kc));
        if (button != null) {
            this.selectedButton = button;
            for (Unit selectedUnit : this.selectedUnits) {
                UnitType ut;
                if (selectedUnit.getType().canMove || (ut = this.gs.getUnitTypeTable().getUnitType(this.selectedButton)) == null) continue;
                this.AI.train(selectedUnit, ut);
            }
        }
        MouseControllerPanel mousePanel = this.frame.getMousePanel();
        mousePanel.clearHighlight();
        if (this.selectedButton != null) {
            mousePanel.highlight(this.selectedButton);
        }
        if (button != null) {
            mousePanel.highlight(button);
        }
        mousePanel.repaint();
    }

    private void updateButtons() {
        MouseControllerPanel mousePanel = this.frame.getMousePanel();
        mousePanel.clearButtons();
        this.clearQuickKeys();
        ArrayList<UnitType> shared = null;
        for (Unit u : this.selectedUnits) {
            if (shared == null) {
                shared = new ArrayList<UnitType>(u.getType().produces);
                continue;
            }
            ArrayList<UnitType> toDelete = new ArrayList<UnitType>();
            for (UnitType ut : shared) {
                if (u.getType().produces.contains(ut)) continue;
                toDelete.add(ut);
            }
            shared.removeAll(toDelete);
        }
        if (shared != null) {
            for (UnitType ut : shared) {
                Character qk = this.addQuickKey(ut.name);
                mousePanel.addButton(ut.name, qk);
            }
        }
    }

    public boolean insideOfGameArea(int x, int y) {
        Insets insets = this.frame.getInsets();
        Rectangle r = this.frame.panel.getBounds();
        return (x -= insets.left) >= r.x && x < r.x + r.width && (y -= insets.top) >= r.y && y < r.y + r.height;
    }
}

