/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MouseControllerPanel;
import gui.PhysicalGameStatePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import rts.GameState;
import util.Pair;

public class PhysicalGameStateMouseJFrame
extends JFrame {
    PhysicalGameStatePanel panel;
    MouseControllerPanel mousePanel;

    public PhysicalGameStateMouseJFrame(String title, int dx, int dy, PhysicalGameStatePanel a_panel) {
        super(title);
        this.panel = a_panel;
        this.mousePanel = new MouseControllerPanel();
        this.panel.setPreferredSize(new Dimension(dx, dy - 64));
        this.mousePanel.setPreferredSize(new Dimension(dx, 64));
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.panel);
        this.getContentPane().add(this.mousePanel);
        this.pack();
        this.setSize(dx, dy);
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public PhysicalGameStatePanel getPanel() {
        return this.panel;
    }

    public MouseControllerPanel getMousePanel() {
        return this.mousePanel;
    }

    public void setStateDirect(GameState gs) {
        this.panel.setStateDirect(gs);
    }

    public Object getContentAtCoordinates(int x, int y) {
        Insets insets = this.getInsets();
        Rectangle r = this.panel.getBounds();
        if ((x -= insets.left) >= r.x && x < r.x + r.width && (y -= insets.top) >= r.y && y < r.y + r.height) {
            Pair<Integer, Integer> cell = this.panel.getContentAtCoordinates(x - r.x, y - r.y);
            return cell;
        }
        r = this.mousePanel.getBounds();
        if (x >= r.x && x < r.x + r.width && y >= r.y && y < r.y + r.height) {
            String button = this.mousePanel.getContentAtCoordinates(x - r.x, y - r.y);
            return button;
        }
        return null;
    }
}

