/*
 * Decompiled with CFR 0.152.
 */
package gui;

import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleEvaluationFunction;
import gui.PhysicalGameStateJFrame;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.Pair;

public class PhysicalGameStatePanel
extends JPanel {
    public static int COLORSCHEME_BLACK = 1;
    public static int COLORSCHEME_WHITE = 2;
    boolean fullObservability = true;
    int drawFromPerspectiveOfPlayer = -1;
    GameState gs;
    List<Unit> toHighLight = new LinkedList<Unit>();
    EvaluationFunction evalFunction;
    int m_mouse_selection_x0 = -1;
    int m_mouse_selection_x1 = -1;
    int m_mouse_selection_y0 = -1;
    int m_mouse_selection_y1 = -1;
    PartiallyObservableGameState[] pogs = new PartiallyObservableGameState[2];
    int last_start_x = 0;
    int last_start_y = 0;
    int last_grid = 0;
    int colorScheme = COLORSCHEME_BLACK;

    public PhysicalGameStatePanel(GameState a_gs) {
        this(a_gs, new SimpleEvaluationFunction());
    }

    public PhysicalGameStatePanel(PhysicalGameStatePanel pgsp) {
        this(pgsp.gs, pgsp.evalFunction);
        this.fullObservability = pgsp.fullObservability;
        this.drawFromPerspectiveOfPlayer = pgsp.drawFromPerspectiveOfPlayer;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
    }

    public PhysicalGameStatePanel(GameState a_gs, EvaluationFunction evalFunction) {
        this.gs = a_gs;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
        this.evalFunction = evalFunction;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public PhysicalGameStatePanel(GameState a_gs, EvaluationFunction evalFunction, int cs) {
        this.gs = a_gs;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
        this.evalFunction = evalFunction;
        this.colorScheme = cs;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, 320, 320, false, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, boolean a_showVisibility) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, 320, 320, a_showVisibility, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, int dx, int dy) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, dx, dy, false, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, int dx, int dy, boolean a_showVisibility) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, dx, dy, a_showVisibility, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, int dx, int dy, boolean a_showVisibility, int cs) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, dx, dy, a_showVisibility, new SimpleEvaluationFunction(), cs);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, int dx, int dy, EvaluationFunction evalFunction) {
        return PhysicalGameStatePanel.newVisualizer(a_gs, dx, dy, false, evalFunction, COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState a_gs, int dx, int dy, boolean a_showVisibility, EvaluationFunction evalFunction, int cs) {
        PhysicalGameStatePanel ad = new PhysicalGameStatePanel(a_gs, evalFunction, cs);
        ad.fullObservability = !a_showVisibility;
        PhysicalGameStateJFrame frame = null;
        frame = new PhysicalGameStateJFrame("Game State Visualizer", dx, dy, ad);
        return frame;
    }

    public GameState getGameState() {
        return this.gs;
    }

    public void setColorScheme(int cs) {
        this.colorScheme = cs;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public int getColorScheme() {
        return this.colorScheme;
    }

    public void setStateCloning(GameState a_gs) {
        this.gs = a_gs.clone();
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }

    public void setStateDirect(GameState a_gs) {
        this.gs = a_gs;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }

    public GameState getState() {
        return this.gs;
    }

    public void clearHighlights() {
        this.toHighLight.clear();
    }

    public void highlight(Unit u) {
        this.toHighLight.add(u);
    }

    public Pair<Integer, Integer> getContentAtCoordinates(int x, int y) {
        if (x < this.last_start_x) {
            return null;
        }
        if (y < this.last_start_y) {
            return null;
        }
        int cellx = (x - this.last_start_x) / this.last_grid;
        int celly = (y - this.last_start_y) / this.last_grid;
        if (cellx >= this.gs.getPhysicalGameState().getWidth()) {
            return null;
        }
        if (celly >= this.gs.getPhysicalGameState().getHeight()) {
            return null;
        }
        return new Pair<Integer, Integer>(cellx, celly);
    }

    public Pair<Integer, Integer> getContentAtCoordinatesBounded(int x, int y) {
        if (x < this.last_start_x) {
            x = this.last_start_x;
        }
        if (y < this.last_start_y) {
            y = this.last_start_y;
        }
        int cellx = (x - this.last_start_x) / this.last_grid;
        int celly = (y - this.last_start_y) / this.last_grid;
        if (cellx >= this.gs.getPhysicalGameState().getWidth()) {
            cellx = this.gs.getPhysicalGameState().getWidth() - 1;
        }
        if (celly >= this.gs.getPhysicalGameState().getHeight()) {
            celly = this.gs.getPhysicalGameState().getHeight() - 1;
        }
        return new Pair<Integer, Integer>(cellx, celly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.gs != null) {
            GameState gameState = this.gs;
            synchronized (gameState) {
                PhysicalGameStatePanel.draw(g2d, this, this.getWidth(), this.getHeight(), this.gs, this.pogs, this.colorScheme, this.fullObservability, this.drawFromPerspectiveOfPlayer, this.evalFunction);
            }
        }
        if (this.m_mouse_selection_x0 >= 0) {
            g.setColor(Color.green);
            int x0 = Math.min(this.m_mouse_selection_x0, this.m_mouse_selection_x1);
            int x1 = Math.max(this.m_mouse_selection_x0, this.m_mouse_selection_x1);
            int y0 = Math.min(this.m_mouse_selection_y0, this.m_mouse_selection_y1);
            int y1 = Math.max(this.m_mouse_selection_y0, this.m_mouse_selection_y1);
            g.drawRect(x0, y0, x1 - x0, y1 - y0);
        }
    }

    public static void draw(Graphics2D g2d, PhysicalGameStatePanel panel, int dx, int dy, GameState gs, PartiallyObservableGameState[] pogs, int colorScheme, boolean fullObservability, int drawFromPerspectiveOfPlayer, EvaluationFunction evalFunction) {
        int i;
        if (gs == null) {
            return;
        }
        PhysicalGameState pgs = gs.getPhysicalGameState();
        if (pgs == null) {
            return;
        }
        int gridx = (dx - 64) / pgs.getWidth();
        int gridy = (dy - 64) / pgs.getHeight();
        int grid = Math.min(gridx, gridy);
        int sizex = grid * pgs.getWidth();
        int sizey = grid * pgs.getHeight();
        if (!fullObservability && pogs != null && pogs[0] != null && pogs[1] != null && pogs[0].getTime() != gs.getTime()) {
            pogs[0] = new PartiallyObservableGameState(gs, 0);
            pogs[1] = new PartiallyObservableGameState(gs, 1);
        }
        if (colorScheme == COLORSCHEME_BLACK) {
            g2d.setColor(Color.WHITE);
        }
        if (colorScheme == COLORSCHEME_WHITE) {
            g2d.setColor(Color.BLACK);
        }
        int unitCount0 = 0;
        for (Unit unit : gs.getPhysicalGameState().getUnits()) {
            if (unit.getPlayer() != 0) continue;
            ++unitCount0;
        }
        int unitCount1 = 0;
        for (Unit unit : gs.getPhysicalGameState().getUnits()) {
            if (unit.getPlayer() != 1) continue;
            ++unitCount1;
        }
        float f = evalFunction != null ? evalFunction.evaluate(0, 1, gs) : 0.0f;
        float eval1 = evalFunction != null ? evalFunction.evaluate(1, 0, gs) : 0.0f;
        String info = "T: " + gs.getTime() + ", P\u2080: " + unitCount0 + " (" + f + "), P\u2081: " + unitCount1 + " (" + eval1 + ")";
        g2d.drawString(info, 10, dy - 15);
        AffineTransform t = g2d.getTransform();
        if (panel != null) {
            panel.last_start_x = dx / 2 - sizex / 2;
            panel.last_start_y = dy / 2 - sizey / 2;
            panel.last_grid = grid;
            g2d.translate(panel.last_start_x, panel.last_start_y);
        } else {
            int last_start_x = dx / 2 - sizex / 2;
            int last_start_y = dy / 2 - sizey / 2;
            g2d.translate(last_start_x, last_start_y);
        }
        Color playerColor = null;
        Color wallColor = new Color(0.0f, 0.33f, 0.0f);
        Color po0color = new Color(0.0f, 0.0f, 0.25f);
        Color po1color = new Color(0.25f, 0.0f, 0.0f);
        Color pobothcolor = new Color(0.25f, 0.0f, 0.25f);
        for (int j = 0; j < pgs.getWidth(); ++j) {
            for (int i2 = 0; i2 < pgs.getHeight(); ++i2) {
                if (!fullObservability) {
                    if (drawFromPerspectiveOfPlayer >= 0) {
                        if (pogs[drawFromPerspectiveOfPlayer].observable(j, i2)) {
                            if (drawFromPerspectiveOfPlayer == 0) {
                                g2d.setColor(po0color);
                                g2d.fillRect(j * grid, i2 * grid, grid, grid);
                            } else {
                                g2d.setColor(po1color);
                                g2d.fillRect(j * grid, i2 * grid, grid, grid);
                            }
                        }
                    } else if (pogs[0].observable(j, i2)) {
                        if (pogs[1].observable(j, i2)) {
                            g2d.setColor(pobothcolor);
                            g2d.fillRect(j * grid, i2 * grid, grid, grid);
                        } else {
                            g2d.setColor(po0color);
                            g2d.fillRect(j * grid, i2 * grid, grid, grid);
                        }
                    } else if (pogs[1].observable(j, i2)) {
                        g2d.setColor(po1color);
                        g2d.fillRect(j * grid, i2 * grid, grid, grid);
                    }
                }
                if (pgs.getTerrain(j, i2) != 1) continue;
                g2d.setColor(wallColor);
                g2d.fillRect(j * grid, i2 * grid, grid, grid);
            }
        }
        if (colorScheme == COLORSCHEME_BLACK) {
            g2d.setColor(Color.GRAY);
        }
        if (colorScheme == COLORSCHEME_WHITE) {
            g2d.setColor(Color.BLACK);
        }
        for (i = 0; i <= pgs.getWidth(); ++i) {
            g2d.drawLine(i * grid, 0, i * grid, pgs.getHeight() * grid);
        }
        for (i = 0; i <= pgs.getHeight(); ++i) {
            g2d.drawLine(0, i * grid, pgs.getWidth() * grid, i * grid);
        }
        LinkedList<Unit> l = new LinkedList<Unit>(pgs.getUnits());
        for (Unit u : l) {
            int width;
            int reduction = 0;
            if (!fullObservability && drawFromPerspectiveOfPlayer >= 0 && !pogs[drawFromPerspectiveOfPlayer].observable(u.getX(), u.getY())) continue;
            UnitActionAssignment uaa = gs.getActionAssignment(u);
            if (uaa != null) {
                int offsx = 0;
                int offsy = 0;
                if (uaa.action.getType() == 5) {
                    offsx = (uaa.action.getLocationX() - u.getX()) * grid;
                    offsy = (uaa.action.getLocationY() - u.getY()) * grid;
                } else {
                    if (uaa.action.getDirection() == 0) {
                        offsy = -grid;
                    }
                    if (uaa.action.getDirection() == 1) {
                        offsx = grid;
                    }
                    if (uaa.action.getDirection() == 2) {
                        offsy = grid;
                    }
                    if (uaa.action.getDirection() == 3) {
                        offsx = -grid;
                    }
                }
                switch (uaa.action.getType()) {
                    case 1: {
                        g2d.setColor(Color.GRAY);
                        g2d.drawLine(u.getX() * grid + grid / 2, u.getY() * grid + grid / 2, u.getX() * grid + grid / 2 + offsx, u.getY() * grid + grid / 2 + offsy);
                        break;
                    }
                    case 5: {
                        g2d.setColor(Color.RED);
                        g2d.drawLine(u.getX() * grid + grid / 2, u.getY() * grid + grid / 2, u.getX() * grid + grid / 2 + offsx, u.getY() * grid + grid / 2 + offsy);
                        break;
                    }
                    case 4: {
                        g2d.setColor(Color.BLUE);
                        g2d.drawLine(u.getX() * grid + grid / 2, u.getY() * grid + grid / 2, u.getX() * grid + grid / 2 + offsx, u.getY() * grid + grid / 2 + offsy);
                        int ETA = uaa.time + uaa.action.ETA(uaa.unit) - gs.getTime();
                        g2d.setColor(Color.BLUE);
                        g2d.fillRect(u.getX() * grid + offsx, u.getY() * grid + offsy, grid - (int)((float)grid * ((float)ETA / (float)uaa.action.ETA(uaa.unit))), (int)((double)grid / 5.0));
                        String txt = uaa.action.getUnitType().name;
                        g2d.setColor(Color.BLUE);
                        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
                        int width2 = fm.stringWidth(txt);
                        g2d.drawString(txt, u.getX() * grid + grid / 2 - width2 / 2 + offsx, u.getY() * grid + grid / 2 + offsy);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (colorScheme == COLORSCHEME_BLACK) {
                            g2d.setColor(Color.WHITE);
                        }
                        if (colorScheme == COLORSCHEME_WHITE) {
                            g2d.setColor(Color.GREEN);
                        }
                        g2d.drawLine(u.getX() * grid + grid / 2, u.getY() * grid + grid / 2, u.getX() * grid + grid / 2 + offsx, u.getY() * grid + grid / 2 + offsy);
                    }
                }
            }
            if (u.getPlayer() == 0) {
                playerColor = Color.blue;
            } else if (u.getPlayer() == 1) {
                playerColor = Color.red;
            } else if (u.getPlayer() == -1) {
                playerColor = null;
            }
            if (u.getType().name.equals("Resource")) {
                g2d.setColor(Color.green);
            }
            if (u.getType().name.equals("Base")) {
                if (colorScheme == COLORSCHEME_BLACK) {
                    g2d.setColor(Color.white);
                }
                if (colorScheme == COLORSCHEME_WHITE) {
                    g2d.setColor(Color.lightGray);
                }
            }
            if (u.getType().name.equals("Barracks")) {
                if (colorScheme == COLORSCHEME_BLACK) {
                    g2d.setColor(Color.lightGray);
                }
                if (colorScheme == COLORSCHEME_WHITE) {
                    g2d.setColor(Color.gray);
                }
            }
            if (u.getType().name.equals("Worker")) {
                g2d.setColor(Color.gray);
                reduction = grid / 4;
            }
            if (u.getType().name.equals("Light")) {
                g2d.setColor(Color.orange);
                reduction = grid / 8;
            }
            if (u.getType().name.equals("Heavy")) {
                g2d.setColor(Color.yellow);
            }
            if (u.getType().name.equals("Ranged")) {
                g2d.setColor(Color.cyan);
                reduction = grid / 8;
            }
            if (!u.getType().canMove) {
                g2d.fillRect(u.getX() * grid + reduction, u.getY() * grid + reduction, grid - reduction * 2, grid - reduction * 2);
                g2d.setColor(playerColor);
                if (panel != null && panel.toHighLight.contains(u)) {
                    g2d.setColor(Color.green);
                }
                g2d.drawRect(u.getX() * grid + reduction, u.getY() * grid + reduction, grid - reduction * 2, grid - reduction * 2);
            } else {
                g2d.fillOval(u.getX() * grid + reduction, u.getY() * grid + reduction, grid - reduction * 2, grid - reduction * 2);
                g2d.setColor(playerColor);
                if (panel != null && panel.toHighLight.contains(u)) {
                    g2d.setColor(Color.green);
                }
                g2d.drawOval(u.getX() * grid + reduction, u.getY() * grid + reduction, grid - reduction * 2, grid - reduction * 2);
            }
            if (u.getType().isStockpile) {
                String txt = "" + pgs.getPlayer(u.getPlayer()).getResources();
                g2d.setColor(Color.black);
                FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
                width = fm.stringWidth(txt);
                g2d.drawString(txt, u.getX() * grid + grid / 2 - width / 2, u.getY() * grid + grid / 2);
            }
            if (u.getResources() != 0) {
                String txt = "" + u.getResources();
                g2d.setColor(Color.black);
                FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
                width = fm.stringWidth(txt);
                g2d.drawString(txt, u.getX() * grid + grid / 2 - width / 2, u.getY() * grid + grid / 2);
            }
            if (u.getHitPoints() >= u.getMaxHitPoints()) continue;
            g2d.setColor(Color.RED);
            g2d.fillRect(u.getX() * grid, u.getY() * grid, grid, (int)((double)grid / 5.0));
            g2d.setColor(Color.GREEN);
            g2d.fillRect(u.getX() * grid, u.getY() * grid, (int)((float)grid * ((float)u.getHitPoints() / (float)u.getMaxHitPoints())), (int)((double)grid / 5.0));
        }
        g2d.setTransform(t);
    }

    public void resizeGameState(int width, int height) {
        if (width >= 1 && height >= 1) {
            int i;
            PhysicalGameState pgs = this.gs.getPhysicalGameState();
            int[] newTerrain = new int[width * height];
            for (i = 0; i < width * height; ++i) {
                newTerrain[i] = 0;
            }
            for (i = 0; i < height && i < pgs.getHeight(); ++i) {
                for (int j = 0; j < width && j < pgs.getWidth(); ++j) {
                    newTerrain[j + i * width] = pgs.getTerrain(j, i);
                }
            }
            ArrayList<Unit> toDelete = new ArrayList<Unit>();
            for (Unit u : pgs.getUnits()) {
                if (u.getX() < width && u.getY() < height) continue;
                toDelete.add(u);
            }
            for (Unit u : toDelete) {
                this.gs.removeUnit(u);
            }
            pgs.setTerrain(newTerrain);
            pgs.setWidth(width);
            pgs.setHeight(height);
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
    }

    public void setFullObservability(boolean fo) {
        this.fullObservability = fo;
    }

    public void setDrawFromPerspectiveOfPlayer(int p) {
        this.drawFromPerspectiveOfPlayer = p;
    }

    public void gameStateUpdated() {
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }
}

