/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PhysicalGameStatePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rts.GameState;
import rts.Trace;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class TraceVisualizer
extends JPanel
implements ListSelectionListener {
    int current_step = 0;
    Trace trace;
    JPanel statePanel;
    JList Selector;
    List<GameState> states = new LinkedList<GameState>();

    public static JFrame newWindow(String name, int dx, int dy, Trace t, int subjectID) throws Exception {
        TraceVisualizer ad = new TraceVisualizer(t, dx, dy, subjectID);
        JFrame frame = new JFrame(name);
        frame.getContentPane().add(ad);
        frame.pack();
        frame.setDefaultCloseOperation(2);
        return frame;
    }

    public TraceVisualizer(Trace t, int dx, int dy, int subject) throws Exception {
        this.trace = t;
        for (TraceEntry te : this.trace.getEntries()) {
            this.states.add(this.trace.getGameStateAtCycle(te.getTime()));
        }
        this.setPreferredSize(new Dimension(dx, dy));
        this.setSize(dx, dy);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
        this.setBackground(Color.WHITE);
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.statePanel = new PhysicalGameStatePanel(new GameState(t.getEntries().get(0).getPhysicalGameState(), t.getUnitTypeTable()));
        this.statePanel.setPreferredSize(new Dimension((int)((double)dx * 0.6), dy));
        this.add(this.statePanel);
        String[] actionList = new String[t.getEntries().size()];
        this.Selector = new JList();
        JScrollPane ListScrollPane = new JScrollPane(this.Selector);
        for (int i = 0; i < t.getEntries().size(); ++i) {
            if (!t.getEntries().get(i).getActions().isEmpty()) {
                StringBuilder tmp = new StringBuilder();
                for (Pair<Unit, UnitAction> uap : t.getEntries().get(i).getActions()) {
                    tmp.append("(").append(((Unit)uap.m_a).getID()).append(", ").append(((UnitAction)uap.m_b).getActionName()).append("), ");
                }
                actionList[i] = tmp.toString();
                continue;
            }
            actionList[i] = "-";
        }
        this.Selector.setListData(actionList);
        this.Selector.addListSelectionListener(this);
        this.Selector.setSelectedIndex(0);
        this.Selector.setSelectionMode(0);
        this.add(ListScrollPane);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selection = this.Selector.getSelectedIndex();
        ((PhysicalGameStatePanel)this.statePanel).setStateDirect(this.states.get(selection));
        this.repaint();
    }
}

