/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import ai.BranchingFactorCalculatorBigInteger;
import ai.PassiveAI;
import ai.RandomAI;
import ai.RandomBiasedAI;
import ai.abstraction.HeavyDefense;
import ai.abstraction.HeavyRush;
import ai.abstraction.LightDefense;
import ai.abstraction.LightRush;
import ai.abstraction.RangedDefense;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerDefense;
import ai.abstraction.WorkerRush;
import ai.abstraction.WorkerRushPlusPlus;
import ai.abstraction.cRush.CRush_V1;
import ai.abstraction.cRush.CRush_V2;
import ai.abstraction.partialobservability.POHeavyRush;
import ai.abstraction.partialobservability.POLightRush;
import ai.abstraction.partialobservability.PORangedRush;
import ai.abstraction.partialobservability.POWorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.GreedyPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.AHTNAI;
import ai.coac.CoacAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ContinuingAI;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.core.PseudoContinuingAI;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.EvaluationFunctionForwarding;
import ai.evaluation.SimpleEvaluationFunction;
import ai.evaluation.SimpleOptEvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction2;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.believestatemcts.BS3_NaiveMCTS;
import ai.mcts.informedmcts.InformedNaiveMCTS;
import ai.mcts.mlps.MLPSMCTS;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.uct.DownsamplingUCT;
import ai.mcts.uct.UCT;
import ai.mcts.uct.UCTFirstPlayUrgency;
import ai.mcts.uct.UCTUnitActions;
import ai.minimax.ABCD.IDABCD;
import ai.minimax.RTMiniMax.IDRTMinimax;
import ai.minimax.RTMiniMax.IDRTMinimaxRandomized;
import ai.montecarlo.MonteCarlo;
import ai.montecarlo.lsi.LSI;
import ai.portfolio.PortfolioAI;
import ai.portfolio.portfoliogreedysearch.PGSAI;
import ai.puppet.PuppetSearchMCTS;
import ai.scv.SCV;
import ai.stochastic.UnitActionProbabilityDistribution;
import gui.MouseController;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import gui.frontend.FEStateMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.Trace;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import tests.MapGenerator;
import util.Pair;
import util.XMLWriter;

public class FEStatePane
extends JPanel {
    PhysicalGameStatePanel statePanel;
    JTextArea textArea;
    UnitTypeTable currentUtt;
    JFileChooser fileChooser = new JFileChooser();
    EvaluationFunction[] efs = new EvaluationFunction[]{new SimpleEvaluationFunction(), new SimpleSqrtEvaluationFunction(), new SimpleSqrtEvaluationFunction2(), new SimpleSqrtEvaluationFunction3(), new EvaluationFunctionForwarding(new SimpleEvaluationFunction()), new SimpleOptEvaluationFunction()};
    public static Class[] AIs = new Class[]{PassiveAI.class, CoacAI.class, MouseController.class, RandomAI.class, RandomBiasedAI.class, WorkerRush.class, LightRush.class, HeavyRush.class, RangedRush.class, WorkerDefense.class, LightDefense.class, HeavyDefense.class, RangedDefense.class, POWorkerRush.class, POLightRush.class, POHeavyRush.class, PORangedRush.class, WorkerRushPlusPlus.class, CRush_V1.class, CRush_V2.class, PortfolioAI.class, PGSAI.class, IDRTMinimax.class, IDRTMinimaxRandomized.class, IDABCD.class, MonteCarlo.class, LSI.class, UCT.class, UCTUnitActions.class, UCTFirstPlayUrgency.class, DownsamplingUCT.class, NaiveMCTS.class, BS3_NaiveMCTS.class, MLPSMCTS.class, AHTNAI.class, InformedNaiveMCTS.class, PuppetSearchMCTS.class, SCV.class};
    Class[] PlayoutAIs = new Class[]{RandomAI.class, RandomBiasedAI.class, WorkerRush.class, LightRush.class, HeavyRush.class, RangedRush.class};
    PathFinding[] pathFinders = new PathFinding[]{new AStarPathFinding(), new BFSPathFinding(), new GreedyPathFinding(), new FloodFillPathFinding()};
    public static UnitTypeTable[] unitTypeTables = new UnitTypeTable[]{new UnitTypeTable(1, 1), new UnitTypeTable(1, 3), new UnitTypeTable(1, 2), new UnitTypeTable(2, 1), new UnitTypeTable(2, 3), new UnitTypeTable(2, 2), new UnitTypeTable(3, 1), new UnitTypeTable(3, 3), new UnitTypeTable(3, 2)};
    public static String[] unitTypeTableNames = new String[]{"Original-Both", "Original-Alternating", "Original-Random", "Finetuned-Both", "Finetuned-Alternating", "Finetuned-Random", "Nondeterministic-Both", "Nondeterministic-Alternating", "Nondeterministic-Random"};
    JFormattedTextField mapWidthField;
    JFormattedTextField mapHeightField;
    JFormattedTextField maxCyclesField;
    JFormattedTextField defaultDelayField;
    JCheckBox fullObservabilityBox;
    JComboBox unitTypeTableBox;
    JCheckBox saveTraceBox;
    JCheckBox slowDownBox;
    JComboBox[] aiComboBox = new JComboBox[]{null, null};
    JCheckBox[] continuingBox = new JCheckBox[]{null, null};
    JPanel[] AIOptionsPanel = new JPanel[]{null, null};
    HashMap[] AIOptionsPanelComponents = new HashMap[]{new HashMap(), new HashMap()};
    FEStateMouseListener mouseListener;

    public FEStatePane() throws Exception {
        this.currentUtt = new UnitTypeTable();
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JPanel ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        JComponent b = new JButton("Clear");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState gs = FEStatePane.this.statePanel.getState();
                gs.getUnitActions().clear();
                PhysicalGameState pgs = gs.getPhysicalGameState();
                for (int i = 0; i < pgs.getHeight(); ++i) {
                    for (int j = 0; j < pgs.getWidth(); ++j) {
                        pgs.setTerrain(j, i, 0);
                    }
                }
                pgs.getUnits().clear();
                FEStatePane.this.statePanel.repaint();
            }
        });
        ptmp.add(b);
        b = new JButton("Load");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = FEStatePane.this.fileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = FEStatePane.this.fileChooser.getSelectedFile();
                    try {
                        PhysicalGameState pgs = PhysicalGameState.load(file.getAbsolutePath(), FEStatePane.this.currentUtt);
                        GameState gs = new GameState(pgs, FEStatePane.this.currentUtt);
                        FEStatePane.this.statePanel.setStateDirect(gs);
                        FEStatePane.this.statePanel.repaint();
                        FEStatePane.this.mapWidthField.setText(pgs.getWidth() + "");
                        FEStatePane.this.mapHeightField.setText(pgs.getHeight() + "");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        ptmp.add(b);
        b = new JButton("Save");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if (FEStatePane.this.statePanel.getGameState() != null && (returnVal = FEStatePane.this.fileChooser.showSaveDialog(null)) == 0) {
                    File file = FEStatePane.this.fileChooser.getSelectedFile();
                    try {
                        XMLWriter xml = new XMLWriter(new FileWriter(file.getAbsolutePath()));
                        FEStatePane.this.statePanel.getGameState().getPhysicalGameState().toxml(xml);
                        xml.flush();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        ptmp.add(b);
        p1.add(ptmp);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        this.mapWidthField = FEStatePane.addTextField(ptmp, "Width:", "8", 4);
        this.mapWidthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newWidth = Integer.parseInt(FEStatePane.this.mapWidthField.getText());
                    FEStatePane.this.statePanel.resizeGameState(newWidth, FEStatePane.this.statePanel.getGameState().getPhysicalGameState().getHeight());
                    FEStatePane.this.statePanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mapHeightField = FEStatePane.addTextField(ptmp, "Height:", "8", 4);
        this.mapHeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newHeight = Integer.parseInt(FEStatePane.this.mapHeightField.getText());
                    FEStatePane.this.statePanel.resizeGameState(FEStatePane.this.statePanel.getGameState().getPhysicalGameState().getWidth(), newHeight);
                    FEStatePane.this.statePanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        p1.add(ptmp);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        b = new JButton("Move Player 0");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AI ai = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[0].getSelectedIndex(), 0, FEStatePane.this.currentUtt);
                if (ai instanceof MouseController) {
                    FEStatePane.this.textArea.setText("Mouse controller is not allowed for this function.");
                    return;
                }
                try {
                    long start = System.currentTimeMillis();
                    ai.reset();
                    PlayerAction a = ai.getAction(0, FEStatePane.this.statePanel.getGameState());
                    long end = System.currentTimeMillis();
                    FEStatePane.this.textArea.setText("Action generated with " + ai.getClass().getSimpleName() + " in " + (end - start) + "ms\n");
                    FEStatePane.this.textArea.append(ai.statisticsString() + "\n");
                    FEStatePane.this.textArea.append("Action:\n");
                    for (Pair<Unit, UnitAction> tmp : a.getActions()) {
                        FEStatePane.this.textArea.append("    " + tmp.m_a + ": " + tmp.m_b + "\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ptmp.add(b);
        b = new JButton("Move Player 1");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AI ai = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[1].getSelectedIndex(), 1, FEStatePane.this.currentUtt);
                if (ai instanceof MouseController) {
                    FEStatePane.this.textArea.setText("Mouse controller is not allowed for this function.");
                    return;
                }
                try {
                    long start = System.currentTimeMillis();
                    ai.reset();
                    PlayerAction a = ai.getAction(0, FEStatePane.this.statePanel.getGameState());
                    long end = System.currentTimeMillis();
                    FEStatePane.this.textArea.setText("Action generated with " + ai.getClass().getSimpleName() + " in " + (end - start) + "ms\n");
                    FEStatePane.this.textArea.append(ai.statisticsString() + "\n");
                    FEStatePane.this.textArea.append("Action:\n");
                    for (Pair<Unit, UnitAction> tmp : a.getActions()) {
                        FEStatePane.this.textArea.append("    " + tmp.m_a + ": " + tmp.m_b + "\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ptmp.add(b);
        b = new JButton("Analyze");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FEStatePane.this.statePanel.getGameState() == null) {
                    FEStatePane.this.textArea.setText("Load a game state first");
                    return;
                }
                try {
                    FEStatePane.this.textArea.setText("");
                    FEStatePane.this.textArea.append("Evaluation functions:\n");
                    for (EvaluationFunction ef : FEStatePane.this.efs) {
                        FEStatePane.this.textArea.append("  - " + ef.getClass().getSimpleName() + ": " + ef.evaluate(0, 1, FEStatePane.this.statePanel.getGameState()) + ", " + ef.evaluate(1, 0, FEStatePane.this.statePanel.getGameState()) + "\n");
                    }
                    FEStatePane.this.textArea.append("\n");
                    int n0 = 0;
                    int n1 = 0;
                    for (Unit u : FEStatePane.this.statePanel.getGameState().getUnits()) {
                        if (u.getPlayer() == 0) {
                            ++n0;
                        }
                        if (u.getPlayer() != 1) continue;
                        ++n1;
                    }
                    FEStatePane.this.textArea.append("Player 0 has " + n0 + " units\n");
                    FEStatePane.this.textArea.append("Player 1 has " + n1 + " units\n\n");
                    FEStatePane.this.textArea.append("Braching Factor (BigInteger):\n");
                    FEStatePane.this.textArea.append("  - player 0: " + BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageSeparatingFast(FEStatePane.this.statePanel.getGameState(), 0) + "\n");
                    FEStatePane.this.textArea.append("  - player 1: " + BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageSeparatingFast(FEStatePane.this.statePanel.getGameState(), 1) + "\n");
                    FEStatePane.this.textArea.append("\n");
                    FEStatePane.this.textArea.append("Unit moves:\n");
                    FEStatePane.this.textArea.append("  - player 0:\n");
                    if (FEStatePane.this.statePanel.getGameState().canExecuteAnyAction(0)) {
                        PlayerActionGenerator pag0 = new PlayerActionGenerator(FEStatePane.this.statePanel.getGameState(), 0);
                        for (Pair<Unit, List<UnitAction>> tmp : pag0.getChoices()) {
                            FEStatePane.this.textArea.append("    " + tmp.m_a + " has " + ((List)tmp.m_b).size() + " actions: " + tmp.m_b + "\n");
                        }
                        FEStatePane.this.textArea.append("\n");
                    }
                    FEStatePane.this.textArea.append("  - player 1:\n");
                    if (FEStatePane.this.statePanel.getGameState().canExecuteAnyAction(1)) {
                        PlayerActionGenerator pag1 = new PlayerActionGenerator(FEStatePane.this.statePanel.getGameState(), 1);
                        for (Pair<Unit, List<UnitAction>> tmp : pag1.getChoices()) {
                            FEStatePane.this.textArea.append("    " + tmp.m_a + " has " + ((List)tmp.m_b).size() + " actions: " + tmp.m_b + "\n");
                        }
                        FEStatePane.this.textArea.append("\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ptmp.add(b);
        p1.add(ptmp);
        String[] colorSchemes = new String[]{"Color Scheme Black", "Color Scheme White"};
        b = new JComboBox<String>(colorSchemes);
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        ((JComboBox)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                if (combo.getSelectedIndex() == 0) {
                    FEStatePane.this.statePanel.setColorScheme(PhysicalGameStatePanel.COLORSCHEME_BLACK);
                }
                if (combo.getSelectedIndex() == 1) {
                    FEStatePane.this.statePanel.setColorScheme(PhysicalGameStatePanel.COLORSCHEME_WHITE);
                }
                FEStatePane.this.statePanel.repaint();
            }
        });
        b.setMaximumSize(new Dimension(300, 24));
        p1.add(b);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        this.maxCyclesField = FEStatePane.addTextField(ptmp, "Max Cycles:", "3000", 5);
        this.defaultDelayField = FEStatePane.addTextField(ptmp, "Default Delay:", "10", 5);
        p1.add(ptmp);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        this.fullObservabilityBox = new JCheckBox("Full Obsservability");
        this.fullObservabilityBox.setSelected(true);
        this.fullObservabilityBox.setAlignmentX(0.5f);
        this.fullObservabilityBox.setAlignmentY(0.0f);
        this.fullObservabilityBox.setMaximumSize(new Dimension(120, 20));
        this.fullObservabilityBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEStatePane.this.statePanel.setFullObservability(FEStatePane.this.fullObservabilityBox.isSelected());
                FEStatePane.this.statePanel.repaint();
            }
        });
        ptmp.add(this.fullObservabilityBox);
        this.slowDownBox = new JCheckBox("Slow Down");
        this.slowDownBox.setAlignmentX(0.5f);
        this.slowDownBox.setAlignmentY(0.0f);
        this.slowDownBox.setMaximumSize(new Dimension(120, 20));
        this.slowDownBox.setSelected(true);
        ptmp.add(this.slowDownBox);
        p1.add(ptmp);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        ptmp.add(new JLabel("UnitTypeTable"));
        this.unitTypeTableBox = new JComboBox<String>(unitTypeTableNames);
        this.unitTypeTableBox.setAlignmentX(0.5f);
        this.unitTypeTableBox.setAlignmentY(0.5f);
        this.unitTypeTableBox.setMaximumSize(new Dimension(240, 20));
        this.unitTypeTableBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = FEStatePane.this.unitTypeTableBox.getSelectedIndex();
                UnitTypeTable new_utt = unitTypeTables[idx];
                GameState gs = FEStatePane.this.statePanel.getGameState().cloneChangingUTT(new_utt);
                if (gs != null) {
                    FEStatePane.this.statePanel.setStateDirect(gs);
                    FEStatePane.this.currentUtt = new_utt;
                    FEStatePane.this.mouseListener.utt = new_utt;
                } else {
                    System.err.println("Could not change unit type table!");
                }
            }
        });
        ptmp.add(this.unitTypeTableBox);
        p1.add(ptmp);
        ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        b = new JButton("Start");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        b.setMaximumSize(new Dimension(120, 20));
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            AI ai1 = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[0].getSelectedIndex(), 0, FEStatePane.this.currentUtt);
                            AI ai2 = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[1].getSelectedIndex(), 1, FEStatePane.this.currentUtt);
                            int PERIOD1 = Integer.parseInt(FEStatePane.this.defaultDelayField.getText());
                            int PERIOD2 = Integer.parseInt(FEStatePane.this.defaultDelayField.getText());
                            JFormattedTextField t1 = (JFormattedTextField)FEStatePane.this.AIOptionsPanelComponents[0].get("TimeBudget");
                            JFormattedTextField t2 = (JFormattedTextField)FEStatePane.this.AIOptionsPanelComponents[1].get("TimeBudget");
                            if (t1 != null) {
                                PERIOD1 = Integer.parseInt(t1.getText());
                            }
                            if (t2 != null) {
                                PERIOD2 = Integer.parseInt(t2.getText());
                            }
                            int PERIOD = PERIOD1 + PERIOD2;
                            if (!FEStatePane.this.slowDownBox.isSelected()) {
                                PERIOD = 1;
                            }
                            int MAXCYCLES = Integer.parseInt(FEStatePane.this.maxCyclesField.getText());
                            GameState gs = FEStatePane.this.statePanel.getState().clone();
                            ai1.preGameAnalysis(gs, -1L);
                            ai2.preGameAnalysis(gs, -1L);
                            boolean gameover = false;
                            JFrame w = null;
                            boolean isMouseController = false;
                            if (ai1 instanceof MouseController) {
                                isMouseController = true;
                            }
                            if (ai2 instanceof MouseController) {
                                isMouseController = true;
                            }
                            if (ai1 instanceof PseudoContinuingAI && ((PseudoContinuingAI)ai1).getbaseAI() instanceof MouseController) {
                                isMouseController = true;
                            }
                            if (ai2 instanceof PseudoContinuingAI && ((PseudoContinuingAI)ai2).getbaseAI() instanceof MouseController) {
                                isMouseController = true;
                            }
                            if (isMouseController) {
                                PhysicalGameStatePanel pgsp = new PhysicalGameStatePanel(FEStatePane.this.statePanel);
                                pgsp.setStateDirect(gs);
                                w = new PhysicalGameStateMouseJFrame("Game State Visualizer (Mouse)", 640, 640, pgsp);
                                boolean mousep1 = false;
                                boolean mousep2 = false;
                                if (ai1 instanceof MouseController) {
                                    ((MouseController)ai1).setFrame((PhysicalGameStateMouseJFrame)w);
                                    mousep1 = true;
                                } else if (ai1 instanceof PseudoContinuingAI && ((PseudoContinuingAI)ai1).getbaseAI() instanceof MouseController) {
                                    ((MouseController)((PseudoContinuingAI)ai1).getbaseAI()).setFrame((PhysicalGameStateMouseJFrame)w);
                                    mousep1 = true;
                                }
                                if (ai2 instanceof MouseController) {
                                    ((MouseController)ai2).setFrame((PhysicalGameStateMouseJFrame)w);
                                    mousep2 = true;
                                } else if (ai2 instanceof PseudoContinuingAI && ((PseudoContinuingAI)ai2).getbaseAI() instanceof MouseController) {
                                    ((MouseController)((PseudoContinuingAI)ai2).getbaseAI()).setFrame((PhysicalGameStateMouseJFrame)w);
                                    mousep2 = true;
                                }
                                if (mousep1 && !mousep2) {
                                    pgsp.setDrawFromPerspectiveOfPlayer(0);
                                }
                                if (!mousep1 && mousep2) {
                                    pgsp.setDrawFromPerspectiveOfPlayer(1);
                                }
                            } else {
                                w = PhysicalGameStatePanel.newVisualizer(gs, 640, 640, !FEStatePane.this.fullObservabilityBox.isSelected(), FEStatePane.this.statePanel.getColorScheme());
                            }
                            Trace trace = null;
                            if (FEStatePane.this.saveTraceBox.isSelected()) {
                                trace = new Trace(FEStatePane.this.currentUtt);
                                TraceEntry te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
                                trace.addEntry(te);
                            }
                            long nextTimeToUpdate = System.currentTimeMillis() + (long)PERIOD;
                            do {
                                if (System.currentTimeMillis() >= nextTimeToUpdate) {
                                    Object te;
                                    PlayerAction pa1 = null;
                                    PlayerAction pa2 = null;
                                    if (FEStatePane.this.fullObservabilityBox.isSelected()) {
                                        pa1 = ai1.getAction(0, gs);
                                        pa2 = ai2.getAction(1, gs);
                                    } else {
                                        pa1 = ai1.getAction(0, new PartiallyObservableGameState(gs, 0));
                                        pa2 = ai2.getAction(1, new PartiallyObservableGameState(gs, 1));
                                    }
                                    if (!(trace == null || pa1.isEmpty() && pa2.isEmpty())) {
                                        te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
                                        ((TraceEntry)te).addPlayerAction(pa1.clone());
                                        ((TraceEntry)te).addPlayerAction(pa2.clone());
                                        trace.addEntry((TraceEntry)te);
                                    }
                                    te = gs;
                                    synchronized (te) {
                                        gs.issueSafe(pa1);
                                        gs.issueSafe(pa2);
                                    }
                                    te = gs;
                                    synchronized (te) {
                                        gameover = gs.cycle();
                                    }
                                    w.repaint();
                                    nextTimeToUpdate += (long)PERIOD;
                                    continue;
                                }
                                Thread.sleep(1L);
                            } while (w.isVisible() && !gameover && gs.getTime() < MAXCYCLES);
                            if (trace != null) {
                                TraceEntry te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
                                trace.addEntry(te);
                                String traceFileName = FEStatePane.nextTraceName();
                                XMLWriter xml = new XMLWriter(new FileWriter(traceFileName));
                                trace.toxml(xml);
                                xml.flush();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                new Thread(r).start();
            }
        });
        ptmp.add(b);
        this.saveTraceBox = new JCheckBox("Save Trace");
        this.saveTraceBox.setAlignmentX(0.5f);
        this.saveTraceBox.setAlignmentY(0.0f);
        this.saveTraceBox.setMaximumSize(new Dimension(120, 20));
        ptmp.add(this.saveTraceBox);
        p1.add(ptmp);
        for (int player = 0; player < 2; ++player) {
            p1.add(new JSeparator(0));
            JPanel ptmp2 = new JPanel();
            ptmp2.setLayout(new BoxLayout(ptmp2, 0));
            JLabel l1 = new JLabel("Player " + player + ":");
            l1.setAlignmentX(0.5f);
            l1.setAlignmentY(0.0f);
            ptmp2.add(l1);
            String[] AINames = new String[AIs.length];
            for (int i = 0; i < AIs.length; ++i) {
                AINames[i] = AIs[i].getSimpleName();
            }
            this.aiComboBox[player] = new JComboBox<String>(AINames);
            this.aiComboBox[player].setAlignmentX(0.5f);
            this.aiComboBox[player].setAlignmentY(0.0f);
            this.aiComboBox[player].setMaximumSize(new Dimension(300, 24));
            ptmp2.add(this.aiComboBox[player]);
            p1.add(ptmp2);
            this.continuingBox[player] = new JCheckBox("Continuing");
            this.continuingBox[player].setAlignmentX(0.5f);
            this.continuingBox[player].setAlignmentY(0.0f);
            this.continuingBox[player].setMaximumSize(new Dimension(120, 20));
            this.continuingBox[player].setSelected(true);
            p1.add(this.continuingBox[player]);
            this.AIOptionsPanel[player] = new JPanel();
            this.AIOptionsPanel[player].setLayout(new BoxLayout(this.AIOptionsPanel[player], 1));
            p1.add(this.AIOptionsPanel[player]);
            this.updateAIOptions(this.AIOptionsPanel[player], player);
        }
        this.aiComboBox[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FEStatePane.this.updateAIOptions(FEStatePane.this.AIOptionsPanel[0], 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.aiComboBox[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FEStatePane.this.updateAIOptions(FEStatePane.this.AIOptionsPanel[1], 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        MapGenerator mg = new MapGenerator(this.currentUtt);
        GameState initialGs = new GameState(mg.bases8x8(), this.currentUtt);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        this.statePanel = new PhysicalGameStatePanel(initialGs);
        this.statePanel.setPreferredSize(new Dimension(512, 512));
        p2.add(this.statePanel);
        this.textArea = new JTextArea(5, 20);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        scrollPane.setPreferredSize(new Dimension(512, 192));
        p2.add((Component)scrollPane, "Center");
        this.add((Component)p1, "West");
        this.add((Component)p2, "East");
        this.mouseListener = new FEStateMouseListener(this.statePanel, this.currentUtt);
        this.statePanel.addMouseListener(this.mouseListener);
    }

    public void setState(GameState gs) {
        this.statePanel.setStateDirect(gs);
        this.statePanel.repaint();
        this.mapWidthField.setText(gs.getPhysicalGameState().getWidth() + "");
        this.mapHeightField.setText(gs.getPhysicalGameState().getHeight() + "");
    }

    private static String nextTraceName() {
        int idx = 1;
        String name;
        File f;
        while ((f = new File(name = "trace" + idx + ".xml")).exists()) {
            ++idx;
        }
        return name;
    }

    public static JFormattedTextField addTextField(JPanel p, String name, String defaultValue, int columns) {
        JPanel ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        ptmp.add(new JLabel(name));
        JFormattedTextField f = new JFormattedTextField();
        f.setValue(defaultValue);
        f.setMaximumSize(new Dimension(80, 20));
        ptmp.add(f);
        p.add(ptmp);
        return f;
    }

    public AI createAI(int idx, int player, UnitTypeTable utt) {
        try {
            AI ai = this.createAIInternal(idx, player, utt);
            List<ParameterSpecification> parameters = ai.getParameters();
            for (ParameterSpecification p : parameters) {
                Method setter;
                Method setter2;
                JComponent f;
                if (p.type == Integer.TYPE) {
                    f = (JFormattedTextField)this.AIOptionsPanelComponents[player].get(p.name);
                    int v = Integer.parseInt(((JTextComponent)f).getText());
                    setter2 = ai.getClass().getMethod("set" + p.name, p.type);
                    setter2.invoke((Object)ai, v);
                    continue;
                }
                if (p.type == Long.TYPE) {
                    f = (JFormattedTextField)this.AIOptionsPanelComponents[player].get(p.name);
                    long v = Long.parseLong(((JTextComponent)f).getText());
                    setter = ai.getClass().getMethod("set" + p.name, p.type);
                    setter.invoke((Object)ai, v);
                    continue;
                }
                if (p.type == Float.TYPE) {
                    f = (JFormattedTextField)this.AIOptionsPanelComponents[player].get(p.name);
                    float v = Float.parseFloat(((JTextComponent)f).getText());
                    setter2 = ai.getClass().getMethod("set" + p.name, p.type);
                    setter2.invoke((Object)ai, Float.valueOf(v));
                    continue;
                }
                if (p.type == Double.TYPE) {
                    f = (JFormattedTextField)this.AIOptionsPanelComponents[player].get(p.name);
                    double v = Double.parseDouble(((JTextComponent)f).getText());
                    setter = ai.getClass().getMethod("set" + p.name, p.type);
                    setter.invoke((Object)ai, v);
                    continue;
                }
                if (p.type == String.class) {
                    f = (JFormattedTextField)this.AIOptionsPanelComponents[player].get(p.name);
                    Method setter3 = ai.getClass().getMethod("set" + p.name, p.type);
                    setter3.invoke((Object)ai, ((JTextComponent)f).getText());
                    continue;
                }
                if (p.type == Boolean.TYPE) {
                    f = (JCheckBox)this.AIOptionsPanelComponents[player].get(p.name);
                    Method setter4 = ai.getClass().getMethod("set" + p.name, p.type);
                    setter4.invoke((Object)ai, ((AbstractButton)f).isSelected());
                    continue;
                }
                f = (JComboBox)this.AIOptionsPanelComponents[player].get(p.name);
                Method setter5 = ai.getClass().getMethod("set" + p.name, p.type);
                setter5.invoke((Object)ai, ((JComboBox)f).getSelectedItem());
            }
            if (this.continuingBox[player].isSelected() && ai instanceof AIWithComputationBudget) {
                ai = ai instanceof InterruptibleAI ? new ContinuingAI(ai) : new PseudoContinuingAI((AIWithComputationBudget)ai);
            }
            return ai;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AI createAIInternal(int idx, int player, UnitTypeTable utt) throws Exception {
        if (AIs[idx] == MouseController.class) {
            return new MouseController(null);
        }
        Constructor cons = AIs[idx].getConstructor(UnitTypeTable.class);
        AI AI_instance = (AI)cons.newInstance(utt);
        return AI_instance;
    }

    private void updateAIOptions(JPanel jPanel, int player) throws Exception {
        HashMap components = this.AIOptionsPanelComponents[player];
        jPanel.removeAll();
        components.clear();
        AI AIInstance = this.createAIInternal(this.aiComboBox[player].getSelectedIndex(), 0, this.currentUtt);
        List<ParameterSpecification> parameters = AIInstance.getParameters();
        for (ParameterSpecification p : parameters) {
            JComboBox<Object> c;
            int defaultValue;
            JPanel ptmp;
            JComponent c2;
            if (p.type == Integer.TYPE || p.type == Long.TYPE || p.type == Float.TYPE || p.type == Double.TYPE || p.type == String.class) {
                c2 = FEStatePane.addTextField(jPanel, p.name, p.defaultValue.toString(), p.defaultValue.toString().length() + 1);
                components.put(p.name, c2);
                continue;
            }
            if (p.type == Boolean.TYPE) {
                c2 = new JCheckBox(p.name);
                c2.setAlignmentX(0.5f);
                c2.setAlignmentY(0.0f);
                c2.setMaximumSize(new Dimension(120, 20));
                ((AbstractButton)c2).setSelected((Boolean)p.defaultValue);
                jPanel.add(c2);
                components.put(p.name, c2);
                continue;
            }
            if (p.type == PathFinding.class) {
                ptmp = new JPanel();
                ptmp.setLayout(new BoxLayout(ptmp, 0));
                ptmp.add(new JLabel(p.name));
                defaultValue = 0;
                PathFinding[] PFSNames = new PathFinding[this.pathFinders.length];
                for (int i = 0; i < this.pathFinders.length; ++i) {
                    PFSNames[i] = this.pathFinders[i];
                    if (this.pathFinders[i].getClass() != p.defaultValue.getClass()) continue;
                    defaultValue = i;
                }
                c = new JComboBox<PathFinding>(PFSNames);
                c.setAlignmentX(0.5f);
                c.setAlignmentY(0.0f);
                c.setMaximumSize(new Dimension(300, 24));
                c.setSelectedIndex(defaultValue);
                ptmp.add(c);
                jPanel.add(ptmp);
                components.put(p.name, c);
                continue;
            }
            if (p.type == EvaluationFunction.class) {
                ptmp = new JPanel();
                ptmp.setLayout(new BoxLayout(ptmp, 0));
                ptmp.add(new JLabel(p.name));
                defaultValue = 0;
                EvaluationFunction[] EFSNames = new EvaluationFunction[this.efs.length];
                for (int i = 0; i < this.efs.length; ++i) {
                    EFSNames[i] = this.efs[i];
                    if (this.efs[i].getClass() != p.defaultValue.getClass()) continue;
                    defaultValue = i;
                }
                c = new JComboBox<EvaluationFunction>(EFSNames);
                c.setAlignmentX(0.5f);
                c.setAlignmentY(0.0f);
                c.setMaximumSize(new Dimension(300, 24));
                c.setSelectedIndex(defaultValue);
                ptmp.add(c);
                jPanel.add(ptmp);
                components.put(p.name, c);
                continue;
            }
            if (p.type == AI.class) {
                int i;
                ptmp = new JPanel();
                ptmp.setLayout(new BoxLayout(ptmp, 0));
                ptmp.add(new JLabel(p.name));
                defaultValue = 0;
                AI[] AINames = null;
                if (p.possibleValues == null) {
                    AINames = new AI[this.PlayoutAIs.length];
                    for (i = 0; i < this.PlayoutAIs.length; ++i) {
                        AINames[i] = (AI)this.PlayoutAIs[i].getConstructor(UnitTypeTable.class).newInstance(this.currentUtt);
                        if (this.PlayoutAIs[i] != p.defaultValue.getClass()) continue;
                        defaultValue = i;
                    }
                } else {
                    AINames = new AI[p.possibleValues.size()];
                    for (i = 0; i < p.possibleValues.size(); ++i) {
                        AINames[i] = (AI)p.possibleValues.get(i);
                        if (p.possibleValues.get(i) != p.defaultValue) continue;
                        defaultValue = i;
                    }
                }
                c = new JComboBox<AI>(AINames);
                c.setAlignmentX(0.5f);
                c.setAlignmentY(0.0f);
                c.setMaximumSize(new Dimension(300, 24));
                c.setSelectedIndex(defaultValue);
                ptmp.add(c);
                jPanel.add(ptmp);
                components.put(p.name, c);
                continue;
            }
            if (p.type == UnitActionProbabilityDistribution.class) {
                ptmp = new JPanel();
                ptmp.setLayout(new BoxLayout(ptmp, 0));
                ptmp.add(new JLabel(p.name));
                defaultValue = 0;
                UnitActionProbabilityDistribution[] names = null;
                names = new UnitActionProbabilityDistribution[p.possibleValues.size()];
                for (int i = 0; i < p.possibleValues.size(); ++i) {
                    names[i] = (UnitActionProbabilityDistribution)p.possibleValues.get(i);
                    if (p.possibleValues.get(i) != p.defaultValue) continue;
                    defaultValue = i;
                }
                c = new JComboBox<UnitActionProbabilityDistribution>(names);
                c.setAlignmentX(0.5f);
                c.setAlignmentY(0.0f);
                c.setMaximumSize(new Dimension(300, 24));
                c.setSelectedIndex(defaultValue);
                ptmp.add(c);
                jPanel.add(ptmp);
                components.put(p.name, c);
                continue;
            }
            if (p.possibleValues != null) {
                ptmp = new JPanel();
                ptmp.setLayout(new BoxLayout(ptmp, 0));
                ptmp.add(new JLabel(p.name));
                defaultValue = 0;
                Object[] options = new Object[p.possibleValues.size()];
                for (int i = 0; i < p.possibleValues.size(); ++i) {
                    options[i] = p.possibleValues.get(i);
                    if (!p.possibleValues.get(i).equals(p.defaultValue)) continue;
                    defaultValue = i;
                }
                c = new JComboBox<Object>(options);
                c.setAlignmentX(0.5f);
                c.setAlignmentY(0.0f);
                c.setMaximumSize(new Dimension(300, 24));
                c.setSelectedIndex(defaultValue);
                ptmp.add(c);
                jPanel.add(ptmp);
                components.put(p.name, c);
                continue;
            }
            throw new Exception("Cannot create GUI component for class" + p.type.getName());
        }
        jPanel.revalidate();
    }
}

