/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import ai.core.AI;
import gui.JTextAreaWriter;
import gui.frontend.FEStatePane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import rts.units.UnitTypeTable;
import tournaments.FixedOpponentsTournament;
import tournaments.LoadTournamentAIs;
import tournaments.RoundRobinTournament;

public class FETournamentPane
extends JPanel {
    private static final String TOURNAMENT_ROUNDROBIN = "Round Robin";
    private static final String TOURNAMENT_FIXED_OPPONENTS = "Fixed Opponents";
    private JComboBox tournamentTypeComboBox;
    private DefaultListModel availableAIsListModel;
    private JList availableAIsList;
    private DefaultListModel selectedAIsListModel;
    private JList selectedAIsList;
    private DefaultListModel opponentAIsListModel;
    private JList opponentAIsList;
    private JButton opponentAddButton;
    private JButton opponentRemoveButton;
    private JFileChooser mapFileChooser = new JFileChooser();
    private JList mapList;
    private DefaultListModel mapListModel;
    private JFormattedTextField iterationsField;
    private JFormattedTextField maxGameLengthField;
    private JFormattedTextField timeBudgetField;
    private JFormattedTextField iterationsBudgetField;
    private JFormattedTextField preAnalysisTimeField;
    private JComboBox unitTypeTableBox;
    private JCheckBox fullObservabilityCheckBox;
    private JCheckBox selfMatchesCheckBox;
    private JCheckBox timeoutCheckBox;
    private JCheckBox gcCheckBox;
    private JCheckBox tracesCheckBox;
    private JTextArea tournamentProgressTextArea;
    private JFileChooser fileChooser = new JFileChooser();

    public FETournamentPane() {
        this.setLayout(new BoxLayout(this, 1));
        String[] tournamentTypes = new String[]{TOURNAMENT_ROUNDROBIN, TOURNAMENT_FIXED_OPPONENTS};
        this.tournamentTypeComboBox = new JComboBox<String>(tournamentTypes);
        this.tournamentTypeComboBox.setAlignmentX(0.5f);
        this.tournamentTypeComboBox.setAlignmentY(0.0f);
        this.tournamentTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                if (combo.getSelectedIndex() == 1) {
                    FETournamentPane.this.opponentAIsList.setEnabled(true);
                    FETournamentPane.this.opponentAddButton.setEnabled(true);
                    FETournamentPane.this.opponentRemoveButton.setEnabled(true);
                } else {
                    FETournamentPane.this.opponentAIsList.setEnabled(false);
                    FETournamentPane.this.opponentAddButton.setEnabled(false);
                    FETournamentPane.this.opponentRemoveButton.setEnabled(false);
                }
            }
        });
        this.tournamentTypeComboBox.setMaximumSize(new Dimension(300, 24));
        this.add(this.tournamentTypeComboBox);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel p1left = new JPanel();
        p1left.setLayout(new BoxLayout(p1left, 1));
        p1left.add(new JLabel("Available AIs"));
        this.availableAIsListModel = new DefaultListModel();
        for (int i = 0; i < FEStatePane.AIs.length; ++i) {
            this.availableAIsListModel.addElement(FEStatePane.AIs[i]);
        }
        this.availableAIsList = new JList(this.availableAIsListModel);
        this.availableAIsList.setSelectionMode(2);
        this.availableAIsList.setLayoutOrientation(0);
        this.availableAIsList.setVisibleRowCount(-1);
        JScrollPane listScroller = new JScrollPane(this.availableAIsList);
        listScroller.setPreferredSize(new Dimension(200, 200));
        p1left.add(listScroller);
        JButton loadJAR = new JButton("Load Specific JAR");
        loadJAR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FETournamentPane.this.fileChooser.setFileSelectionMode(0);
                int returnVal = FETournamentPane.this.fileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = FETournamentPane.this.fileChooser.getSelectedFile();
                    try {
                        List<Class> cl = LoadTournamentAIs.loadTournamentAIsFromJAR(file.getAbsolutePath());
                        for (Class c : cl) {
                            boolean exists = false;
                            for (int i = 0; i < FETournamentPane.this.availableAIsListModel.size(); ++i) {
                                Class c2 = (Class)FETournamentPane.this.availableAIsListModel.get(i);
                                if (!c2.getName().equals(c.getName())) continue;
                                exists = true;
                                break;
                            }
                            if (exists) continue;
                            FETournamentPane.this.availableAIsListModel.addElement(c);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        p1left.add(loadJAR);
        JButton loadJARFolder = new JButton("Load All JARS from Folder");
        loadJARFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FETournamentPane.this.fileChooser.setFileSelectionMode(1);
                int returnVal = FETournamentPane.this.fileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = FETournamentPane.this.fileChooser.getSelectedFile();
                    try {
                        List<Class> cl = LoadTournamentAIs.loadTournamentAIsFromFolder(file.getAbsolutePath());
                        for (Class c : cl) {
                            boolean exists = false;
                            for (int i = 0; i < FETournamentPane.this.availableAIsListModel.size(); ++i) {
                                Class c2 = (Class)FETournamentPane.this.availableAIsListModel.get(i);
                                if (!c2.getName().equals(c.getName())) continue;
                                exists = true;
                                break;
                            }
                            if (exists) continue;
                            FETournamentPane.this.availableAIsListModel.addElement(c);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        p1left.add(loadJARFolder);
        p1.add(p1left);
        JPanel p1center = new JPanel();
        p1center.setLayout(new BoxLayout(p1center, 1));
        p1center.add(new JLabel("Selected AIs"));
        this.selectedAIsListModel = new DefaultListModel();
        this.selectedAIsList = new JList(this.selectedAIsListModel);
        this.selectedAIsList.setSelectionMode(0);
        this.selectedAIsList.setLayoutOrientation(0);
        this.selectedAIsList.setVisibleRowCount(-1);
        listScroller = new JScrollPane(this.selectedAIsList);
        listScroller.setPreferredSize(new Dimension(200, 200));
        p1center.add(listScroller);
        JButton add = new JButton("+");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected;
                for (int idx : selected = FETournamentPane.this.availableAIsList.getSelectedIndices()) {
                    FETournamentPane.this.selectedAIsListModel.addElement(FETournamentPane.this.availableAIsList.getModel().getElementAt(idx));
                }
            }
        });
        p1center.add(add);
        JButton remove = new JButton("-");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = FETournamentPane.this.selectedAIsList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    FETournamentPane.this.selectedAIsListModel.remove(selectedIndex);
                }
            }
        });
        p1center.add(remove);
        p1.add(p1center);
        JPanel p1right = new JPanel();
        p1right.setLayout(new BoxLayout(p1right, 1));
        p1right.add(new JLabel("Opponent AIs"));
        this.opponentAIsListModel = new DefaultListModel();
        this.opponentAIsList = new JList(this.opponentAIsListModel);
        this.opponentAIsList.setSelectionMode(2);
        this.opponentAIsList.setLayoutOrientation(0);
        this.opponentAIsList.setVisibleRowCount(-1);
        listScroller = new JScrollPane(this.opponentAIsList);
        listScroller.setPreferredSize(new Dimension(200, 200));
        p1right.add(listScroller);
        this.opponentAddButton = new JButton("+");
        this.opponentAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected;
                for (int idx : selected = FETournamentPane.this.availableAIsList.getSelectedIndices()) {
                    FETournamentPane.this.opponentAIsListModel.addElement(FETournamentPane.this.availableAIsList.getModel().getElementAt(idx));
                }
            }
        });
        p1right.add(this.opponentAddButton);
        this.opponentRemoveButton = new JButton("-");
        this.opponentRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = FETournamentPane.this.opponentAIsList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    FETournamentPane.this.opponentAIsListModel.remove(selectedIndex);
                }
            }
        });
        p1right.add(this.opponentRemoveButton);
        p1.add(p1right);
        this.opponentAIsList.setEnabled(false);
        this.opponentAddButton.setEnabled(false);
        this.opponentRemoveButton.setEnabled(false);
        this.add(p1);
        this.add(new JSeparator(0));
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JPanel p2maps = new JPanel();
        p2maps.setLayout(new BoxLayout(p2maps, 1));
        p2maps.add(new JLabel("Maps"));
        this.mapListModel = new DefaultListModel();
        this.mapList = new JList(this.mapListModel);
        this.mapList.setSelectionMode(0);
        this.mapList.setLayoutOrientation(0);
        this.mapList.setVisibleRowCount(-1);
        listScroller = new JScrollPane(this.mapList);
        listScroller.setPreferredSize(new Dimension(200, 100));
        p2maps.add(listScroller);
        add = new JButton("+");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = FETournamentPane.this.mapFileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = FETournamentPane.this.mapFileChooser.getSelectedFile();
                    try {
                        FETournamentPane.this.mapListModel.addElement(file.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        p2maps.add(add);
        remove = new JButton("-");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = FETournamentPane.this.mapList.getSelectedIndex();
                if (selected >= 0) {
                    FETournamentPane.this.mapListModel.remove(selected);
                }
            }
        });
        p2maps.add(remove);
        p2.add(p2maps);
        p2.add(new JSeparator(1));
        JPanel p2left = new JPanel();
        p2left.setLayout(new BoxLayout(p2left, 1));
        this.iterationsField = FEStatePane.addTextField(p2left, "Iterations:", "10", 4);
        this.maxGameLengthField = FEStatePane.addTextField(p2left, "Max Game Length:", "3000", 4);
        this.timeBudgetField = FEStatePane.addTextField(p2left, "Time Budget:", "100", 5);
        this.iterationsBudgetField = FEStatePane.addTextField(p2left, "Iterations Budget:", "-1", 8);
        this.preAnalysisTimeField = FEStatePane.addTextField(p2left, "pre-Analisys time budget:", "1000", 8);
        p2left.setMaximumSize(new Dimension(1000, 1000));
        p2.add(p2left);
        p2.add(new JSeparator(1));
        JPanel p2right = new JPanel();
        p2right.setLayout(new BoxLayout(p2right, 1));
        JPanel ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 0));
        ptmp.add(new JLabel("UnitTypeTable"));
        this.unitTypeTableBox = new JComboBox<String>(FEStatePane.unitTypeTableNames);
        this.unitTypeTableBox.setAlignmentX(0.5f);
        this.unitTypeTableBox.setAlignmentY(0.5f);
        this.unitTypeTableBox.setMaximumSize(new Dimension(160, 20));
        ptmp.add(this.unitTypeTableBox);
        p2right.setMaximumSize(new Dimension(1000, 1000));
        p2right.add(ptmp);
        this.fullObservabilityCheckBox = new JCheckBox("Full Obsservability");
        this.fullObservabilityCheckBox.setSelected(true);
        p2right.add(this.fullObservabilityCheckBox);
        this.selfMatchesCheckBox = new JCheckBox("Include self-play matches");
        this.selfMatchesCheckBox.setSelected(false);
        p2right.add(this.selfMatchesCheckBox);
        this.timeoutCheckBox = new JCheckBox("Game over if AI times out");
        this.timeoutCheckBox.setSelected(true);
        p2right.add(this.timeoutCheckBox);
        this.gcCheckBox = new JCheckBox("Call garbage collector right before each AI call");
        this.gcCheckBox.setSelected(false);
        p2right.add(this.gcCheckBox);
        this.tracesCheckBox = new JCheckBox("Save game traces");
        this.tracesCheckBox.setSelected(false);
        p2right.add(this.tracesCheckBox);
        p2.add(p2right);
        this.add(p2);
        JButton run = new JButton("Run Tournament");
        this.add(run);
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String tracesFolder;
                    File file;
                    Constructor cons;
                    Class c;
                    int i;
                    final UnitTypeTable utt = FEStatePane.unitTypeTables[FETournamentPane.this.unitTypeTableBox.getSelectedIndex()];
                    String tournamentType = (String)FETournamentPane.this.tournamentTypeComboBox.getSelectedItem();
                    final ArrayList<AI> selectedAIs = new ArrayList<AI>();
                    final ArrayList<AI> opponentAIs = new ArrayList<AI>();
                    final ArrayList<String> maps = new ArrayList<String>();
                    for (i = 0; i < FETournamentPane.this.selectedAIsListModel.getSize(); ++i) {
                        c = (Class)FETournamentPane.this.selectedAIsListModel.get(i);
                        cons = c.getConstructor(UnitTypeTable.class);
                        selectedAIs.add((AI)cons.newInstance(utt));
                    }
                    for (i = 0; i < FETournamentPane.this.opponentAIsListModel.getSize(); ++i) {
                        c = (Class)FETournamentPane.this.opponentAIsListModel.get(i);
                        cons = c.getConstructor(UnitTypeTable.class);
                        opponentAIs.add((AI)cons.newInstance(utt));
                    }
                    for (i = 0; i < FETournamentPane.this.mapListModel.getSize(); ++i) {
                        String mapname = (String)FETournamentPane.this.mapListModel.getElementAt(i);
                        maps.add(mapname);
                    }
                    final int iterations = Integer.parseInt(FETournamentPane.this.iterationsField.getText());
                    final int maxGameLength = Integer.parseInt(FETournamentPane.this.maxGameLengthField.getText());
                    final int timeBudget = Integer.parseInt(FETournamentPane.this.timeBudgetField.getText());
                    final int iterationsBudget = Integer.parseInt(FETournamentPane.this.iterationsBudgetField.getText());
                    final int preAnalysisBudget = Integer.parseInt(FETournamentPane.this.preAnalysisTimeField.getText());
                    final boolean fullObservability = FETournamentPane.this.fullObservabilityCheckBox.isSelected();
                    final boolean selfMatches = FETournamentPane.this.selfMatchesCheckBox.isSelected();
                    final boolean timeOutCheck = FETournamentPane.this.timeoutCheckBox.isSelected();
                    final boolean gcCheck = FETournamentPane.this.gcCheckBox.isSelected();
                    final boolean preGameAnalysis = preAnalysisBudget > 0;
                    String prefix = "tournament_";
                    int idx = 0;
                    while ((file = new File(prefix + ++idx)).exists()) {
                    }
                    file.mkdir();
                    final String tournamentfolder = file.getName();
                    final File fileToUse = new File(tournamentfolder + "/tournament.csv");
                    String string = tracesFolder = FETournamentPane.this.tracesCheckBox.isSelected() ? tournamentfolder + "/traces" : null;
                    if (tournamentType.equals(FETournamentPane.TOURNAMENT_ROUNDROBIN)) {
                        if (selectedAIs.size() < 2) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least two AIs\n");
                        } else if (maps.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one map\n");
                        } else {
                            try {
                                Runnable r = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileWriter writer = new FileWriter(fileToUse);
                                            JTextAreaWriter writerProgress = new JTextAreaWriter(FETournamentPane.this.tournamentProgressTextArea);
                                            new RoundRobinTournament(selectedAIs).runTournament(-1, maps, iterations, maxGameLength, timeBudget, iterationsBudget, preAnalysisBudget, 1000L, fullObservability, selfMatches, timeOutCheck, gcCheck, preGameAnalysis, utt, tracesFolder, writer, writerProgress, tournamentfolder);
                                            ((Writer)writer).close();
                                        }
                                        catch (Exception e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                };
                                new Thread(r).start();
                            }
                            catch (Exception e3) {
                                e3.printStackTrace();
                            }
                        }
                    } else if (tournamentType.equals(FETournamentPane.TOURNAMENT_FIXED_OPPONENTS)) {
                        if (selectedAIs.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one AI\n");
                        } else if (opponentAIs.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one opponent AI\n");
                        } else if (maps.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one map\n");
                        } else {
                            try {
                                Runnable r = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileWriter writer = new FileWriter(fileToUse);
                                            JTextAreaWriter writerProgress = new JTextAreaWriter(FETournamentPane.this.tournamentProgressTextArea);
                                            new FixedOpponentsTournament(selectedAIs, opponentAIs).runTournament(maps, iterations, maxGameLength, timeBudget, iterationsBudget, preAnalysisBudget, 1000L, fullObservability, timeOutCheck, gcCheck, preGameAnalysis, utt, tracesFolder, writer, writerProgress, tournamentfolder);
                                            ((Writer)writer).close();
                                        }
                                        catch (Exception e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                };
                                new Thread(r).start();
                            }
                            catch (Exception e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.tournamentProgressTextArea = new JTextArea(5, 20);
        JScrollPane scrollPane = new JScrollPane(this.tournamentProgressTextArea);
        this.tournamentProgressTextArea.setEditable(false);
        scrollPane.setPreferredSize(new Dimension(512, 192));
        this.add(scrollPane);
        DefaultCaret caret = (DefaultCaret)this.tournamentProgressTextArea.getCaret();
        caret.setUpdatePolicy(2);
    }
}

