/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import gui.PhysicalGameStatePanel;
import gui.frontend.FEStatePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.zip.ZipInputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jdom.input.SAXBuilder;
import rts.GameState;
import rts.Trace;
import rts.TraceEntry;
import util.XMLWriter;

public class FETracePane
extends JPanel {
    Trace currentTrace;
    int currentGameCycle = 0;
    PhysicalGameStatePanel statePanel;
    JFileChooser fileChooser = new JFileChooser();
    FEStatePane stateTab;

    public FETracePane(FEStatePane a_stateTab) {
        this.stateTab = a_stateTab;
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel p1west = new JPanel();
        p1west.setLayout(new BoxLayout(p1west, 1));
        JButton b = new JButton("Load Trace");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = FETracePane.this.fileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = FETracePane.this.fileChooser.getSelectedFile();
                    try {
                        if (file.getAbsolutePath().endsWith(".zip")) {
                            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
                            zip.getNextEntry();
                            FETracePane.this.currentTrace = new Trace(new SAXBuilder().build(zip).getRootElement());
                        } else {
                            FETracePane.this.currentTrace = new Trace(new SAXBuilder().build(file.getAbsolutePath()).getRootElement());
                        }
                        FETracePane.this.currentGameCycle = 0;
                        FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                        FETracePane.this.statePanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        p1west.add(b);
        b = new JButton("Save State");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = FETracePane.this.fileChooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = FETracePane.this.fileChooser.getSelectedFile();
                    try {
                        XMLWriter xml = new XMLWriter(new FileWriter(file.getAbsolutePath()));
                        FETracePane.this.statePanel.getState().getPhysicalGameState().toxml(xml);
                        xml.flush();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        p1west.add(b);
        b = new JButton("Copy to state tab");
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FETracePane.this.stateTab.setState(FETracePane.this.statePanel.getState().clone());
            }
        });
        p1west.add(b);
        JPanel p1east = new JPanel();
        p1east.setLayout(new BoxLayout(p1east, 1));
        JButton b2 = new JButton("+1 Frame");
        b2.setAlignmentX(0.5f);
        b2.setAlignmentY(0.0f);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FETracePane.this.statePanel.getState().gameover()) {
                    ++FETracePane.this.currentGameCycle;
                    GameState tmp_gs = FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle);
                    FETracePane.this.statePanel.setStateDirect(tmp_gs);
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        p1east.add(b2);
        b2 = new JButton("-1 Frame");
        b2.setAlignmentX(0.5f);
        b2.setAlignmentY(0.0f);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FETracePane.this.currentGameCycle > 0) {
                    --FETracePane.this.currentGameCycle;
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        p1east.add(b2);
        b2 = new JButton("+1 Action");
        b2.setAlignmentX(0.5f);
        b2.setAlignmentY(0.0f);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (TraceEntry te : FETracePane.this.currentTrace.getEntries()) {
                    if (te.getTime() <= FETracePane.this.currentGameCycle) continue;
                    FETracePane.this.currentGameCycle = te.getTime();
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                    break;
                }
            }
        });
        p1east.add(b2);
        b2 = new JButton("-1 Action");
        b2.setAlignmentX(0.5f);
        b2.setAlignmentY(0.0f);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceEntry target = null;
                for (TraceEntry te : FETracePane.this.currentTrace.getEntries()) {
                    if (te.getTime() >= FETracePane.this.currentGameCycle || target != null && te.getTime() <= target.getTime()) continue;
                    target = te;
                }
                if (target != null) {
                    FETracePane.this.currentGameCycle = target.getTime();
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        p1east.add(b2);
        p1.add(p1west);
        p1.add(p1east);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        this.statePanel = new PhysicalGameStatePanel((GameState)null);
        this.statePanel.setPreferredSize(new Dimension(512, 512));
        p2.add(this.statePanel);
        this.add((Component)p1, "North");
        this.add((Component)p2, "South");
    }
}

