/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import gui.PhysicalGameStatePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class PopUpStateEditorMenu
extends JPopupMenu {
    public PopUpStateEditorMenu(final GameState gs, UnitTypeTable utt, final int x, final int y, final PhysicalGameStatePanel panel) {
        final PhysicalGameState pgs = gs.getPhysicalGameState();
        final Unit u = pgs.getUnitAt(x, y);
        if (u == null) {
            if (pgs.getTerrain(x, y) == 0) {
                JMenuItem i1 = new JMenuItem("Set wall");
                i1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        pgs.setTerrain(x, y, 1);
                        panel.gameStateUpdated();
                        panel.repaint();
                    }
                });
                this.add(i1);
                for (final UnitType ut : utt.getUnitTypes()) {
                    JMenuItem i2;
                    if (ut.isResource) {
                        i2 = new JMenuItem("Add " + ut.name + "");
                        i2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                pgs.addUnit(new Unit(-1, ut, x, y, 10));
                                panel.gameStateUpdated();
                                panel.repaint();
                            }
                        });
                        this.add(i2);
                        continue;
                    }
                    i2 = new JMenuItem("Add " + ut.name + " (player 0)");
                    i2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            pgs.addUnit(new Unit(0, ut, x, y, 0));
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i2);
                    JMenuItem i3 = new JMenuItem("Add " + ut.name + " (player 1)");
                    i3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            pgs.addUnit(new Unit(1, ut, x, y, 0));
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i3);
                }
            } else {
                JMenuItem i1 = new JMenuItem("Set walkable");
                i1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        pgs.setTerrain(x, y, 0);
                        panel.gameStateUpdated();
                        panel.repaint();
                    }
                });
                this.add(i1);
            }
        } else {
            JMenuItem i2;
            JMenuItem i1 = new JMenuItem("Remove " + u.getType().name);
            i1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    pgs.removeUnit(u);
                    panel.gameStateUpdated();
                    panel.repaint();
                }
            });
            this.add(i1);
            if (u.getType().isResource || u.getType().canHarvest) {
                if (u.getResources() > 0) {
                    i2 = new JMenuItem("-1 resource");
                    i2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            u.setResources(u.getResources() - 1);
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i2);
                }
                if (u.getType().isResource || u.getResources() == 0) {
                    i2 = new JMenuItem("+1 resource");
                    i2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            u.setResources(u.getResources() + 1);
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i2);
                }
                if (u.getResources() > 9) {
                    i2 = new JMenuItem("-10 resource");
                    i2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            u.setResources(u.getResources() - 10);
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i2);
                }
                if (u.getType().isResource) {
                    i2 = new JMenuItem("+10 resource");
                    i2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            u.setResources(u.getResources() + 10);
                            panel.gameStateUpdated();
                            panel.repaint();
                        }
                    });
                    this.add(i2);
                }
            }
            if (gs.getUnitAction(u) == null) {
                if (u.getPlayer() != -1) {
                    List<UnitAction> actions2 = u.getUnitActions(gs, 10);
                    for (final UnitAction ua : actions2) {
                        JMenuItem i22 = new JMenuItem(ua.toString());
                        i22.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                PlayerAction pa = new PlayerAction();
                                pa.addUnitAction(u, ua);
                                gs.issue(pa);
                                panel.gameStateUpdated();
                                panel.repaint();
                            }
                        });
                        this.add(i22);
                    }
                }
            } else {
                i2 = new JMenuItem("Cancel action");
                i2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        gs.getUnitActions().remove(u);
                        panel.gameStateUpdated();
                        panel.repaint();
                    }
                });
                this.add(i2);
            }
        }
    }
}

