/*
 * Decompiled with CFR 0.152.
 */
package rts;

import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.lang.reflect.Constructor;
import javax.swing.JFrame;
import rts.GameSettings;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class Game {
    private UnitTypeTable utt;
    protected GameState gs;
    protected AI ai1;
    protected AI ai2;
    private boolean partiallyObservable;
    private boolean headless;
    private int maxCycles;
    private int updateInterval;

    public Game(GameSettings gameSettings) throws Exception {
        this(new UnitTypeTable(gameSettings.getUTTVersion(), gameSettings.getConflictPolicy()), gameSettings.getMapLocation(), gameSettings.isHeadless(), gameSettings.isPartiallyObservable(), gameSettings.getMaxCycles(), gameSettings.getUpdateInterval(), gameSettings.getAI1(), gameSettings.getAI2());
    }

    public Game(UnitTypeTable utt, String mapLocation, boolean headless, boolean partiallyObservable, int maxCycles, int updateInterval, String ai1, String ai2) throws Exception {
        this(utt, mapLocation, headless, partiallyObservable, maxCycles, updateInterval);
        Constructor<?> cons1 = Class.forName(ai1).getConstructor(UnitTypeTable.class);
        Constructor<?> cons2 = Class.forName(ai2).getConstructor(UnitTypeTable.class);
        this.ai1 = (AI)cons1.newInstance(utt);
        this.ai2 = (AI)cons2.newInstance(utt);
    }

    public Game(UnitTypeTable utt, String mapLocation, boolean headless, boolean partiallyObservable, int maxCycles, int updateInterval, AI ai1, AI ai2) throws Exception {
        this(utt, mapLocation, headless, partiallyObservable, maxCycles, updateInterval);
        this.ai1 = ai1;
        this.ai2 = ai2;
    }

    private Game(UnitTypeTable utt, String mapLocation, boolean headless, boolean partiallyObservable, int maxCycles, int updateInterval) throws Exception {
        PhysicalGameState pgs = PhysicalGameState.load(mapLocation, utt);
        this.gs = new GameState(pgs, utt);
        this.partiallyObservable = partiallyObservable;
        this.headless = headless;
        this.maxCycles = maxCycles;
        this.updateInterval = updateInterval;
    }

    public Game(GameSettings gameSettings, AI player_one, AI player_two) throws Exception {
        UnitTypeTable utt = new UnitTypeTable(gameSettings.getUTTVersion(), gameSettings.getConflictPolicy());
        PhysicalGameState pgs = PhysicalGameState.load(gameSettings.getMapLocation(), utt);
        this.gs = new GameState(pgs, utt);
        this.partiallyObservable = gameSettings.isPartiallyObservable();
        this.headless = gameSettings.isHeadless();
        this.maxCycles = gameSettings.getMaxCycles();
        this.updateInterval = gameSettings.getUpdateInterval();
        this.ai1 = player_one;
        this.ai2 = player_two;
    }

    public void start() throws Exception {
        PhysicalGameStateJFrame w = this.headless ? null : PhysicalGameStatePanel.newVisualizer(this.gs, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        this.start(w);
    }

    public void start(JFrame w) throws Exception {
        this.ai1.reset();
        this.ai2.reset();
        this.ai1.preGameAnalysis(this.gs, 0L);
        this.ai2.preGameAnalysis(this.gs, 0L);
        boolean gameover = false;
        while (!gameover && this.gs.getTime() < this.maxCycles) {
            long timeToNextUpdate = System.currentTimeMillis() + (long)this.updateInterval;
            GameState playerOneGameState = this.partiallyObservable ? new PartiallyObservableGameState(this.gs, 0) : this.gs;
            GameState playerTwoGameState = this.partiallyObservable ? new PartiallyObservableGameState(this.gs, 1) : this.gs;
            PlayerAction pa1 = this.ai1.getAction(0, playerOneGameState);
            PlayerAction pa2 = this.ai2.getAction(1, playerTwoGameState);
            this.gs.issueSafe(pa1);
            this.gs.issueSafe(pa2);
            gameover = this.gs.cycle();
            if (w == null) continue;
            if (!w.isVisible()) break;
            long waitTime = timeToNextUpdate - System.currentTimeMillis();
            if (waitTime >= 0L) {
                try {
                    Thread.sleep(waitTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            w.repaint();
        }
        this.ai1.gameOver(this.gs.winner());
        this.ai2.gameOver(this.gs.winner());
    }
}

