/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GameSettings {
    private String serverAddress = "localhost";
    private int serverPort = 9898;
    private LaunchMode launchMode = LaunchMode.GUI;
    private int serializationType = 2;
    private String mapLocation = "";
    private int maxCycles = 5000;
    private int updateInterval = 20;
    private boolean partiallyObservable = false;
    private int uttVersion = 1;
    private int conflictPolicy = 1;
    private boolean includeConstantsInState = true;
    private boolean compressTerrain = false;
    private boolean headless = false;
    private String AI2 = "ai.RandomAI";
    private String AI1 = "ai.RandomAI";

    static String getHelpMessage() {
        return "-f: path to config file\n-s: server IP address\n-p: server port\n-l: launch mode (STANDALONE, GUI, SERVER, CLIENT)\n--serialization: serialization type (1 for XML, 2 for JSON)\n-m: path for the map file\n-c: max cycles\n-i: update interval between each tick, in milliseconds\n--headless: 1 or true, 0 or false\n--partially_observable: 1 or true, 0 or false\n-u: unit type table version\n--conflict_policy: which conflict policy to use\n--ai1: name of the class to be instantiated for player 1\n--ai2: name of the class to be instantiated for player 2";
    }

    public GameSettings(LaunchMode launchMode, String serverAddress, int serverPort, int serializationType, String mapLocation, int maxCycles, int updateInterval, boolean partiallyObservable, int uttVersion, int confictPolicy, boolean includeConstantsInState, boolean compressTerrain, boolean headless, String AI1, String AI2) {
        this.launchMode = launchMode;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.serializationType = serializationType;
        this.mapLocation = mapLocation;
        this.maxCycles = maxCycles;
        this.updateInterval = updateInterval;
        this.partiallyObservable = partiallyObservable;
        this.uttVersion = uttVersion;
        this.conflictPolicy = confictPolicy;
        this.includeConstantsInState = includeConstantsInState;
        this.compressTerrain = compressTerrain;
        this.headless = headless;
        this.AI1 = AI1;
        this.AI2 = AI2;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getSerializationType() {
        return this.serializationType;
    }

    public String getMapLocation() {
        return this.mapLocation;
    }

    public int getMaxCycles() {
        return this.maxCycles;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public boolean isPartiallyObservable() {
        return this.partiallyObservable;
    }

    public int getUTTVersion() {
        return this.uttVersion;
    }

    public int getConflictPolicy() {
        return this.conflictPolicy;
    }

    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    public String getAI1() {
        return this.AI1;
    }

    public String getAI2() {
        return this.AI2;
    }

    public boolean isIncludeConstantsInState() {
        return this.includeConstantsInState;
    }

    public boolean isCompressTerrain() {
        return this.compressTerrain;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public GameSettings(String[] args) {
        this.overrideFromArgs(args);
    }

    public GameSettings overrideFromArgs(String[] args) {
        block30: for (int i = args.length; i > 0; --i) {
            switch (args[i - 1]) {
                case "-s": {
                    this.serverAddress = args[i];
                    continue block30;
                }
                case "-p": {
                    this.serverPort = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "-l": {
                    this.launchMode = LaunchMode.valueOf(args[i]);
                    continue block30;
                }
                case "--serialization": {
                    this.serializationType = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "-m": {
                    this.mapLocation = args[i];
                    continue block30;
                }
                case "-c": {
                    this.maxCycles = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "-i": {
                    this.updateInterval = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "--headless": {
                    this.headless = args[i].equals("1") || Boolean.parseBoolean(args[i]);
                    continue block30;
                }
                case "--partially_observable": {
                    this.partiallyObservable = args[i].equals("1") || Boolean.parseBoolean(args[i]);
                    continue block30;
                }
                case "-u": {
                    this.uttVersion = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "--conflict_policy": {
                    this.conflictPolicy = Integer.parseInt(args[i]);
                    continue block30;
                }
                case "--ai1": {
                    this.AI1 = args[i];
                    continue block30;
                }
                case "--ai2": {
                    this.AI2 = args[i];
                    continue block30;
                }
            }
        }
        return this;
    }

    public static Properties fetchDefaultConfig() throws IOException {
        Properties prop = new Properties();
        InputStream is = GameSettings.class.getResourceAsStream("/config.properties");
        if (is == null) {
            is = new FileInputStream("resources/config.properties");
        }
        prop.load(is);
        return prop;
    }

    public static Properties fetchConfig(String propertiesFile) throws IOException {
        Properties prop = new Properties();
        InputStream is = GameSettings.class.getResourceAsStream(propertiesFile);
        if (is == null) {
            is = new FileInputStream(propertiesFile);
        }
        prop.load(is);
        return prop;
    }

    public static GameSettings loadFromConfig(Properties prop) {
        assert (!prop.isEmpty());
        String serverAddress = prop.getProperty("server_address", "localhost");
        int serverPort = GameSettings.readIntegerProperty(prop, "server_port", 9898);
        int serializationType = GameSettings.readIntegerProperty(prop, "serialization_type", 2);
        String mapLocation = prop.getProperty("map_location");
        int maxCycles = GameSettings.readIntegerProperty(prop, "max_cycles", 5000);
        int updateInterval = GameSettings.readIntegerProperty(prop, "update_interval", 20);
        boolean partiallyObservable = Boolean.parseBoolean(prop.getProperty("partially_observable"));
        int uttVersion = GameSettings.readIntegerProperty(prop, "UTT_version", 2);
        int conflictPolicy = GameSettings.readIntegerProperty(prop, "conflict_policy", 1);
        LaunchMode launchMode = LaunchMode.valueOf(prop.getProperty("launch_mode", "GUI"));
        boolean includeConstantsInState = Boolean.parseBoolean(prop.getProperty("constants_in_state", "true"));
        boolean compressTerrain = Boolean.parseBoolean(prop.getProperty("compress_terrain", "false"));
        boolean headless = Boolean.parseBoolean(prop.getProperty("headless", "false"));
        String AI1 = prop.getProperty("AI1", "ai.RandomAI");
        String AI2 = prop.getProperty("AI2", "ai.RandomAI");
        return new GameSettings(launchMode, serverAddress, serverPort, serializationType, mapLocation, maxCycles, updateInterval, partiallyObservable, uttVersion, conflictPolicy, includeConstantsInState, compressTerrain, headless, AI1, AI2);
    }

    public static int readIntegerProperty(Properties prop, String name, int defaultValue) {
        String stringValue = prop.getProperty(name);
        if (stringValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(stringValue);
    }

    public String toString() {
        return "----------Game Settings----------\nRunning as Server: " + this.getLaunchMode().toString() + "\nServer Address: " + this.getServerAddress() + "\nServer Port: " + this.getServerPort() + "\nSerialization Type: " + this.getSerializationType() + "\nMap Location: " + this.getMapLocation() + "\nMax Cycles: " + this.getMaxCycles() + "\nPartially Observable: " + this.isPartiallyObservable() + "\nRules Version: " + this.getUTTVersion() + "\nConflict Policy: " + this.getConflictPolicy() + "\nAI1: " + this.getAI1() + "\nAI2: " + this.getAI2() + "\n------------------------------------------------";
    }

    public static enum LaunchMode {
        STANDALONE,
        HUMAN,
        GUI,
        SERVER,
        CLIENT;

    }
}

