/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class GameState {
    public static final boolean REPORT_ILLEGAL_ACTIONS = false;
    static Random r = new Random();
    protected int unitCancelationCounter = 0;
    protected int time = 0;
    protected PhysicalGameState pgs;
    protected HashMap<Unit, UnitActionAssignment> unitActions = new LinkedHashMap<Unit, UnitActionAssignment>();
    protected UnitTypeTable utt;

    public GameState(PhysicalGameState a_pgs, UnitTypeTable a_utt) {
        this.pgs = a_pgs;
        this.utt = a_utt;
    }

    public int getTime() {
        return this.time;
    }

    public void removeUnit(Unit u) {
        this.pgs.removeUnit(u);
        this.unitActions.remove(u);
    }

    public Player getPlayer(int ID) {
        return this.pgs.getPlayer(ID);
    }

    public Unit getUnit(long ID) {
        return this.pgs.getUnit(ID);
    }

    public List<Unit> getUnits() {
        return this.pgs.getUnits();
    }

    public HashMap<Unit, UnitActionAssignment> getUnitActions() {
        return this.unitActions;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public UnitAction getUnitAction(Unit u) {
        UnitActionAssignment uaa = this.unitActions.get(u);
        if (uaa == null) {
            return null;
        }
        return uaa.action;
    }

    public UnitActionAssignment getActionAssignment(Unit u) {
        return this.unitActions.get(u);
    }

    public boolean isComplete() {
        for (Unit u : this.pgs.units) {
            if (u.getPlayer() == -1) continue;
            UnitActionAssignment uaa = this.unitActions.get(u);
            if (uaa == null) {
                return false;
            }
            if (uaa.action != null) continue;
            return false;
        }
        return true;
    }

    public int winner() {
        return this.pgs.winner();
    }

    public boolean gameover() {
        return this.pgs.gameover();
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public boolean free(int x, int y) {
        if (this.pgs.getTerrain(x, y) != 0) {
            return false;
        }
        for (Unit u : this.pgs.units) {
            if (u.getX() != x || u.getY() != y) continue;
            return false;
        }
        for (UnitActionAssignment ua : this.unitActions.values()) {
            if (ua.action.type != 1 && ua.action.type != 4) continue;
            Unit u = ua.unit;
            if (ua.action.getDirection() == 0 && u.getX() == x && u.getY() == y + 1) {
                return false;
            }
            if (ua.action.getDirection() == 1 && u.getX() == x - 1 && u.getY() == y) {
                return false;
            }
            if (ua.action.getDirection() == 2 && u.getX() == x && u.getY() == y - 1) {
                return false;
            }
            if (ua.action.getDirection() != 3 || u.getX() != x + 1 || u.getY() != y) continue;
            return false;
        }
        return true;
    }

    public boolean[][] getAllFree() {
        boolean[][] free = this.pgs.getAllFree();
        for (UnitActionAssignment ua : this.unitActions.values()) {
            if (ua.action.type != 1 && ua.action.type != 4) continue;
            Unit u = ua.unit;
            if (ua.action.getDirection() == 0) {
                free[u.getX()][u.getY() - 1] = false;
            }
            if (ua.action.getDirection() == 1) {
                free[u.getX() + 1][u.getY()] = false;
            }
            if (ua.action.getDirection() == 2) {
                free[u.getX()][u.getY() + 1] = false;
            }
            if (ua.action.getDirection() != 3) continue;
            free[u.getX() - 1][u.getY()] = false;
        }
        return free;
    }

    public boolean observable(int x, int y) {
        return true;
    }

    public boolean issue(PlayerAction pa) {
        boolean returnValue = false;
        for (Pair<Unit, UnitAction> p : pa.actions) {
            ResourceUsage ru = ((UnitAction)p.m_b).resourceUsage((Unit)p.m_a, this.pgs);
            for (UnitActionAssignment uaa : this.unitActions.values()) {
                if (uaa.action.resourceUsage(uaa.unit, this.pgs).consistentWith(ru, this)) continue;
                if (uaa.time == this.time) {
                    boolean cancel_old = false;
                    boolean cancel_new = false;
                    switch (this.utt.getMoveConflictResolutionStrategy()) {
                        default: {
                            System.err.println("Unknown move conflict resolution strategy in the UnitTypeTable!: " + this.utt.getMoveConflictResolutionStrategy());
                            System.err.println("Defaulting to MOVE_CONFLICT_RESOLUTION_CANCEL_BOTH");
                        }
                        case 1: {
                            cancel_new = true;
                            cancel_old = true;
                            break;
                        }
                        case 2: {
                            if (r.nextInt(2) == 0) {
                                cancel_new = true;
                                break;
                            }
                            cancel_old = true;
                            break;
                        }
                        case 3: {
                            if (this.unitCancelationCounter % 2 == 0) {
                                cancel_new = true;
                            } else {
                                cancel_old = true;
                            }
                            ++this.unitCancelationCounter;
                        }
                    }
                    int duration1 = uaa.action.ETA(uaa.unit);
                    int duration2 = ((UnitAction)p.m_b).ETA((Unit)p.m_a);
                    if (cancel_old) {
                        uaa.action = new UnitAction(0, Math.min(duration1, duration2));
                    }
                    if (!cancel_new) continue;
                    p = new Pair(p.m_a, new UnitAction(0, Math.min(duration1, duration2)));
                    continue;
                }
                System.err.println("Inconsistent actions were executed!");
                System.err.println(uaa);
                System.err.println("  Resources: " + uaa.action.resourceUsage(uaa.unit, this.pgs));
                System.err.println(p.m_a + " assigned action " + p.m_b + " at time " + this.time);
                System.err.println("  Resources: " + ru);
                System.err.println("Player resources: " + this.pgs.getPlayer(0).getResources() + ", " + this.pgs.getPlayer(1).getResources());
                System.err.println("Resource Consistency: " + uaa.action.resourceUsage(uaa.unit, this.pgs).consistentWith(ru, this));
                try {
                    throw new Exception("dummy");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    p.m_b = new UnitAction(0);
                }
            }
            UnitActionAssignment uaa = new UnitActionAssignment((Unit)p.m_a, (UnitAction)p.m_b, this.time);
            this.unitActions.put((Unit)p.m_a, uaa);
            if (((UnitAction)p.m_b).type == 0) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public boolean issueSafe(PlayerAction pa) {
        if (!pa.integrityCheck()) {
            throw new Error("PlayerAction inconsistent before 'issueSafe'");
        }
        if (!this.integrityCheck()) {
            throw new Error("GameState inconsistent before 'issueSafe'");
        }
        for (Pair<Unit, UnitAction> p : pa.actions) {
            if (p.m_a == null) {
                System.err.println("Issuing an action to a null unit!!!");
                System.exit(1);
            }
            if (!((Unit)p.m_a).canExecuteAction((UnitAction)p.m_b, this)) {
                int l = ((UnitAction)p.m_b).ETA((Unit)p.m_a);
                p.m_b = new UnitAction(0, l);
            }
            if (this.pgs.units.indexOf(p.m_a) == -1) {
                boolean found = false;
                for (Unit u : this.pgs.units) {
                    if (u.getClass() != ((Unit)p.m_a).getClass() || u.getX() != ((Unit)p.m_a).getX() || u.getY() != ((Unit)p.m_a).getY()) continue;
                    p.m_a = u;
                    found = true;
                    break;
                }
                if (!found) {
                    System.err.println("Inconsistent order: " + pa);
                    System.err.println(this);
                    System.err.println("The problem was with unit " + p.m_a);
                }
            }
            ResourceUsage r = ((UnitAction)p.m_b).resourceUsage((Unit)p.m_a, this.pgs);
            Iterator<Serializable> iterator = r.getPositionsUsed().iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                int y = position / this.pgs.getWidth();
                int x = position % this.pgs.getWidth();
                if (this.pgs.getTerrain(x, y) == 0 && this.pgs.getUnitAt(x, y) == null) continue;
                UnitAction new_ua = new UnitAction(0, ((UnitAction)p.m_b).ETA((Unit)p.m_a));
                System.err.println("Player " + ((Unit)p.m_a).getPlayer() + " issued an illegal move action (to " + x + "," + y + ") to unit " + ((Unit)p.m_a).getID() + " at time " + this.getTime() + ", cancelling and replacing by " + new_ua);
                System.err.println("    Action: " + p.m_b);
                System.err.println("    Resources used by the action: " + r);
                System.err.println("    Unit at that coordinate " + this.pgs.getUnitAt(x, y));
                p.m_b = new_ua;
            }
        }
        boolean returnValue = this.issue(pa);
        if (!this.integrityCheck()) {
            throw new Error("GameState inconsistent after 'issueSafe': " + pa);
        }
        return returnValue;
    }

    public boolean canExecuteAnyAction(int pID) {
        for (Unit u : this.pgs.getUnits()) {
            if (u.getPlayer() != pID || this.unitActions.get(u) != null) continue;
            return true;
        }
        return false;
    }

    public boolean isUnitActionAllowed(Unit u, UnitAction ua) {
        PlayerAction empty = new PlayerAction();
        if (ua.getType() == 1) {
            int x2 = u.getX() + UnitAction.DIRECTION_OFFSET_X[ua.getDirection()];
            int y2 = u.getY() + UnitAction.DIRECTION_OFFSET_Y[ua.getDirection()];
            if (x2 < 0 || y2 < 0 || x2 >= this.getPhysicalGameState().getWidth() || y2 >= this.getPhysicalGameState().getHeight() || this.getPhysicalGameState().getTerrain(x2, y2) == 1 || this.getPhysicalGameState().getUnitAt(x2, y2) != null) {
                return false;
            }
        }
        for (Unit u2 : this.pgs.getUnits()) {
            UnitActionAssignment uaa = this.unitActions.get(u2);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u2, this.pgs);
            empty.r.merge(ru);
        }
        return ua.resourceUsage(u, this.pgs).consistentWith(empty.getResourceUsage(), this);
    }

    public List<PlayerAction> getPlayerActionsSingleUnit(Unit unit) {
        List<PlayerAction> l = new LinkedList<PlayerAction>();
        PlayerAction empty = new PlayerAction();
        l.add(empty);
        for (Unit u : this.pgs.getUnits()) {
            UnitActionAssignment uaa = this.unitActions.get(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, this.pgs);
            empty.r.merge(ru);
        }
        if (this.unitActions.get(unit) == null) {
            l = empty.cartesianProduct(unit.getUnitActions(this), unit, this);
        }
        return l;
    }

    public List<PlayerAction> getPlayerActions(int playerID) {
        LinkedList<PlayerAction> l = new LinkedList<PlayerAction>();
        PlayerAction empty = new PlayerAction();
        l.add(empty);
        for (Unit u : this.pgs.getUnits()) {
            UnitActionAssignment uaa = this.unitActions.get(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, this.pgs);
            empty.r.merge(ru);
        }
        for (Unit u : this.pgs.getUnits()) {
            if (u.getPlayer() != playerID || this.unitActions.get(u) != null) continue;
            LinkedList<PlayerAction> l2 = new LinkedList<PlayerAction>();
            for (PlayerAction pa : l) {
                l2.addAll(pa.cartesianProduct(u.getUnitActions(this), u, this));
            }
            l = l2;
        }
        return l;
    }

    public int getNextChangeTime() {
        int nextChangeTime = -1;
        for (Player player : this.pgs.players) {
            if (!this.canExecuteAnyAction(player.ID)) continue;
            return this.time;
        }
        for (UnitActionAssignment uaa : this.unitActions.values()) {
            int t = uaa.time + uaa.action.ETA(uaa.unit);
            if (nextChangeTime != -1 && t >= nextChangeTime) continue;
            nextChangeTime = t;
        }
        if (nextChangeTime == -1) {
            return this.time;
        }
        return nextChangeTime;
    }

    public boolean cycle() {
        ++this.time;
        LinkedList<UnitActionAssignment> readyToExecute = new LinkedList<UnitActionAssignment>();
        for (UnitActionAssignment uaa : this.unitActions.values()) {
            if (uaa.action.ETA(uaa.unit) + uaa.time > this.time) continue;
            readyToExecute.add(uaa);
        }
        for (UnitActionAssignment uaa : readyToExecute) {
            this.unitActions.remove(uaa.unit);
            uaa.action.execute(uaa.unit, this);
        }
        return this.gameover();
    }

    public void forceExecuteAllActions() {
        LinkedList<UnitActionAssignment> readyToExecute = new LinkedList<UnitActionAssignment>(this.unitActions.values());
        for (UnitActionAssignment uaa : readyToExecute) {
            this.unitActions.remove(uaa.unit);
            uaa.action.execute(uaa.unit, this);
        }
    }

    public GameState clone() {
        GameState gs = new GameState(this.pgs.clone(), this.utt);
        gs.time = this.time;
        gs.unitCancelationCounter = this.unitCancelationCounter;
        for (UnitActionAssignment uaa : this.unitActions.values()) {
            Unit u = uaa.unit;
            int idx = this.pgs.getUnits().indexOf(u);
            if (idx == -1) {
                System.out.println("Problematic game state:");
                System.out.println(this);
                System.out.println("Problematic action:");
                System.out.println(uaa);
                throw new Error("Inconsistent game state during cloning...");
            }
            Unit u2 = gs.pgs.getUnits().get(idx);
            gs.unitActions.put(u2, new UnitActionAssignment(u2, uaa.action, uaa.time));
        }
        return gs;
    }

    public GameState cloneIssue(PlayerAction pa) {
        GameState gs = new GameState(this.pgs, this.utt);
        gs.time = this.time;
        gs.unitCancelationCounter = this.unitCancelationCounter;
        gs.unitActions.putAll(this.unitActions);
        gs.issue(pa);
        return gs;
    }

    public GameState cloneChangingUTT(UnitTypeTable new_utt) {
        GameState gs = this.clone();
        gs.utt = new_utt;
        for (Unit u : gs.getUnits()) {
            UnitType new_type = new_utt.getUnitType(u.getType().name);
            if (new_type == null) {
                return null;
            }
            if (u.getHitPoints() == u.getType().hp) {
                u.setHitPoints(new_type.hp);
            }
            u.setType(new_type);
        }
        return gs;
    }

    public ResourceUsage getResourceUsage() {
        ResourceUsage base_ru = new ResourceUsage();
        for (Unit u : this.pgs.getUnits()) {
            UnitActionAssignment uaa = this.unitActions.get(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, this.pgs);
            base_ru.merge(ru);
        }
        return base_ru;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GameState)) {
            return false;
        }
        GameState s2 = (GameState)o;
        if (this.getTime() != s2.getTime()) {
            return false;
        }
        if (!this.pgs.equivalents(s2.pgs)) {
            return false;
        }
        int n = this.pgs.units.size();
        for (int i = 0; i < n; ++i) {
            UnitActionAssignment uaa = this.unitActions.get(this.pgs.units.get(i));
            UnitActionAssignment uaa2 = s2.unitActions.get(s2.pgs.units.get(i));
            if (uaa == null) {
                if (uaa2 == null) continue;
                return false;
            }
            if (uaa2 == null) {
                return false;
            }
            if (uaa.time != uaa2.time) {
                return false;
            }
            if (uaa.action.equals(uaa2.action)) continue;
            return false;
        }
        return true;
    }

    public boolean integrityCheck() {
        LinkedList<Unit> alreadyUsed = new LinkedList<Unit>();
        for (UnitActionAssignment uaa : this.unitActions.values()) {
            Unit u = uaa.unit;
            int idx = this.pgs.getUnits().indexOf(u);
            if (idx == -1) {
                System.err.println("integrityCheck: unit does not exist!");
                return false;
            }
            if (alreadyUsed.contains(u)) {
                System.err.println("integrityCheck: two actions to the same unit!");
                return false;
            }
            alreadyUsed.add(u);
        }
        return true;
    }

    public void dumpActionAssignments() {
        for (Unit u : this.pgs.getUnits()) {
            if (u.getPlayer() < 0) continue;
            UnitActionAssignment uaa = this.unitActions.get(u);
            if (uaa == null) {
                System.out.println(u + " : -");
                continue;
            }
            System.out.println(u + " : " + uaa.action + " at " + uaa.time);
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("ObservableGameState: " + this.time + "\n");
        for (Player p : this.pgs.getPlayers()) {
            tmp.append("player ").append(p.ID).append(": ").append(p.getResources()).append("\n");
        }
        for (Unit u : this.unitActions.keySet()) {
            UnitActionAssignment ua = this.unitActions.get(u);
            if (ua == null) {
                tmp.append("    ").append(u).append(" -> null (ERROR!)\n");
                continue;
            }
            tmp.append("    ").append(u).append(" -> ").append(ua.time).append(" ").append(ua.action).append("\n");
        }
        tmp.append(this.pgs);
        return tmp.toString();
    }

    public void toxml(XMLWriter w) {
        this.toxml(w, true, false);
    }

    public void toxml(XMLWriter w, boolean includeConstants, boolean compressTerrain) {
        w.tagWithAttributes(this.getClass().getName(), "time=\"" + this.time + "\"");
        this.pgs.toxml(w, includeConstants, compressTerrain);
        w.tag("actions");
        for (Unit u : this.unitActions.keySet()) {
            UnitActionAssignment uaa = this.unitActions.get(u);
            w.tagWithAttributes("unitAction", "ID=\"" + uaa.unit.getID() + "\" time=\"" + uaa.time + "\"");
            uaa.action.toxml(w);
            w.tag("/unitAction");
        }
        w.tag("/actions");
        w.tag("/" + this.getClass().getName());
    }

    public void toxml(String path) {
        try {
            XMLWriter dumper = new XMLWriter(new FileWriter(path));
            this.toxml(dumper);
            dumper.close();
        }
        catch (IOException e) {
            System.err.println("Error while writing state to: " + path);
            e.printStackTrace();
        }
    }

    public void toJSON(Writer w) throws Exception {
        this.toJSON(w, true, false);
    }

    public void toJSON(Writer w, boolean includeConstants, boolean compressTerrain) throws Exception {
        w.write("{");
        w.write("\"time\":" + this.time + ",\"pgs\":");
        this.pgs.toJSON(w, includeConstants, compressTerrain);
        w.write(",\"actions\":[");
        boolean first = true;
        for (Unit u : this.unitActions.keySet()) {
            if (!first) {
                w.write(",");
            }
            first = false;
            UnitActionAssignment uaa = this.unitActions.get(u);
            w.write("{\"ID\":" + uaa.unit.getID() + ", \"time\":" + uaa.time + ", \"action\":");
            uaa.action.toJSON(w);
            w.write("}");
        }
        w.write("]");
        w.write("}");
    }

    public static GameState fromXML(Element e, UnitTypeTable utt) throws Exception {
        PhysicalGameState pgs = PhysicalGameState.fromXML(e.getChild(PhysicalGameState.class.getName()), utt);
        GameState gs = new GameState(pgs, utt);
        gs.time = Integer.parseInt(e.getAttributeValue("time"));
        Element actions_e = e.getChild("actions");
        for (Object o : actions_e.getChildren()) {
            Element action_e = (Element)o;
            long ID = Long.parseLong(action_e.getAttributeValue("ID"));
            Unit u = gs.getUnit(ID);
            int time = Integer.parseInt(action_e.getAttributeValue("time"));
            UnitAction ua = UnitAction.fromXML(action_e.getChild("UnitAction"), utt);
            UnitActionAssignment uaa = new UnitActionAssignment(u, ua, time);
            gs.unitActions.put(u, uaa);
        }
        return gs;
    }

    public static GameState fromXML(String path, UnitTypeTable utt) {
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(path);
        Document document = null;
        GameState reconstructed = null;
        try {
            document = builder.build(xmlFile);
        }
        catch (IOException | JDOMException e) {
            System.err.println("Error while opening file: '" + path + "'. Returning null.");
            e.printStackTrace();
        }
        try {
            reconstructed = GameState.fromXML(document.getRootElement(), utt);
        }
        catch (Exception e) {
            System.err.println("ERror while reconstructing the state from the XML element. Returning null.");
            e.printStackTrace();
        }
        return reconstructed;
    }

    public static GameState fromJSON(String JSON, UnitTypeTable utt) {
        JsonObject o = Json.parse(JSON).asObject();
        PhysicalGameState pgs = PhysicalGameState.fromJSON(o.get("pgs").asObject(), utt);
        GameState gs = new GameState(pgs, utt);
        gs.time = o.getInt("time", 0);
        JsonArray actions_a = o.get("actions").asArray();
        for (JsonValue v : actions_a.values()) {
            JsonObject uaa_o = v.asObject();
            long ID = uaa_o.getLong("ID", -1L);
            Unit u = gs.getUnit(ID);
            int time = uaa_o.getInt("time", 0);
            UnitAction ua = UnitAction.fromJSON(uaa_o.get("action").asObject(), utt);
            UnitActionAssignment uaa = new UnitActionAssignment(u, ua, time);
            gs.unitActions.put(u, uaa);
        }
        return gs;
    }
}

