/*
 * Decompiled with CFR 0.152.
 */
package rts;

import gui.frontend.FrontEnd;
import java.io.FileNotFoundException;
import java.net.ServerSocket;
import java.net.Socket;
import rts.Game;
import rts.GameSettings;
import rts.MouseGame;
import rts.RemoteGame;

public class MicroRTS {
    public static void main(String[] args) throws Exception {
        GameSettings gameSettings;
        for (int i = args.length; i > 0; --i) {
            if (!args[i - 1].equals("-h")) continue;
            System.out.println(GameSettings.getHelpMessage());
            return;
        }
        String configFile = "resources/config.properties";
        for (int i = args.length; i > 0; --i) {
            if (!args[i - 1].equals("-f")) continue;
            configFile = args[i];
        }
        try {
            gameSettings = GameSettings.loadFromConfig(GameSettings.fetchConfig(configFile)).overrideFromArgs(args);
        }
        catch (FileNotFoundException ex) {
            System.err.println("File " + configFile + " not found. Trying to initialize from command-line args.");
            gameSettings = new GameSettings(args);
        }
        System.out.println(gameSettings);
        switch (gameSettings.getLaunchMode()) {
            case STANDALONE: 
            case HUMAN: {
                MicroRTS.runStandAloneGame(gameSettings);
                break;
            }
            case GUI: {
                FrontEnd.main(args);
                break;
            }
            case SERVER: {
                MicroRTS.startServer(gameSettings);
                break;
            }
            case CLIENT: {
                MicroRTS.startClient(gameSettings);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startServer(GameSettings gameSettings) throws Exception {
        ServerSocket serverSocket = new ServerSocket(gameSettings.getServerPort());
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket;
                            block20: {
                                socket = serverSocket.accept();
                                Throwable throwable2 = null;
                                try {
                                    new RemoteGame(socket, gameSettings).run();
                                    if (socket == null) continue;
                                    if (throwable2 == null) break block20;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        if (socket == null) throw throwable4;
                                        if (throwable2 == null) {
                                            socket.close();
                                            throw throwable4;
                                        }
                                        try {
                                            socket.close();
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                            throw throwable4;
                                        }
                                    }
                                }
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            socket.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (Throwable throwable8) {
            if (serverSocket == null) throw throwable8;
            if (throwable == null) {
                serverSocket.close();
                throw throwable8;
            }
            try {
                serverSocket.close();
                throw throwable8;
            }
            catch (Throwable throwable9) {
                throwable.addSuppressed(throwable9);
                throw throwable8;
            }
        }
    }

    private static void startClient(GameSettings gameSettings) throws Exception {
        Socket socket = new Socket(gameSettings.getServerAddress(), gameSettings.getServerPort());
        new RemoteGame(socket, gameSettings).run();
    }

    public static void runStandAloneGame(GameSettings gameSettings) throws Exception {
        if (gameSettings.getLaunchMode() == GameSettings.LaunchMode.STANDALONE) {
            new Game(gameSettings).start();
        } else if (gameSettings.getLaunchMode() == GameSettings.LaunchMode.HUMAN) {
            new MouseGame(gameSettings).start();
        }
    }
}

