/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import rts.GameState;
import rts.units.Unit;

public class PartiallyObservableGameState
extends GameState {
    protected int player;

    public PartiallyObservableGameState(GameState gs, int a_player) {
        super(gs.getPhysicalGameState().cloneKeepingUnits(), gs.getUnitTypeTable());
        this.unitCancelationCounter = gs.unitCancelationCounter;
        this.time = gs.time;
        this.player = a_player;
        this.unitActions.putAll(gs.unitActions);
        LinkedList<Unit> toDelete = new LinkedList<Unit>();
        for (Unit u : this.pgs.getUnits()) {
            if (u.getPlayer() == this.player || this.observable(u.getX(), u.getY())) continue;
            toDelete.add(u);
        }
        for (Unit u : toDelete) {
            this.removeUnit(u);
        }
    }

    @Override
    public boolean observable(int x, int y) {
        for (Unit u : this.pgs.getUnits()) {
            double d;
            if (u.getPlayer() != this.player || !((d = Math.sqrt((u.getX() - x) * (u.getX() - x) + (u.getY() - y) * (u.getY() - y))) <= (double)u.getType().sightRadius)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PartiallyObservableGameState clone() {
        return new PartiallyObservableGameState(super.clone(), this.player);
    }
}

