/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import rts.Player;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class PhysicalGameState {
    public static final int TERRAIN_NONE = 0;
    public static final int TERRAIN_WALL = 1;
    int width = 8;
    int height = 8;
    int[] terrain;
    List<Player> players = new ArrayList<Player>();
    List<Unit> units = new LinkedList<Unit>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PhysicalGameState load(String fileName, UnitTypeTable utt) throws Exception {
        try {
            return PhysicalGameState.fromXML(new SAXBuilder().build(fileName).getRootElement(), utt);
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            try (InputStream is = PhysicalGameState.class.getClassLoader().getResourceAsStream(fileName);){
                PhysicalGameState physicalGameState = PhysicalGameState.fromXML(new SAXBuilder().build(is).getRootElement(), utt);
                return physicalGameState;
            }
            catch (IllegalArgumentException var3) {
                throw new IllegalArgumentException("Error loading map: " + fileName, var3);
            }
        }
    }

    public PhysicalGameState(int a_width, int a_height) {
        this.width = a_width;
        this.height = a_height;
        this.terrain = new int[this.width * this.height];
    }

    PhysicalGameState(int a_width, int a_height, int[] t) {
        this.width = a_width;
        this.height = a_height;
        this.terrain = t;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getTerrain(int x, int y) {
        return this.terrain[x + y * this.width];
    }

    public void setTerrain(int x, int y, int v) {
        this.terrain[x + y * this.width] = v;
    }

    public void setTerrain(int[] t) {
        this.terrain = t;
    }

    public void addPlayer(Player p) {
        if (p.getID() != this.players.size()) {
            throw new IllegalArgumentException("PhysicalGameState.addPlayer: player added in the wrong order.");
        }
        this.players.add(p);
    }

    public void addUnit(Unit newUnit) throws IllegalArgumentException {
        for (Unit existingUnit : this.units) {
            if (newUnit.getX() != existingUnit.getX() || newUnit.getY() != existingUnit.getY()) continue;
            throw new IllegalArgumentException("PhysicalGameState.addUnit: added two units in position: (" + newUnit.getX() + ", " + newUnit.getY() + ")");
        }
        this.units.add(newUnit);
    }

    public void removeUnit(Unit u) {
        this.units.remove(u);
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Player getPlayer(int pID) {
        return this.players.get(pID);
    }

    public Unit getUnit(long ID) {
        for (Unit u : this.units) {
            if (u.getID() != ID) continue;
            return u;
        }
        return null;
    }

    public Unit getUnitAt(int x, int y) {
        for (Unit u : this.units) {
            if (u.getX() != x || u.getY() != y) continue;
            return u;
        }
        return null;
    }

    public Collection<Unit> getUnitsAround(int x, int y, int squareRange) {
        return this.getUnitsAround(x, y, squareRange, squareRange);
    }

    public Collection<Unit> getUnitsAround(int x, int y, int width, int height) {
        LinkedList<Unit> closeUnits = new LinkedList<Unit>();
        for (Unit u : this.units) {
            if (Math.abs(u.getX() - x) > width || Math.abs(u.getY() - y) > height) continue;
            closeUnits.add(u);
        }
        return closeUnits;
    }

    public Collection<Unit> getUnitsInRectangle(int x, int y, int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width and height must be >=1");
        }
        LinkedList<Unit> unitsInside = new LinkedList<Unit>();
        for (Unit u : this.units) {
            if (x > u.getX() || u.getX() >= x + width || y > u.getY() || u.getY() >= y + height) continue;
            unitsInside.add(u);
        }
        return unitsInside;
    }

    public int winner() {
        int[] unitcounts = new int[this.players.size()];
        for (Unit u : this.units) {
            if (u.getPlayer() < 0) continue;
            int n = u.getPlayer();
            unitcounts[n] = unitcounts[n] + 1;
        }
        int winner = -1;
        for (int i = 0; i < unitcounts.length; ++i) {
            if (unitcounts[i] <= 0) continue;
            if (winner == -1) {
                winner = i;
                continue;
            }
            return -1;
        }
        return winner;
    }

    boolean gameover() {
        int[] unitcounts = new int[this.players.size()];
        int totalunits = 0;
        for (Unit u : this.units) {
            if (u.getPlayer() < 0) continue;
            int n = u.getPlayer();
            unitcounts[n] = unitcounts[n] + 1;
            ++totalunits;
        }
        if (totalunits == 0) {
            return true;
        }
        int winner = -1;
        for (int i = 0; i < unitcounts.length; ++i) {
            if (unitcounts[i] <= 0) continue;
            if (winner == -1) {
                winner = i;
                continue;
            }
            return false;
        }
        return winner != -1;
    }

    public PhysicalGameState clone() {
        PhysicalGameState pgs = new PhysicalGameState(this.width, this.height, this.terrain);
        for (Player p : this.players) {
            pgs.players.add(p.clone());
        }
        for (Unit u : this.units) {
            pgs.units.add(u.clone());
        }
        return pgs;
    }

    public PhysicalGameState cloneKeepingUnits() {
        PhysicalGameState pgs = new PhysicalGameState(this.width, this.height, this.terrain);
        pgs.players.addAll(this.players);
        pgs.units.addAll(this.units);
        return pgs;
    }

    public PhysicalGameState cloneIncludingTerrain() {
        int[] new_terrain = new int[this.terrain.length];
        System.arraycopy(this.terrain, 0, new_terrain, 0, this.terrain.length);
        PhysicalGameState pgs = new PhysicalGameState(this.width, this.height, new_terrain);
        for (Player p : this.players) {
            pgs.players.add(p.clone());
        }
        for (Unit u : this.units) {
            pgs.units.add(u.clone());
        }
        return pgs;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("PhysicalGameState:\n");
        for (Player p : this.players) {
            tmp.append("  ").append(p).append("\n");
        }
        for (Unit u : this.units) {
            tmp.append("  ").append(u).append("\n");
        }
        return tmp.toString();
    }

    public boolean equivalents(PhysicalGameState pgs) {
        int i;
        if (this.width != pgs.width) {
            return false;
        }
        if (this.height != pgs.height) {
            return false;
        }
        if (this.players.size() != pgs.players.size()) {
            return false;
        }
        for (i = 0; i < this.players.size(); ++i) {
            if (this.players.get((int)i).ID != pgs.players.get((int)i).ID) {
                return false;
            }
            if (this.players.get((int)i).resources == pgs.players.get((int)i).resources) continue;
            return false;
        }
        if (this.units.size() != pgs.units.size()) {
            return false;
        }
        for (i = 0; i < this.units.size(); ++i) {
            if (this.units.get(i).getType() != pgs.units.get(i).getType()) {
                return false;
            }
            if (this.units.get(i).getHitPoints() != pgs.units.get(i).getHitPoints()) {
                return false;
            }
            if (this.units.get(i).getX() != pgs.units.get(i).getX()) {
                return false;
            }
            if (this.units.get(i).getY() == pgs.units.get(i).getY()) continue;
            return false;
        }
        return true;
    }

    public boolean equivalentsIncludingTerrain(PhysicalGameState pgs) {
        if (this.equivalents(pgs)) {
            return Arrays.toString(this.terrain).equals(Arrays.toString(pgs.terrain));
        }
        return false;
    }

    public boolean[][] getAllFree() {
        boolean[][] free = new boolean[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                free[x][y] = this.getTerrain(x, y) == 0;
            }
        }
        for (Unit u : this.units) {
            free[u.getX()][u.getY()] = false;
        }
        return free;
    }

    private String compressTerrain() {
        StringBuilder strTerrain = new StringBuilder();
        int occurrences = 1;
        for (int i = 1; i < this.height * this.width; ++i) {
            if (this.terrain[i] == this.terrain[i - 1]) {
                ++occurrences;
                continue;
            }
            strTerrain.append(this.terrain[i - 1] == 0 ? (char)'A' : 'B');
            if (occurrences > 1) {
                strTerrain.append(occurrences);
            }
            occurrences = 1;
        }
        if (occurrences > 1) {
            strTerrain.append(this.terrain[this.terrain.length - 1] == 0 ? (char)'A' : 'B').append(occurrences);
        }
        return strTerrain.toString();
    }

    private static int[] uncompressTerrain(String t) {
        ArrayList terrain = new ArrayList();
        StringBuilder counter = new StringBuilder();
        for (char ch : t.toCharArray()) {
            if (ch == 'A' || ch == 'B') {
                if (counter.length() > 0) {
                    for (int i = 0; i < Integer.parseInt(counter.toString()) - 1; ++i) {
                        terrain.add(terrain.get(terrain.size() - 1));
                    }
                    counter = new StringBuilder();
                }
                terrain.add(ch == 'A' ? 0 : 1);
                continue;
            }
            counter.append(ch);
        }
        if (counter.length() > 0) {
            for (int i = 0; i < Integer.parseInt(counter.toString()) - 1; ++i) {
                terrain.add(terrain.get(terrain.size() - 1));
            }
        }
        int[] rt = new int[terrain.size()];
        for (int i = 0; i < terrain.size(); ++i) {
            rt[i] = (Integer)terrain.get(i);
        }
        return rt;
    }

    public void toxml(XMLWriter w) {
        this.toxml(w, true, false);
    }

    public void toxml(XMLWriter w, boolean includeConstants, boolean compressTerrain) {
        if (!includeConstants) {
            w.tag(this.getClass().getName());
        } else {
            w.tagWithAttributes(this.getClass().getName(), "width=\"" + this.width + "\" height=\"" + this.height + "\"");
            if (compressTerrain) {
                w.tag("terrain", this.compressTerrain());
            } else {
                StringBuilder tmp = new StringBuilder(this.height * this.width);
                for (int i = 0; i < this.height * this.width; ++i) {
                    tmp.append(this.terrain[i]);
                }
                w.tag("terrain", tmp.toString());
            }
        }
        w.tag("players");
        for (Player p : this.players) {
            p.toxml(w);
        }
        w.tag("/players");
        w.tag("units");
        for (Unit u : this.units) {
            u.toxml(w);
        }
        w.tag("/units");
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        this.toJSON(w, true, false);
    }

    public void toJSON(Writer w, boolean includeConstants, boolean compressTerrain) throws Exception {
        int i;
        w.write("{");
        if (includeConstants) {
            w.write("\"width\":" + this.width + ",\"height\":" + this.height + ",");
            if (compressTerrain) {
                w.write("\"terrain\":\"" + this.compressTerrain());
            } else {
                w.write("\"terrain\":\"");
                for (i = 0; i < this.height * this.width; ++i) {
                    w.write("" + this.terrain[i]);
                }
            }
            w.write("\",");
        }
        w.write("\"players\":[");
        for (i = 0; i < this.players.size(); ++i) {
            this.players.get(i).toJSON(w);
            if (i >= this.players.size() - 1) continue;
            w.write(",");
        }
        w.write("],");
        w.write("\"units\":[");
        for (i = 0; i < this.units.size(); ++i) {
            this.units.get(i).toJSON(w);
            if (i >= this.units.size() - 1) continue;
            w.write(",");
        }
        w.write("]");
        w.write("}");
    }

    public static PhysicalGameState fromXML(Element e, UnitTypeTable utt) throws Exception {
        Element terrain_e = e.getChild("terrain");
        Element players_e = e.getChild("players");
        Element units_e = e.getChild("units");
        int width = Integer.parseInt(e.getAttributeValue("width"));
        int height = Integer.parseInt(e.getAttributeValue("height"));
        int[] terrain = PhysicalGameState.getTerrainFromUnknownString(terrain_e.getValue(), width * height);
        PhysicalGameState pgs = new PhysicalGameState(width, height, terrain);
        for (Object o : players_e.getChildren()) {
            Element player_e = (Element)o;
            pgs.addPlayer(Player.fromXML(player_e));
        }
        for (Object o : units_e.getChildren()) {
            Element unit_e = (Element)o;
            Unit u = Unit.fromXML(unit_e, utt);
            if (pgs.getUnit(u.getID()) != null) {
                throw new Exception("Repeated unit ID " + u.getID() + " in map!");
            }
            pgs.addUnit(u);
        }
        return pgs;
    }

    public static PhysicalGameState fromJSON(JsonObject o, UnitTypeTable utt) {
        String terrainString = o.getString("terrain", null);
        JsonArray players_o = o.get("players").asArray();
        JsonArray units_o = o.get("units").asArray();
        int width = o.getInt("width", 8);
        int height = o.getInt("height", 8);
        int[] terrain = PhysicalGameState.getTerrainFromUnknownString(terrainString, width * height);
        PhysicalGameState pgs = new PhysicalGameState(width, height, terrain);
        for (JsonValue v : players_o.values()) {
            JsonObject player_o = (JsonObject)v;
            pgs.addPlayer(Player.fromJSON(player_o));
        }
        for (JsonValue v : units_o.values()) {
            JsonObject unit_o = (JsonObject)v;
            pgs.addUnit(Unit.fromJSON(unit_o, utt));
        }
        return pgs;
    }

    private static int[] getTerrainFromUnknownString(String terrainString, int size) {
        int[] terrain = new int[size];
        if (terrainString.contains("A") || terrainString.contains("B")) {
            terrain = PhysicalGameState.uncompressTerrain(terrainString);
        } else {
            for (int i = 0; i < size; ++i) {
                String c = terrainString.substring(i, i + 1);
                terrain[i] = Integer.parseInt(c);
            }
        }
        return terrain;
    }

    public void resetAllUnitsHP() {
        for (Unit u : this.units) {
            u.setHitPoints(u.getType().hp);
        }
    }
}

