/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class PlayerAction {
    List<Pair<Unit, UnitAction>> actions = new LinkedList<Pair<Unit, UnitAction>>();
    ResourceUsage r = new ResourceUsage();

    public boolean equals(Object o) {
        if (!(o instanceof PlayerAction)) {
            return false;
        }
        PlayerAction a = (PlayerAction)o;
        for (Pair<Unit, UnitAction> p : this.actions) {
            for (Pair<Unit, UnitAction> p2 : a.actions) {
                if (((Unit)p.m_a).getID() != ((Unit)p2.m_a).getID() || ((UnitAction)p.m_b).equals(p2.m_b)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public boolean hasNonNoneActions() {
        for (Pair<Unit, UnitAction> ua : this.actions) {
            if (((UnitAction)ua.m_b).type == 0) continue;
            return true;
        }
        return false;
    }

    public int hasNamNoneActions() {
        int j = 0;
        for (Pair<Unit, UnitAction> ua : this.actions) {
            if (((UnitAction)ua.m_b).type == 0) continue;
            ++j;
        }
        return j;
    }

    public ResourceUsage getResourceUsage() {
        return this.r;
    }

    public void setResourceUsage(ResourceUsage a_r) {
        this.r = a_r;
    }

    public void addUnitAction(Unit u, UnitAction a) {
        this.actions.add(new Pair<Unit, UnitAction>(u, a));
    }

    public void removeUnitAction(Unit u, UnitAction a) {
        Pair<Unit, UnitAction> found = null;
        for (Pair<Unit, UnitAction> tmp : this.actions) {
            if (tmp.m_a != u || tmp.m_b != a) continue;
            found = tmp;
            break;
        }
        if (found != null) {
            this.actions.remove(found);
        }
    }

    public PlayerAction merge(PlayerAction a) {
        PlayerAction merge = new PlayerAction();
        merge.actions.addAll(this.actions);
        merge.actions.addAll(a.actions);
        merge.r = this.r.mergeIntoNew(a.r);
        return merge;
    }

    public List<Pair<Unit, UnitAction>> getActions() {
        return this.actions;
    }

    public UnitAction getAction(Unit u) {
        for (Pair<Unit, UnitAction> tmp : this.actions) {
            if (tmp.m_a != u) continue;
            return (UnitAction)tmp.m_b;
        }
        return null;
    }

    public List<PlayerAction> cartesianProduct(List<UnitAction> lu, Unit u, GameState s) {
        LinkedList<PlayerAction> l = new LinkedList<PlayerAction>();
        for (UnitAction ua : lu) {
            ResourceUsage r2 = ua.resourceUsage(u, s.getPhysicalGameState());
            if (!this.r.consistentWith(r2, s)) continue;
            PlayerAction a = new PlayerAction();
            a.r = this.r.mergeIntoNew(r2);
            a.actions.addAll(this.actions);
            a.addUnitAction(u, ua);
            l.add(a);
        }
        return l;
    }

    public boolean consistentWith(ResourceUsage u, GameState gs) {
        return this.r.consistentWith(u, gs);
    }

    public void fillWithNones(GameState s, int pID, int duration) {
        PhysicalGameState pgs = s.getPhysicalGameState();
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != pID || s.unitActions.get(u) != null) continue;
            boolean found = false;
            for (Pair<Unit, UnitAction> pa : this.actions) {
                if (pa.m_a != u) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.actions.add(new Pair<Unit, UnitAction>(u, new UnitAction(0, duration)));
        }
    }

    public boolean integrityCheck() {
        int player = -1;
        for (Pair<Unit, UnitAction> uaa : this.actions) {
            Unit u = (Unit)uaa.m_a;
            if (player == -1) {
                player = u.getPlayer();
                continue;
            }
            if (player == u.getPlayer()) continue;
            System.err.println("integrityCheck: units from more than one player!");
            return false;
        }
        return true;
    }

    public PlayerAction clone() {
        PlayerAction clone = new PlayerAction();
        clone.actions = new LinkedList<Pair<Unit, UnitAction>>();
        for (Pair<Unit, UnitAction> tmp : this.actions) {
            clone.actions.add(new Pair(tmp.m_a, tmp.m_b));
        }
        clone.r = this.r.clone();
        return clone;
    }

    public void clear() {
        this.actions.clear();
        this.r = new ResourceUsage();
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("{ ");
        for (Pair<Unit, UnitAction> ua : this.actions) {
            tmp.append("(").append(ua.m_a).append(",").append(ua.m_b).append(")");
        }
        return tmp + " }";
    }

    public void toxml(XMLWriter w) {
        w.tag("PlayerAction");
        for (Pair<Unit, UnitAction> ua : this.actions) {
            w.tagWithAttributes("action", "unitID=\"" + ((Unit)ua.m_a).getID() + "\"");
            ((UnitAction)ua.m_b).toxml(w);
            w.tag("/action");
        }
        w.tag("/PlayerAction");
    }

    public void toJSON(Writer w) throws Exception {
        boolean first = true;
        w.write("[");
        for (Pair<Unit, UnitAction> ua : this.actions) {
            if (!first) {
                w.write(" ,");
            }
            w.write("{\"unitID\":" + ((Unit)ua.m_a).getID() + ", \"unitAction\":");
            ((UnitAction)ua.m_b).toJSON(w);
            w.write("}");
            first = false;
        }
        w.write("]");
    }

    public static PlayerAction fromXML(Element e, GameState gs, UnitTypeTable utt) {
        PlayerAction pa = new PlayerAction();
        List l = e.getChildren("action");
        for (Object o : l) {
            Element action_e = (Element)o;
            int id = Integer.parseInt(action_e.getAttributeValue("unitID"));
            Unit u = gs.getUnit(id);
            UnitAction ua = UnitAction.fromXML(action_e.getChild("UnitAction"), utt);
            pa.addUnitAction(u, ua);
        }
        return pa;
    }

    public static PlayerAction fromJSON(String JSON, GameState gs, UnitTypeTable utt) {
        PlayerAction pa = new PlayerAction();
        JsonArray a = Json.parse(JSON).asArray();
        for (JsonValue v : a.values()) {
            JsonObject o = v.asObject();
            int id = o.getInt("unitID", -1);
            Unit u = gs.getUnit(id);
            UnitAction ua = UnitAction.fromJSON(o.get("unitAction").asObject(), utt);
            pa.addUnitAction(u, ua);
        }
        return pa;
    }
}

