/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.Pair;

public class PlayerActionGenerator {
    static Random r = new Random();
    GameState gameState;
    PhysicalGameState physicalGameState;
    ResourceUsage base_ru = new ResourceUsage();
    List<Pair<Unit, List<UnitAction>>> choices;
    PlayerAction lastAction;
    long size = 1L;
    long generated = 0L;
    int[] choiceSizes;
    int[] currentChoice;
    boolean moreActions = true;

    public long getGenerated() {
        return this.generated;
    }

    public long getSize() {
        return this.size;
    }

    public PlayerAction getLastAction() {
        return this.lastAction;
    }

    public List<Pair<Unit, List<UnitAction>>> getChoices() {
        return this.choices;
    }

    public PlayerActionGenerator(GameState a_gs, int pID) throws Exception {
        this.gameState = a_gs;
        this.physicalGameState = this.gameState.getPhysicalGameState();
        for (Unit u : this.physicalGameState.getUnits()) {
            UnitActionAssignment uaa = this.gameState.unitActions.get(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, this.physicalGameState);
            this.base_ru.merge(ru);
        }
        this.choices = new ArrayList<Pair<Unit, List<UnitAction>>>();
        for (Unit u : this.physicalGameState.getUnits()) {
            if (u.getPlayer() != pID || this.gameState.unitActions.get(u) != null) continue;
            List<UnitAction> l = u.getUnitActions(this.gameState);
            this.choices.add(new Pair<Unit, List<UnitAction>>(u, l));
            long tmp = l.size();
            if (Long.MAX_VALUE / this.size <= tmp) {
                this.size = Long.MAX_VALUE;
                continue;
            }
            this.size *= (long)l.size();
        }
        if (this.choices.size() == 0) {
            System.err.println("Problematic game state:");
            System.err.println(a_gs);
            throw new Exception("Move generator for player " + pID + " created with no units that can execute actions! (status: " + a_gs.canExecuteAnyAction(0) + ", " + a_gs.canExecuteAnyAction(1) + ")");
        }
        this.choiceSizes = new int[this.choices.size()];
        this.currentChoice = new int[this.choices.size()];
        int i = 0;
        for (Pair<Unit, List<UnitAction>> choice : this.choices) {
            this.choiceSizes[i] = ((List)choice.m_b).size();
            this.currentChoice[i] = 0;
            ++i;
        }
    }

    public void randomizeOrder() {
        for (Pair<Unit, List<UnitAction>> choice : this.choices) {
            LinkedList tmp = new LinkedList((Collection)choice.m_b);
            ((List)choice.m_b).clear();
            while (!tmp.isEmpty()) {
                ((List)choice.m_b).add(tmp.remove(r.nextInt(tmp.size())));
            }
        }
    }

    public void incrementCurrentChoice(int startPosition) {
        for (int i = 0; i < startPosition; ++i) {
            this.currentChoice[i] = 0;
        }
        int n = startPosition;
        this.currentChoice[n] = this.currentChoice[n] + 1;
        if (this.currentChoice[startPosition] >= this.choiceSizes[startPosition]) {
            if (startPosition < this.currentChoice.length - 1) {
                this.incrementCurrentChoice(startPosition + 1);
            } else {
                this.moreActions = false;
            }
        }
    }

    public PlayerAction getNextAction(long cutOffTime) throws Exception {
        int count = 0;
        while (this.moreActions) {
            boolean consistent = true;
            PlayerAction pa = new PlayerAction();
            pa.setResourceUsage(this.base_ru.clone());
            int i = this.choices.size();
            if (i == 0) {
                throw new Exception("Move generator created with no units that can execute actions!");
            }
            while (i > 0) {
                Pair<Unit, List<UnitAction>> unitChoices = this.choices.get(--i);
                int choice = this.currentChoice[i];
                Unit u = (Unit)unitChoices.m_a;
                UnitAction ua = (UnitAction)((List)unitChoices.m_b).get(choice);
                ResourceUsage r2 = ua.resourceUsage(u, this.physicalGameState);
                if (pa.getResourceUsage().consistentWith(r2, this.gameState)) {
                    pa.getResourceUsage().merge(r2);
                    pa.addUnitAction(u, ua);
                    continue;
                }
                consistent = false;
                break;
            }
            this.incrementCurrentChoice(i);
            if (consistent) {
                this.lastAction = pa;
                ++this.generated;
                return pa;
            }
            if (cutOffTime > 0L && count % 1000 == 0 && System.currentTimeMillis() > cutOffTime) {
                this.lastAction = null;
                return null;
            }
            ++count;
        }
        this.lastAction = null;
        return null;
    }

    public PlayerAction getRandom() {
        Random r = new Random();
        PlayerAction pa = new PlayerAction();
        pa.setResourceUsage(this.base_ru.clone());
        for (Pair<Unit, List<UnitAction>> unitChoices : this.choices) {
            LinkedList l = new LinkedList((Collection)unitChoices.m_b);
            Unit u = (Unit)unitChoices.m_a;
            boolean consistent = false;
            do {
                UnitAction ua = (UnitAction)l.remove(r.nextInt(l.size()));
                ResourceUsage r2 = ua.resourceUsage(u, this.physicalGameState);
                if (!pa.getResourceUsage().consistentWith(r2, this.gameState)) continue;
                pa.getResourceUsage().merge(r2);
                pa.addUnitAction(u, ua);
                consistent = true;
            } while (!consistent);
        }
        return pa;
    }

    public long getActionIndex(PlayerAction a) {
        int[] choice = new int[this.choices.size()];
        for (Pair<Unit, UnitAction> ua : a.actions) {
            int idx = 0;
            Pair<Unit, List<UnitAction>> ua_choice = null;
            for (Pair<Unit, List<UnitAction>> c : this.choices) {
                if (ua.m_a == c.m_a) {
                    ua_choice = c;
                    break;
                }
                ++idx;
            }
            if (ua_choice == null) {
                return -1L;
            }
            choice[idx] = ((List)ua_choice.m_b).indexOf(ua.m_b);
        }
        long index = 0L;
        long multiplier = 1L;
        for (int i = 0; i < choice.length; ++i) {
            index += (long)choice[i] * multiplier;
            multiplier *= (long)this.choiceSizes[i];
        }
        return index;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("PlayerActionGenerator:\n");
        for (Pair<Unit, List<UnitAction>> choice : this.choices) {
            ret.append("  (").append(choice.m_a).append(",").append(((List)choice.m_b).size()).append(")\n");
        }
        ret.append("currentChoice: ");
        for (Object value : (Object)this.currentChoice) {
            ret.append((int)value).append(" ");
        }
        ret.append("\nactions generated so far: ").append(this.generated);
        return ret.toString();
    }
}

