/*
 * Decompiled with CFR 0.152.
 */
package rts;

import ai.core.AI;
import ai.socket.SocketAI;
import java.lang.reflect.Constructor;
import java.net.Socket;
import rts.Game;
import rts.GameSettings;
import rts.units.UnitTypeTable;

class RemoteGame
implements Runnable {
    private Socket socket;
    private GameSettings gameSettings;

    RemoteGame(Socket socket, GameSettings gameSettings) {
        this.socket = socket;
        this.gameSettings = gameSettings;
    }

    @Override
    public void run() {
        try {
            UnitTypeTable unitTypeTable = new UnitTypeTable(this.gameSettings.getUTTVersion(), this.gameSettings.getConflictPolicy());
            SocketAI player_one = SocketAI.createFromExistingSocket(100, 0, unitTypeTable, this.gameSettings.getSerializationType(), this.gameSettings.isIncludeConstantsInState(), this.gameSettings.isCompressTerrain(), this.socket);
            Constructor<?> cons2 = Class.forName(this.gameSettings.getAI2()).getConstructor(UnitTypeTable.class);
            AI player_two = (AI)cons2.newInstance(unitTypeTable);
            Game game = new Game(this.gameSettings, player_one, player_two);
            game.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

