/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class ResourceUsage {
    List<Integer> positionsUsed = new LinkedList<Integer>();
    int[] resourcesUsed = new int[2];

    public boolean consistentWith(ResourceUsage anotherUsage, GameState gs) {
        for (Integer pos : anotherUsage.positionsUsed) {
            if (!this.positionsUsed.contains(pos)) continue;
            return false;
        }
        for (int i = 0; i < this.resourcesUsed.length; ++i) {
            if (anotherUsage.resourcesUsed[i] == 0 || this.resourcesUsed[i] + anotherUsage.resourcesUsed[i] <= 0 || this.resourcesUsed[i] + anotherUsage.resourcesUsed[i] <= gs.getPlayer(i).getResources()) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getPositionsUsed() {
        return this.positionsUsed;
    }

    public int getResourcesUsed(int player) {
        return this.resourcesUsed[player];
    }

    public ResourceUsage mergeIntoNew(ResourceUsage other) {
        ResourceUsage newResourceUsage = new ResourceUsage();
        newResourceUsage.positionsUsed.addAll(this.positionsUsed);
        newResourceUsage.positionsUsed.addAll(other.positionsUsed);
        for (int i = 0; i < this.resourcesUsed.length; ++i) {
            newResourceUsage.resourcesUsed[i] = this.resourcesUsed[i] + other.resourcesUsed[i];
        }
        return newResourceUsage;
    }

    public void merge(ResourceUsage other) {
        this.positionsUsed.addAll(other.positionsUsed);
        for (int i = 0; i < this.resourcesUsed.length; ++i) {
            int n = i;
            this.resourcesUsed[n] = this.resourcesUsed[n] + other.resourcesUsed[i];
        }
    }

    public ResourceUsage clone() {
        ResourceUsage ru = new ResourceUsage();
        ru.positionsUsed.addAll(this.positionsUsed);
        ru.resourcesUsed[0] = this.resourcesUsed[0];
        ru.resourcesUsed[1] = this.resourcesUsed[1];
        return ru;
    }

    public String toString() {
        return "ResourceUsage: " + this.resourcesUsed[0] + "," + this.resourcesUsed[1] + " positions: " + this.positionsUsed;
    }
}

