/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import rts.GameState;
import rts.PlayerAction;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class Trace {
    UnitTypeTable utt;
    List<TraceEntry> entries = new LinkedList<TraceEntry>();
    GameState getGameStateAtCycle_cache;

    public Trace(UnitTypeTable a_utt) {
        this.utt = a_utt;
    }

    public List<TraceEntry> getEntries() {
        return this.entries;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public int getLength() {
        return this.entries.get(this.entries.size() - 1).getTime();
    }

    public int winner() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        return this.entries.get((int)(this.entries.size() - 1)).pgs.winner();
    }

    public void addEntry(TraceEntry te) {
        this.entries.add(te);
    }

    public void toxml(XMLWriter w) {
        w.tag(this.getClass().getName());
        this.utt.toxml(w);
        w.tag("entries");
        for (TraceEntry te : this.entries) {
            te.toxml(w);
        }
        w.tag("/entries");
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        w.write("{\"utt\":");
        this.utt.toJSON(w);
        w.write(",\n\"entries\":[");
        boolean first = true;
        for (TraceEntry te : this.entries) {
            if (!first) {
                w.write(",\n");
            }
            te.toJSON(w);
            first = false;
        }
        w.write("]}");
    }

    public void toxml(String path) {
        try {
            XMLWriter dumper = new XMLWriter(new FileWriter(path));
            this.toxml(dumper);
            dumper.close();
        }
        catch (IOException e) {
            System.err.println("Error while writing trace to: " + path);
            e.printStackTrace();
        }
    }

    public void toZip(String path) {
        if (path.endsWith(".zip")) {
            path.replaceFirst("[.][^.]+$", ".xml");
        }
        File f = new File(path);
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            ZipEntry e = new ZipEntry(f.getName());
            out.putNextEntry(e);
            StringWriter xmlStringContainer = new StringWriter();
            XMLWriter dumper = new XMLWriter(xmlStringContainer);
            this.toxml(dumper);
            byte[] data = xmlStringContainer.toString().getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            out.close();
        }
        catch (FileNotFoundException e1) {
            System.err.println("File not found: " + path);
            e1.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println("Error while writing to " + path);
            e1.printStackTrace();
        }
    }

    public static Trace fromZip(String path) throws Exception {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(path));
        zis.getNextEntry();
        return new Trace(new SAXBuilder().build(zis).getRootElement());
    }

    public Trace(Element e) throws Exception {
        this.utt = UnitTypeTable.fromXML(e.getChild(UnitTypeTable.class.getName()));
        Element entries_e = e.getChild("entries");
        for (Object o : entries_e.getChildren()) {
            Element entry_e = (Element)o;
            this.entries.add(new TraceEntry(entry_e, this.utt));
        }
    }

    public Trace(Element e, UnitTypeTable a_utt) throws Exception {
        this.utt = a_utt;
        Element entries_e = e.getChild("entries");
        for (Object o : entries_e.getChildren()) {
            Element entry_e = (Element)o;
            this.entries.add(new TraceEntry(entry_e, this.utt));
        }
    }

    public GameState getGameStateAtCycle(int cycle) {
        GameState gs = null;
        for (TraceEntry te : this.getEntries()) {
            if (gs == null) {
                if (this.getGameStateAtCycle_cache != null && cycle >= this.getGameStateAtCycle_cache.getTime()) {
                    if (te.getTime() < this.getGameStateAtCycle_cache.getTime()) continue;
                    gs = this.getGameStateAtCycle_cache.clone();
                } else {
                    gs = new GameState(te.getPhysicalGameState().clone(), this.utt);
                }
            }
            while (gs.getTime() < te.getTime() && gs.getTime() < cycle) {
                gs.cycle();
            }
            for (Unit u1 : gs.getUnits()) {
                for (Unit unit : te.getPhysicalGameState().getUnits()) {
                    if (u1.getX() != unit.getX() || u1.getY() != unit.getY() || u1.getType() != unit.getType() || u1.getID() == unit.getID()) continue;
                    u1.setID(unit.getID());
                }
            }
            if (gs.getTime() == cycle) {
                this.getGameStateAtCycle_cache = gs;
                return gs;
            }
            PlayerAction pa0 = new PlayerAction();
            PlayerAction pa1 = new PlayerAction();
            for (Pair pair : te.getActions()) {
                if (pair.m_a != null) {
                    if (((Unit)pair.m_a).getPlayer() == 0) {
                        pa0.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
                    }
                    if (((Unit)pair.m_a).getPlayer() != 1) continue;
                    pa1.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
                    continue;
                }
                System.err.println("TraceEntry at time " + te.getTime() + " has actions for undefined units! This will probably cause errors down the line...");
            }
            gs.issueSafe(pa0);
            gs.issueSafe(pa1);
            if (gs.getTime() != cycle) continue;
            this.getGameStateAtCycle_cache = gs;
            return gs;
        }
        while (gs.getTime() < cycle) {
            gs.cycle();
        }
        this.getGameStateAtCycle_cache = gs;
        return gs;
    }
}

