/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class TraceEntry {
    int time;
    PhysicalGameState pgs;
    List<Pair<Unit, UnitAction>> actions = new LinkedList<Pair<Unit, UnitAction>>();

    public TraceEntry(PhysicalGameState a_pgs, int a_time) {
        this.pgs = a_pgs;
        this.time = a_time;
    }

    public void addUnitAction(Unit u, UnitAction a) {
        this.actions.add(new Pair<Unit, UnitAction>(u, a));
    }

    public void addPlayerAction(PlayerAction a) {
        for (Pair<Unit, UnitAction> ua : a.actions) {
            if (this.pgs.getUnit(((Unit)ua.m_a).getID()) == null) {
                boolean found = false;
                for (Unit u : this.pgs.units) {
                    if (u.getClass() != ((Unit)ua.m_a).getClass() || u.getX() != ((Unit)ua.m_a).getX() || u.getY() != ((Unit)ua.m_a).getY()) continue;
                    ua.m_a = u;
                    found = true;
                    break;
                }
                if (!found) {
                    System.err.println("Inconsistent order: " + a);
                    System.err.println(this);
                    System.err.println("The problem was with unit " + ua.m_a);
                }
            }
            this.actions.add(ua);
        }
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public List<Pair<Unit, UnitAction>> getActions() {
        return this.actions;
    }

    public int getTime() {
        return this.time;
    }

    public void toxml(XMLWriter w) {
        w.tagWithAttributes(this.getClass().getName(), "time = \"" + this.time + "\"");
        this.pgs.toxml(w);
        w.tag("actions");
        for (Pair<Unit, UnitAction> ua : this.actions) {
            w.tagWithAttributes("action", "unitID=\"" + ((Unit)ua.m_a).getID() + "\"");
            ((UnitAction)ua.m_b).toxml(w);
            w.tag("/action");
        }
        w.tag("/actions");
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        w.write("{");
        w.write("\"time\":" + this.time + ",\"pgs\":");
        this.pgs.toJSON(w);
        w.write(",\"actions\":[");
        boolean first = true;
        for (Pair<Unit, UnitAction> ua : this.actions) {
            if (!first) {
                w.write(",");
            }
            first = false;
            w.write("{\"unitID\":" + ((Unit)ua.m_a).getID() + ", \"action\":");
            ((UnitAction)ua.m_b).toJSON(w);
            w.write("}");
        }
        w.write("]}");
    }

    public TraceEntry(Element e, UnitTypeTable utt) throws Exception {
        Element actions_e = e.getChild("actions");
        this.time = Integer.parseInt(e.getAttributeValue("time"));
        Element pgs_e = e.getChild(PhysicalGameState.class.getName());
        this.pgs = PhysicalGameState.fromXML(pgs_e, utt);
        for (Object o : actions_e.getChildren()) {
            Element action_e = (Element)o;
            long ID = Long.parseLong(action_e.getAttributeValue("unitID"));
            UnitAction a = new UnitAction(action_e.getChild("UnitAction"), utt);
            Unit u = this.pgs.getUnit(ID);
            if (u == null) {
                System.err.println("Undefined unit ID " + ID + " in action " + a + " at time " + this.time);
            }
            this.actions.add(new Pair<Unit, UnitAction>(u, a));
        }
    }
}

