/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.Writer;
import java.util.Objects;
import java.util.Random;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.ResourceUsage;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class UnitAction {
    public static Random r = new Random();
    public static final int TYPE_NONE = 0;
    public static final int TYPE_MOVE = 1;
    public static final int TYPE_HARVEST = 2;
    public static final int TYPE_RETURN = 3;
    public static final int TYPE_PRODUCE = 4;
    public static final int TYPE_ATTACK_LOCATION = 5;
    public static final int NUMBER_OF_ACTION_TYPES = 6;
    public static String[] actionName = new String[]{"wait", "move", "harvest", "return", "produce", "attack_location"};
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int[] DIRECTION_OFFSET_X = new int[]{0, 1, 0, -1};
    public static final int[] DIRECTION_OFFSET_Y = new int[]{-1, 0, 1, 0};
    public static final String[] DIRECTION_NAMES = new String[]{"up", "right", "down", "left"};
    int type = 0;
    int parameter = -1;
    int x = 0;
    int y = 0;
    UnitType unitType;
    ResourceUsage r_cache;

    public UnitAction(int a_type) {
        this.type = a_type;
    }

    public UnitAction(int a_type, int a_direction) {
        this.type = a_type;
        this.parameter = a_direction;
    }

    public UnitAction(int a_type, int a_direction, UnitType a_unit_type) {
        this.type = a_type;
        this.parameter = a_direction;
        this.unitType = a_unit_type;
    }

    public UnitAction(int a_type, int a_x, int a_y) {
        this.type = a_type;
        this.x = a_x;
        this.y = a_y;
    }

    public UnitAction(UnitAction other) {
        this.type = other.type;
        this.parameter = other.parameter;
        this.x = other.x;
        this.y = other.y;
        this.unitType = other.unitType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnitAction)) {
            return false;
        }
        UnitAction a = (UnitAction)o;
        if (a.type != this.type) {
            return false;
        }
        if (this.type == 0 || this.type == 1 || this.type == 2 || this.type == 3) {
            return a.parameter == this.parameter;
        }
        if (this.type == 5) {
            return a.x == this.x && a.y == this.y;
        }
        return a.parameter == this.parameter && a.unitType == this.unitType;
    }

    public int hashCode() {
        int hash = this.type;
        hash = 19 * hash + this.parameter;
        hash = 19 * hash + this.x;
        hash = 19 * hash + this.y;
        hash = 19 * hash + Objects.hashCode(this.unitType);
        return hash;
    }

    public int getType() {
        return this.type;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public ResourceUsage resourceUsage(Unit u, PhysicalGameState pgs) {
        if (this.r_cache != null) {
            return this.r_cache;
        }
        this.r_cache = new ResourceUsage();
        switch (this.type) {
            case 1: {
                int pos = u.getX() + u.getY() * pgs.getWidth();
                switch (this.parameter) {
                    case 0: {
                        pos -= pgs.getWidth();
                        break;
                    }
                    case 1: {
                        ++pos;
                        break;
                    }
                    case 2: {
                        pos += pgs.getWidth();
                        break;
                    }
                    case 3: {
                        --pos;
                    }
                }
                this.r_cache.positionsUsed.add(pos);
                break;
            }
            case 4: {
                int n = u.getPlayer();
                this.r_cache.resourcesUsed[n] = this.r_cache.resourcesUsed[n] + this.unitType.cost;
                int pos = u.getX() + u.getY() * pgs.getWidth();
                switch (this.parameter) {
                    case 0: {
                        pos -= pgs.getWidth();
                        break;
                    }
                    case 1: {
                        ++pos;
                        break;
                    }
                    case 2: {
                        pos += pgs.getWidth();
                        break;
                    }
                    case 3: {
                        --pos;
                    }
                }
                this.r_cache.positionsUsed.add(pos);
            }
        }
        return this.r_cache;
    }

    public int ETA(Unit u) {
        switch (this.type) {
            case 0: {
                return this.parameter;
            }
            case 1: {
                return u.getMoveTime();
            }
            case 5: {
                return u.getAttackTime();
            }
            case 2: {
                return u.getHarvestTime();
            }
            case 3: {
                return u.getMoveTime();
            }
            case 4: {
                return this.unitType.produceTime;
            }
        }
        return 0;
    }

    public void execute(Unit u, GameState s) {
        PhysicalGameState pgs = s.getPhysicalGameState();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.parameter) {
                    case 0: {
                        u.setY(u.getY() - 1);
                        break;
                    }
                    case 1: {
                        u.setX(u.getX() + 1);
                        break;
                    }
                    case 2: {
                        u.setY(u.getY() + 1);
                        break;
                    }
                    case 3: {
                        u.setX(u.getX() - 1);
                    }
                }
                break;
            }
            case 5: {
                Unit other = pgs.getUnitAt(this.x, this.y);
                if (other == null) break;
                int damage = u.getMinDamage() == u.getMaxDamage() ? u.getMinDamage() : u.getMinDamage() + r.nextInt(1 + (u.getMaxDamage() - u.getMinDamage()));
                other.setHitPoints(other.getHitPoints() - damage);
                if (other.getHitPoints() > 0) break;
                s.removeUnit(other);
                break;
            }
            case 2: {
                Unit maybeAResource = null;
                switch (this.parameter) {
                    case 0: {
                        maybeAResource = pgs.getUnitAt(u.getX(), u.getY() - 1);
                        break;
                    }
                    case 1: {
                        maybeAResource = pgs.getUnitAt(u.getX() + 1, u.getY());
                        break;
                    }
                    case 2: {
                        maybeAResource = pgs.getUnitAt(u.getX(), u.getY() + 1);
                        break;
                    }
                    case 3: {
                        maybeAResource = pgs.getUnitAt(u.getX() - 1, u.getY());
                    }
                }
                if (maybeAResource == null || !maybeAResource.getType().isResource || !u.getType().canHarvest || u.getResources() != 0) break;
                maybeAResource.setResources(maybeAResource.getResources() - u.getHarvestAmount());
                if (maybeAResource.getResources() <= 0) {
                    s.removeUnit(maybeAResource);
                }
                u.setResources(u.getHarvestAmount());
                break;
            }
            case 3: {
                Unit base = null;
                switch (this.parameter) {
                    case 0: {
                        base = pgs.getUnitAt(u.getX(), u.getY() - 1);
                        break;
                    }
                    case 1: {
                        base = pgs.getUnitAt(u.getX() + 1, u.getY());
                        break;
                    }
                    case 2: {
                        base = pgs.getUnitAt(u.getX(), u.getY() + 1);
                        break;
                    }
                    case 3: {
                        base = pgs.getUnitAt(u.getX() - 1, u.getY());
                    }
                }
                if (base == null || !base.getType().isStockpile || u.getResources() <= 0) break;
                Player p = pgs.getPlayer(u.getPlayer());
                p.setResources(p.getResources() + u.getResources());
                u.setResources(0);
                break;
            }
            case 4: {
                Unit newUnit = null;
                int targetx = u.getX();
                int targety = u.getY();
                switch (this.parameter) {
                    case 0: {
                        --targety;
                        break;
                    }
                    case 1: {
                        ++targetx;
                        break;
                    }
                    case 2: {
                        ++targety;
                        break;
                    }
                    case 3: {
                        --targetx;
                    }
                }
                newUnit = new Unit(u.getPlayer(), this.unitType, targetx, targety, 0);
                pgs.addUnit(newUnit);
                Player p = pgs.getPlayer(u.getPlayer());
                p.setResources(p.getResources() - newUnit.getCost());
                if (p.getResources() >= 0) break;
                System.err.print("Illegal action executed! resources of player " + p.ID + " are now " + p.getResources() + "\n");
                System.err.print(s);
            }
        }
    }

    public String toString() {
        String tmp = actionName[this.type] + "(";
        if (this.type == 5) {
            tmp = tmp + this.x + "," + this.y;
        } else if (this.type == 0) {
            tmp = tmp + this.parameter;
        } else {
            if (this.parameter != -1) {
                if (this.parameter == 0) {
                    tmp = tmp + "up";
                }
                if (this.parameter == 1) {
                    tmp = tmp + "right";
                }
                if (this.parameter == 2) {
                    tmp = tmp + "down";
                }
                if (this.parameter == 3) {
                    tmp = tmp + "left";
                }
            }
            if (this.parameter != -1 && this.unitType != null) {
                tmp = tmp + ",";
            }
            if (this.unitType != null) {
                tmp = tmp + this.unitType.name;
            }
        }
        return tmp + ")";
    }

    public String getActionName() {
        return actionName[this.type];
    }

    public int getDirection() {
        return this.parameter;
    }

    public int getLocationX() {
        return this.x;
    }

    public int getLocationY() {
        return this.y;
    }

    public void toxml(XMLWriter w) {
        String attributes = "type=\"" + this.type + "\" ";
        if (this.type == 5) {
            attributes = attributes + "x=\"" + this.x + "\" y=\"" + this.y + "\"";
        } else {
            if (this.parameter != -1) {
                attributes = attributes + "parameter=\"" + this.parameter + "\"";
                if (this.unitType != null) {
                    attributes = attributes + " ";
                }
            }
            if (this.unitType != null) {
                attributes = attributes + "unitType=\"" + this.unitType.name + "\"";
            }
        }
        w.tagWithAttributes("UnitAction", attributes);
        w.tag("/UnitAction");
    }

    public void toJSON(Writer w) throws Exception {
        String attributes = "\"type\":" + this.type + "";
        if (this.type == 5) {
            attributes = attributes + ", \"x\":" + this.x + ",\"y\":" + this.y;
        } else {
            if (this.parameter != -1) {
                attributes = attributes + ", \"parameter\":" + this.parameter;
            }
            if (this.unitType != null) {
                attributes = attributes + ", \"unitType\":\"" + this.unitType.name + "\"";
            }
        }
        w.write("{" + attributes + "}");
    }

    public UnitAction(Element e, UnitTypeTable utt) {
        String typeStr = e.getAttributeValue("type");
        String parameterStr = e.getAttributeValue("parameter");
        String xStr = e.getAttributeValue("x");
        String yStr = e.getAttributeValue("y");
        String unitTypeStr = e.getAttributeValue("unitType");
        this.type = Integer.parseInt(typeStr);
        if (parameterStr != null) {
            this.parameter = Integer.parseInt(parameterStr);
        }
        if (xStr != null) {
            this.x = Integer.parseInt(xStr);
        }
        if (yStr != null) {
            this.y = Integer.parseInt(yStr);
        }
        if (unitTypeStr != null) {
            this.unitType = utt.getUnitType(unitTypeStr);
        }
    }

    public void clearResourceUSageCache() {
        this.r_cache = null;
    }

    public static UnitAction fromXML(Element e, UnitTypeTable utt) {
        return new UnitAction(e, utt);
    }

    public static UnitAction fromJSON(String JSON, UnitTypeTable utt) {
        JsonObject o = Json.parse(JSON).asObject();
        return UnitAction.fromJSON(o, utt);
    }

    public static UnitAction fromJSON(JsonObject o, UnitTypeTable utt) {
        UnitAction ua = new UnitAction(o.getInt("type", 0));
        ua.parameter = o.getInt("parameter", -1);
        ua.x = o.getInt("x", -1);
        ua.y = o.getInt("y", -1);
        String ut = o.getString("unitType", null);
        if (ut != null) {
            ua.unitType = utt.getUnitType(ut);
        }
        return ua;
    }
}

