/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.JsonObject;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.UnitAction;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class Unit
implements Serializable {
    UnitType type;
    public static long next_ID = 0L;
    long ID;
    int player;
    int x;
    int y;
    int resources;
    int hitpoints = 0;

    public Unit(long a_ID, int a_player, UnitType a_type, int a_x, int a_y, int a_resources) {
        this.player = a_player;
        this.type = a_type;
        this.x = a_x;
        this.y = a_y;
        this.resources = a_resources;
        this.hitpoints = a_type.hp;
        this.ID = a_ID;
        if (this.ID >= next_ID) {
            next_ID = this.ID + 1L;
        }
    }

    public Unit(int a_player, UnitType a_type, int a_x, int a_y, int a_resources) {
        this.player = a_player;
        this.type = a_type;
        this.x = a_x;
        this.y = a_y;
        this.resources = a_resources;
        this.hitpoints = a_type.hp;
        this.ID = next_ID++;
    }

    public Unit(int a_player, UnitType a_type, int a_x, int a_y) {
        this.player = a_player;
        this.type = a_type;
        this.x = a_x;
        this.y = a_y;
        this.resources = 0;
        this.hitpoints = a_type.hp;
        this.ID = next_ID++;
    }

    public Unit(Unit other) {
        this.player = other.player;
        this.type = other.type;
        this.x = other.x;
        this.y = other.y;
        this.resources = other.resources;
        this.hitpoints = other.hitpoints;
        this.ID = other.ID;
    }

    public int getPlayer() {
        return this.player;
    }

    public UnitType getType() {
        return this.type;
    }

    public void setType(UnitType a_type) {
        this.type = a_type;
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long a_ID) {
        this.ID = a_ID;
    }

    public int getPosition(PhysicalGameState pgs) {
        return this.x + pgs.getWidth() * this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int a_x) {
        this.x = a_x;
    }

    public void setY(int a_y) {
        this.y = a_y;
    }

    public int getResources() {
        return this.resources;
    }

    public void setResources(int a_resources) {
        this.resources = a_resources;
    }

    public int getHitPoints() {
        return this.hitpoints;
    }

    public int getMaxHitPoints() {
        return this.type.hp;
    }

    public void setHitPoints(int a_hitpoints) {
        this.hitpoints = a_hitpoints;
    }

    public int getCost() {
        return this.type.cost;
    }

    public int getMoveTime() {
        return this.type.moveTime;
    }

    public int getAttackTime() {
        return this.type.attackTime;
    }

    public int getAttackRange() {
        return this.type.attackRange;
    }

    public int getMinDamage() {
        return this.type.minDamage;
    }

    public int getMaxDamage() {
        return this.type.maxDamage;
    }

    public int getHarvestAmount() {
        return this.type.harvestAmount;
    }

    public int getHarvestTime() {
        return this.type.harvestTime;
    }

    public boolean isIdle(GameState s) {
        UnitAction ua = s.getUnitAction(this);
        return ua == null;
    }

    public List<UnitAction> getUnitActions(GameState s) {
        return this.getUnitActions(s, 10);
    }

    public List<UnitAction> getUnitActions(GameState s, int noneDuration) {
        ArrayList<UnitAction> l = new ArrayList<UnitAction>();
        PhysicalGameState pgs = s.getPhysicalGameState();
        Player p = pgs.getPlayer(this.player);
        Unit uup = null;
        Unit uright = null;
        Unit udown = null;
        Unit uleft = null;
        for (Unit unit : pgs.getUnits()) {
            if (unit.x == this.x) {
                if (unit.y == this.y - 1) {
                    uup = unit;
                    continue;
                }
                if (unit.y != this.y + 1) continue;
                udown = unit;
                continue;
            }
            if (unit.y != this.y) continue;
            if (unit.x == this.x - 1) {
                uleft = unit;
                continue;
            }
            if (unit.x != this.x + 1) continue;
            uright = unit;
        }
        if (this.type.canAttack) {
            if (this.type.attackRange == 1) {
                if (this.y > 0 && uup != null && uup.player != this.player && uup.player >= 0) {
                    l.add(new UnitAction(5, uup.x, uup.y));
                }
                if (this.x < pgs.getWidth() - 1 && uright != null && uright.player != this.player && uright.player >= 0) {
                    l.add(new UnitAction(5, uright.x, uright.y));
                }
                if (this.y < pgs.getHeight() - 1 && udown != null && udown.player != this.player && udown.player >= 0) {
                    l.add(new UnitAction(5, udown.x, udown.y));
                }
                if (this.x > 0 && uleft != null && uleft.player != this.player && uleft.player >= 0) {
                    l.add(new UnitAction(5, uleft.x, uleft.y));
                }
            } else {
                int sqrange = this.type.attackRange * this.type.attackRange;
                for (Unit u : pgs.getUnits()) {
                    int sq_dy;
                    int sq_dx;
                    if (u.player < 0 || u.player == this.player || (sq_dx = (u.x - this.x) * (u.x - this.x)) + (sq_dy = (u.y - this.y) * (u.y - this.y)) > sqrange) continue;
                    l.add(new UnitAction(5, u.x, u.y));
                }
            }
        }
        if (this.type.canHarvest) {
            if (this.resources == 0) {
                if (this.y > 0 && uup != null && uup.type.isResource) {
                    l.add(new UnitAction(2, 0));
                }
                if (this.x < pgs.getWidth() - 1 && uright != null && uright.type.isResource) {
                    l.add(new UnitAction(2, 1));
                }
                if (this.y < pgs.getHeight() - 1 && udown != null && udown.type.isResource) {
                    l.add(new UnitAction(2, 2));
                }
                if (this.x > 0 && uleft != null && uleft.type.isResource) {
                    l.add(new UnitAction(2, 3));
                }
            }
            if (this.resources > 0) {
                if (this.y > 0 && uup != null && uup.type.isStockpile && uup.player == this.player) {
                    l.add(new UnitAction(3, 0));
                }
                if (this.x < pgs.getWidth() - 1 && uright != null && uright.type.isStockpile && uright.player == this.player) {
                    l.add(new UnitAction(3, 1));
                }
                if (this.y < pgs.getHeight() - 1 && udown != null && udown.type.isStockpile && udown.player == this.player) {
                    l.add(new UnitAction(3, 2));
                }
                if (this.x > 0 && uleft != null && uleft.type.isStockpile && uleft.player == this.player) {
                    l.add(new UnitAction(3, 3));
                }
            }
        }
        for (UnitType unitType : this.type.produces) {
            int tleft;
            if (p.getResources() < unitType.cost) continue;
            int tup = this.y > 0 ? pgs.getTerrain(this.x, this.y - 1) : 1;
            int tright = this.x < pgs.getWidth() - 1 ? pgs.getTerrain(this.x + 1, this.y) : 1;
            int tdown = this.y < pgs.getHeight() - 1 ? pgs.getTerrain(this.x, this.y + 1) : 1;
            int n = tleft = this.x > 0 ? pgs.getTerrain(this.x - 1, this.y) : 1;
            if (tup == 0 && pgs.getUnitAt(this.x, this.y - 1) == null) {
                l.add(new UnitAction(4, 0, unitType));
            }
            if (tright == 0 && pgs.getUnitAt(this.x + 1, this.y) == null) {
                l.add(new UnitAction(4, 1, unitType));
            }
            if (tdown == 0 && pgs.getUnitAt(this.x, this.y + 1) == null) {
                l.add(new UnitAction(4, 2, unitType));
            }
            if (tleft != 0 || pgs.getUnitAt(this.x - 1, this.y) != null) continue;
            l.add(new UnitAction(4, 3, unitType));
        }
        if (this.type.canMove) {
            int tleft;
            int tup = this.y > 0 ? pgs.getTerrain(this.x, this.y - 1) : 1;
            int n = this.x < pgs.getWidth() - 1 ? pgs.getTerrain(this.x + 1, this.y) : 1;
            int tdown = this.y < pgs.getHeight() - 1 ? pgs.getTerrain(this.x, this.y + 1) : 1;
            int n2 = tleft = this.x > 0 ? pgs.getTerrain(this.x - 1, this.y) : 1;
            if (tup == 0 && uup == null) {
                l.add(new UnitAction(1, 0));
            }
            if (n == 0 && uright == null) {
                l.add(new UnitAction(1, 1));
            }
            if (tdown == 0 && udown == null) {
                l.add(new UnitAction(1, 2));
            }
            if (tleft == 0 && uleft == null) {
                l.add(new UnitAction(1, 3));
            }
        }
        l.add(new UnitAction(0, noneDuration));
        return l;
    }

    public boolean canExecuteAction(UnitAction ua, GameState gs) {
        List<UnitAction> l = this.getUnitActions(gs, ua.ETA(this));
        return l.contains(ua);
    }

    public String toString() {
        return this.type.name + "(" + this.ID + ")(" + this.player + ", (" + this.x + "," + this.y + "), " + this.hitpoints + ", " + this.resources + ")";
    }

    public Unit clone() {
        return new Unit(this);
    }

    public int hashCode() {
        return (int)this.ID;
    }

    public void toxml(XMLWriter w) {
        w.tagWithAttributes(this.getClass().getName(), "type=\"" + this.type.name + "\" ID=\"" + this.ID + "\" player=\"" + this.player + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" resources=\"" + this.resources + "\" hitpoints=\"" + this.hitpoints + "\" ");
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        w.write("{\"type\":\"" + this.type.name + "\", \"ID\":" + this.ID + ", \"player\":" + this.player + ", \"x\":" + this.x + ", \"y\":" + this.y + ", \"resources\":" + this.resources + ", \"hitpoints\":" + this.hitpoints + "}");
    }

    public static Unit fromXML(Element e, UnitTypeTable utt) {
        String typeName = e.getAttributeValue("type");
        String IDStr = e.getAttributeValue("ID");
        String playerStr = e.getAttributeValue("player");
        String xStr = e.getAttributeValue("x");
        String yStr = e.getAttributeValue("y");
        String resourcesStr = e.getAttributeValue("resources");
        String hitpointsStr = e.getAttributeValue("hitpoints");
        long ID = Long.parseLong(IDStr);
        if (ID >= next_ID) {
            next_ID = ID + 1L;
        }
        UnitType type = utt.getUnitType(typeName);
        int player = Integer.parseInt(playerStr);
        int x = Integer.parseInt(xStr);
        int y = Integer.parseInt(yStr);
        int resources = Integer.parseInt(resourcesStr);
        int hitpoints = Integer.parseInt(hitpointsStr);
        Unit u = new Unit(ID, player, type, x, y, resources);
        u.hitpoints = hitpoints;
        return u;
    }

    public static Unit fromJSON(JsonObject o, UnitTypeTable utt) {
        Unit u = new Unit(o.getLong("ID", -1L), o.getInt("player", -1), utt.getUnitType(o.getString("type", null)), o.getInt("x", 0), o.getInt("y", 0), o.getInt("resources", 0));
        u.hitpoints = o.getInt("hitpoints", 1);
        return u;
    }
}

