/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.ArrayList;
import org.jdom.Element;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class UnitType {
    public int ID = 0;
    public String name;
    public int cost = 1;
    public int hp = 1;
    public int minDamage = 1;
    public int maxDamage = 1;
    public int attackRange = 1;
    public int produceTime = 10;
    public int moveTime = 10;
    public int attackTime = 10;
    public int harvestTime = 10;
    public int returnTime = 10;
    public int harvestAmount = 1;
    public int sightRadius = 4;
    public boolean isResource = false;
    public boolean isStockpile = false;
    public boolean canHarvest = false;
    public boolean canMove = true;
    public boolean canAttack = true;
    public ArrayList<UnitType> produces = new ArrayList();
    public ArrayList<UnitType> producedBy = new ArrayList();

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnitType)) {
            return false;
        }
        return this.name.equals(((UnitType)o).name);
    }

    public void produces(UnitType ut) {
        this.produces.add(ut);
        ut.producedBy.add(this);
    }

    static UnitType createStub(Element unittype_e) {
        UnitType ut = new UnitType();
        ut.ID = Integer.parseInt(unittype_e.getAttributeValue("ID"));
        ut.name = unittype_e.getAttributeValue("name");
        return ut;
    }

    static UnitType createStub(JsonObject o) {
        UnitType ut = new UnitType();
        ut.ID = o.getInt("ID", -1);
        ut.name = o.getString("name", null);
        return ut;
    }

    void updateFromXML(Element unittype_e, UnitTypeTable utt) {
        this.cost = Integer.parseInt(unittype_e.getAttributeValue("cost"));
        this.hp = Integer.parseInt(unittype_e.getAttributeValue("hp"));
        this.minDamage = Integer.parseInt(unittype_e.getAttributeValue("minDamage"));
        this.maxDamage = Integer.parseInt(unittype_e.getAttributeValue("maxDamage"));
        this.attackRange = Integer.parseInt(unittype_e.getAttributeValue("attackRange"));
        this.produceTime = Integer.parseInt(unittype_e.getAttributeValue("produceTime"));
        this.moveTime = Integer.parseInt(unittype_e.getAttributeValue("moveTime"));
        this.attackTime = Integer.parseInt(unittype_e.getAttributeValue("attackTime"));
        this.harvestTime = Integer.parseInt(unittype_e.getAttributeValue("harvestTime"));
        this.returnTime = Integer.parseInt(unittype_e.getAttributeValue("returnTime"));
        this.harvestAmount = Integer.parseInt(unittype_e.getAttributeValue("harvestAmount"));
        this.sightRadius = Integer.parseInt(unittype_e.getAttributeValue("sightRadius"));
        this.isResource = Boolean.parseBoolean(unittype_e.getAttributeValue("isResource"));
        this.isStockpile = Boolean.parseBoolean(unittype_e.getAttributeValue("isStockpile"));
        this.canHarvest = Boolean.parseBoolean(unittype_e.getAttributeValue("canHarvest"));
        this.canMove = Boolean.parseBoolean(unittype_e.getAttributeValue("canMove"));
        this.canAttack = Boolean.parseBoolean(unittype_e.getAttributeValue("canAttack"));
        for (Object o : unittype_e.getChildren("produces")) {
            Element produces_e = (Element)o;
            this.produces.add(utt.getUnitType(produces_e.getAttributeValue("type")));
        }
        for (Object o : unittype_e.getChildren("producedBy")) {
            Element producedby_e = (Element)o;
            this.producedBy.add(utt.getUnitType(producedby_e.getAttributeValue("type")));
        }
    }

    void updateFromJSON(String JSON, UnitTypeTable utt) {
        JsonObject o = Json.parse(JSON).asObject();
        this.updateFromJSON(o, utt);
    }

    void updateFromJSON(JsonObject o, UnitTypeTable utt) {
        this.cost = o.getInt("cost", 1);
        this.hp = o.getInt("hp", 1);
        this.minDamage = o.getInt("minDamage", 1);
        this.maxDamage = o.getInt("maxDamage", 1);
        this.attackRange = o.getInt("attackRange", 1);
        this.produceTime = o.getInt("produceTime", 10);
        this.moveTime = o.getInt("moveTime", 10);
        this.attackTime = o.getInt("attackTime", 10);
        this.harvestTime = o.getInt("produceTime", 10);
        this.produceTime = o.getInt("produceTime", 10);
        this.harvestAmount = o.getInt("harvestAmount", 10);
        this.sightRadius = o.getInt("sightRadius", 10);
        this.isResource = o.getBoolean("isResource", false);
        this.isStockpile = o.getBoolean("isStockpile", false);
        this.canHarvest = o.getBoolean("canHarvest", false);
        this.canMove = o.getBoolean("canMove", false);
        this.canAttack = o.getBoolean("canAttack", false);
        JsonArray produces_a = o.get("produces").asArray();
        for (JsonValue v : produces_a.values()) {
            this.produces.add(utt.getUnitType(v.asString()));
        }
        JsonArray producedBy_a = o.get("producedBy").asArray();
        for (JsonValue v : producedBy_a.values()) {
            this.producedBy.add(utt.getUnitType(v.asString()));
        }
    }

    public void toxml(XMLWriter w) {
        w.tagWithAttributes(this.getClass().getName(), "ID=\"" + this.ID + "\" name=\"" + this.name + "\" cost=\"" + this.cost + "\" hp=\"" + this.hp + "\" minDamage=\"" + this.minDamage + "\" maxDamage=\"" + this.maxDamage + "\" attackRange=\"" + this.attackRange + "\" produceTime=\"" + this.produceTime + "\" moveTime=\"" + this.moveTime + "\" attackTime=\"" + this.attackTime + "\" harvestTime=\"" + this.harvestTime + "\" returnTime=\"" + this.returnTime + "\" harvestAmount=\"" + this.harvestAmount + "\" sightRadius=\"" + this.sightRadius + "\" isResource=\"" + this.isResource + "\" isStockpile=\"" + this.isStockpile + "\" canHarvest=\"" + this.canHarvest + "\" canMove=\"" + this.canMove + "\" canAttack=\"" + this.canAttack + "\"");
        for (UnitType ut : this.produces) {
            w.tagWithAttributes("produces", "type=\"" + ut.name + "\"");
            w.tag("/produces");
        }
        for (UnitType ut : this.producedBy) {
            w.tagWithAttributes("producedBy", "type=\"" + ut.name + "\"");
            w.tag("/producedBy");
        }
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        w.write("{\"ID\":" + this.ID + ", \"name\":\"" + this.name + "\", \"cost\":" + this.cost + ", \"hp\":" + this.hp + ", \"minDamage\":" + this.minDamage + ", \"maxDamage\":" + this.maxDamage + ", \"attackRange\":" + this.attackRange + ", \"produceTime\":" + this.produceTime + ", \"moveTime\":" + this.moveTime + ", \"attackTime\":" + this.attackTime + ", \"harvestTime\":" + this.harvestTime + ", \"returnTime\":" + this.returnTime + ", \"harvestAmount\":" + this.harvestAmount + ", \"sightRadius\":" + this.sightRadius + ", \"isResource\":" + this.isResource + ", \"isStockpile\":" + this.isStockpile + ", \"canHarvest\":" + this.canHarvest + ", \"canMove\":" + this.canMove + ", \"canAttack\":" + this.canAttack + ", ");
        boolean first = true;
        w.write("\"produces\":[");
        for (UnitType ut : this.produces) {
            if (!first) {
                w.write(", ");
            }
            w.write("\"" + ut.name + "\"");
            first = false;
        }
        first = true;
        w.write("], \"producedBy\":[");
        for (UnitType ut : this.producedBy) {
            if (!first) {
                w.write(", ");
            }
            w.write("\"" + ut.name + "\"");
            first = false;
        }
        w.write("]}");
    }

    public static UnitType fromXML(Element e, UnitTypeTable utt) {
        UnitType ut = new UnitType();
        ut.updateFromXML(e, utt);
        return ut;
    }

    public static UnitType fromJSON(String JSON, UnitTypeTable utt) {
        UnitType ut = new UnitType();
        ut.updateFromJSON(JSON, utt);
        return ut;
    }

    public static UnitType fromJSON(JsonObject o, UnitTypeTable utt) {
        UnitType ut = new UnitType();
        ut.updateFromJSON(o, utt);
        return ut;
    }
}

