/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import rts.units.UnitType;
import util.XMLWriter;

public class UnitTypeTable {
    public static final int EMPTY_TYPE_TABLE = -1;
    public static final int VERSION_ORIGINAL = 1;
    public static final int VERSION_ORIGINAL_FINETUNED = 2;
    public static final int VERSION_NON_DETERMINISTIC = 3;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_BOTH = 1;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_RANDOM = 2;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_ALTERNATING = 3;
    List<UnitType> unitTypes = new ArrayList<UnitType>();
    int moveConflictResolutionStrategy = 1;

    public UnitTypeTable() {
        this.setUnitTypeTable(1, 1);
    }

    public UnitTypeTable(int version) {
        this.setUnitTypeTable(version, 1);
    }

    public UnitTypeTable(int version, int crs) {
        this.setUnitTypeTable(version, crs);
    }

    public void setUnitTypeTable(int version, int crs) {
        this.moveConflictResolutionStrategy = crs;
        if (version == -1) {
            return;
        }
        UnitType resource = new UnitType();
        resource.name = "Resource";
        resource.isResource = true;
        resource.isStockpile = false;
        resource.canHarvest = false;
        resource.canMove = false;
        resource.canAttack = false;
        resource.sightRadius = 0;
        this.addUnitType(resource);
        UnitType base = new UnitType();
        base.name = "Base";
        base.cost = 10;
        base.hp = 10;
        switch (version) {
            case 1: {
                base.produceTime = 250;
                break;
            }
            case 2: {
                base.produceTime = 200;
            }
        }
        base.isResource = false;
        base.isStockpile = true;
        base.canHarvest = false;
        base.canMove = false;
        base.canAttack = false;
        base.sightRadius = 5;
        this.addUnitType(base);
        UnitType barracks = new UnitType();
        barracks.name = "Barracks";
        barracks.cost = 5;
        barracks.hp = 4;
        switch (version) {
            case 1: {
                barracks.produceTime = 200;
                break;
            }
            case 2: 
            case 3: {
                barracks.produceTime = 100;
            }
        }
        barracks.isResource = false;
        barracks.isStockpile = false;
        barracks.canHarvest = false;
        barracks.canMove = false;
        barracks.canAttack = false;
        barracks.sightRadius = 3;
        this.addUnitType(barracks);
        UnitType worker = new UnitType();
        worker.name = "Worker";
        worker.cost = 1;
        worker.hp = 1;
        switch (version) {
            case 1: 
            case 2: {
                worker.maxDamage = 1;
                worker.minDamage = 1;
                break;
            }
            case 3: {
                worker.minDamage = 0;
                worker.maxDamage = 2;
            }
        }
        worker.attackRange = 1;
        worker.produceTime = 50;
        worker.moveTime = 10;
        worker.attackTime = 5;
        worker.harvestTime = 20;
        worker.returnTime = 10;
        worker.isResource = false;
        worker.isStockpile = false;
        worker.canHarvest = true;
        worker.canMove = true;
        worker.canAttack = true;
        worker.sightRadius = 3;
        this.addUnitType(worker);
        UnitType light = new UnitType();
        light.name = "Light";
        light.cost = 2;
        light.hp = 4;
        switch (version) {
            case 1: 
            case 2: {
                light.maxDamage = 2;
                light.minDamage = 2;
                break;
            }
            case 3: {
                light.minDamage = 1;
                light.maxDamage = 3;
            }
        }
        light.attackRange = 1;
        light.produceTime = 80;
        light.moveTime = 8;
        light.attackTime = 5;
        light.isResource = false;
        light.isStockpile = false;
        light.canHarvest = false;
        light.canMove = true;
        light.canAttack = true;
        light.sightRadius = 2;
        this.addUnitType(light);
        UnitType heavy = new UnitType();
        heavy.name = "Heavy";
        switch (version) {
            case 1: 
            case 2: {
                heavy.maxDamage = 4;
                heavy.minDamage = 4;
                break;
            }
            case 3: {
                heavy.minDamage = 0;
                heavy.maxDamage = 6;
            }
        }
        heavy.attackRange = 1;
        heavy.produceTime = 120;
        switch (version) {
            case 1: {
                heavy.moveTime = 12;
                heavy.hp = 4;
                heavy.cost = 2;
                break;
            }
            case 2: 
            case 3: {
                heavy.moveTime = 10;
                heavy.hp = 8;
                heavy.cost = 3;
            }
        }
        heavy.attackTime = 5;
        heavy.isResource = false;
        heavy.isStockpile = false;
        heavy.canHarvest = false;
        heavy.canMove = true;
        heavy.canAttack = true;
        heavy.sightRadius = 2;
        this.addUnitType(heavy);
        UnitType ranged = new UnitType();
        ranged.name = "Ranged";
        ranged.cost = 2;
        ranged.hp = 1;
        switch (version) {
            case 1: 
            case 2: {
                ranged.maxDamage = 1;
                ranged.minDamage = 1;
                break;
            }
            case 3: {
                ranged.minDamage = 1;
                ranged.maxDamage = 2;
            }
        }
        ranged.attackRange = 3;
        ranged.produceTime = 100;
        ranged.moveTime = 10;
        ranged.attackTime = 5;
        ranged.isResource = false;
        ranged.isStockpile = false;
        ranged.canHarvest = false;
        ranged.canMove = true;
        ranged.canAttack = true;
        ranged.sightRadius = 3;
        this.addUnitType(ranged);
        base.produces(worker);
        barracks.produces(light);
        barracks.produces(heavy);
        barracks.produces(ranged);
        worker.produces(base);
        worker.produces(barracks);
    }

    public void addUnitType(UnitType ut) {
        ut.ID = this.unitTypes.size();
        this.unitTypes.add(ut);
    }

    public UnitType getUnitType(int ID) {
        return this.unitTypes.get(ID);
    }

    public UnitType getUnitType(String name) {
        for (UnitType ut : this.unitTypes) {
            if (!ut.name.equals(name)) continue;
            return ut;
        }
        return null;
    }

    public List<UnitType> getUnitTypes() {
        return this.unitTypes;
    }

    public int getMoveConflictResolutionStrategy() {
        return this.moveConflictResolutionStrategy;
    }

    public void toxml(XMLWriter w) {
        w.tagWithAttributes(this.getClass().getName(), "moveConflictResolutionStrategy=\"" + this.moveConflictResolutionStrategy + "\"");
        for (UnitType ut : this.unitTypes) {
            ut.toxml(w);
        }
        w.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer w) throws Exception {
        boolean first = true;
        w.write("{\"moveConflictResolutionStrategy\":" + this.moveConflictResolutionStrategy + ",");
        w.write("\"unitTypes\":[");
        for (UnitType ut : this.unitTypes) {
            if (!first) {
                w.write(", ");
            }
            ut.toJSON(w);
            first = false;
        }
        w.write("]}");
    }

    public static UnitTypeTable fromXML(Element e) {
        Element unittype_e;
        UnitTypeTable utt = new UnitTypeTable(-1);
        utt.moveConflictResolutionStrategy = Integer.parseInt(e.getAttributeValue("moveConflictResolutionStrategy"));
        for (Object o : e.getChildren()) {
            unittype_e = (Element)o;
            utt.unitTypes.add(UnitType.createStub(unittype_e));
        }
        for (Object o : e.getChildren()) {
            unittype_e = (Element)o;
            utt.getUnitType(unittype_e.getAttributeValue("name")).updateFromXML(unittype_e, utt);
        }
        return utt;
    }

    public static UnitTypeTable fromJSON(String JSON) {
        JsonObject uto;
        JsonObject o = Json.parse(JSON).asObject();
        UnitTypeTable utt = new UnitTypeTable(-1);
        utt.moveConflictResolutionStrategy = o.getInt("moveConflictResolutionStrategy", 1);
        JsonArray a = o.get("unitTypes").asArray();
        for (JsonValue v : a.values()) {
            uto = v.asObject();
            utt.unitTypes.add(UnitType.createStub(uto));
        }
        for (JsonValue v : a.values()) {
            uto = v.asObject();
            utt.getUnitType(uto.getString("name", null)).updateFromJSON(uto, utt);
        }
        return utt;
    }
}

