/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTrace;
import ai.abstraction.AbstractTraceEntry;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.LightRush;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import java.io.FileWriter;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class AbstractTraceGenerationTest {
    public static void main(String[] args) throws Exception {
        UnitTypeTable utt = new UnitTypeTable();
        PhysicalGameState pgs = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", utt);
        GameState gs = new GameState(pgs, utt);
        int MAXCYCLES = 5000;
        boolean gameover = false;
        LightRush ai1 = new LightRush(utt, new BFSPathFinding());
        WorkerRush ai2 = new WorkerRush(utt, new BFSPathFinding());
        AbstractTrace trace = new AbstractTrace(utt);
        AbstractTraceEntry te = new AbstractTraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
        trace.addEntry(te);
        do {
            PlayerAction pa1 = ((AI)ai1).getAction(0, gs);
            PlayerAction pa2 = ((AI)ai2).getAction(1, gs);
            if (!pa1.isEmpty() || !pa2.isEmpty()) {
                AbstractAction aa;
                te = new AbstractTraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
                if (ai1 instanceof AbstractionLayerAI) {
                    AbstractionLayerAI ai1a = ai1;
                    for (Unit u : gs.getUnits()) {
                        aa = ai1a.getAbstractAction(u);
                        if (aa == null) continue;
                        te.addAbstractActionIfNew(u, aa, trace);
                    }
                }
                if (ai2 instanceof AbstractionLayerAI) {
                    AbstractionLayerAI ai2a = ai2;
                    for (Unit u : gs.getUnits()) {
                        aa = ai2a.getAbstractAction(u);
                        if (aa == null) continue;
                        te.addAbstractActionIfNew(u, aa, trace);
                    }
                }
                trace.addEntry(te);
            }
            gs.issueSafe(pa1);
            gs.issueSafe(pa2);
        } while (!(gameover = gs.cycle()) && gs.getTime() < MAXCYCLES);
        te = new AbstractTraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
        trace.addEntry(te);
        XMLWriter xml = new XMLWriter(new FileWriter("abstracttrace.xml"));
        trace.toxml(xml);
        xml.flush();
    }
}

