/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.montecarlo.lsi.LSI;
import ai.montecarlo.lsi.Sampling;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.OutputStreamWriter;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class LMCTest {
    public static void main(String[] args) throws Exception {
        String scenarioFileName = "maps/8x8/basesWorkers8x8.xml";
        UnitTypeTable utt = new UnitTypeTable();
        int MAX_GAME_CYCLES = 3000;
        int SIMULATION_BUDGET = 1000;
        int LOOKAHEAD_CYCLES = 100;
        RandomBiasedAI simulationAi = new RandomBiasedAI();
        SimpleSqrtEvaluationFunction3 evalFunction = new SimpleSqrtEvaluationFunction3();
        LSI ai1 = new LSI(SIMULATION_BUDGET, LOOKAHEAD_CYCLES, 0.25, LSI.EstimateType.RANDOM_TAIL, LSI.EstimateReuseType.ALL, LSI.GenerateType.PER_AGENT, Sampling.AgentOrderingType.ENTROPY, LSI.EvaluateType.HALVING, false, LSI.RelaxationType.NONE, 2, false, simulationAi, evalFunction);
        NaiveMCTS ai2 = new NaiveMCTS(-1, SIMULATION_BUDGET, LOOKAHEAD_CYCLES, 1, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), evalFunction, true);
        PhysicalGameState pgs = PhysicalGameState.load(scenarioFileName, utt);
        GameState gs = new GameState(pgs, utt);
        XMLWriter xml = new XMLWriter(new OutputStreamWriter(System.out));
        pgs.toxml(xml);
        xml.flush();
        PhysicalGameStateJFrame w = PhysicalGameStatePanel.newVisualizer(gs, 640, 640, evalFunction);
        w.repaint();
        boolean gameover = false;
        do {
            long timeMillis = System.currentTimeMillis();
            PlayerAction pa1 = ((AI)ai1).getAction(0, gs);
            PlayerAction pa2 = ((AI)ai2).getAction(1, gs);
            gs.issueSafe(pa1);
            gs.issueSafe(pa2);
            timeMillis = System.currentTimeMillis() - timeMillis;
            if (timeMillis < 50L) {
                Thread.sleep(50L - timeMillis);
            }
            gameover = gs.cycle();
            w.repaint();
        } while (!gameover && gs.getTime() < MAX_GAME_CYCLES);
        System.out.println("Game Over");
        String rec = "";
        rec = rec + scenarioFileName + "\t";
        rec = rec + MAX_GAME_CYCLES + "\t";
        rec = rec + SIMULATION_BUDGET + "\t";
        rec = rec + LOOKAHEAD_CYCLES + "\t";
        rec = rec + simulationAi.getClass().getSimpleName() + "\t";
        rec = rec + evalFunction.getClass().getSimpleName() + "\t";
        rec = rec + ai1.getClass().getSimpleName() + "\t";
        rec = rec + ai2.getClass().getSimpleName() + "\t";
        rec = rec + gs.winner() + "\t";
        rec = rec + ((EvaluationFunction)evalFunction).evaluate(0, 1, gs) + "\t";
        rec = rec + ((AI)ai1).statisticsString() + "\t";
        rec = rec + ((AI)ai2).statisticsString() + "\t";
        System.out.println(rec);
    }
}

