/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.abstraction.LightRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.OutputStreamWriter;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class POGameVisualSimulationTest {
    public static void main(String[] args) throws Exception {
        UnitTypeTable utt = new UnitTypeTable();
        PhysicalGameState pgs = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", utt);
        GameState gs = new GameState(pgs, utt);
        int MAXCYCLES = 5000;
        int PERIOD = 20;
        boolean gameover = false;
        LightRush ai1 = new LightRush(utt, new BFSPathFinding());
        RandomBiasedAI ai2 = new RandomBiasedAI();
        XMLWriter xml = new XMLWriter(new OutputStreamWriter(System.out));
        pgs.toxml(xml);
        xml.flush();
        PhysicalGameStateJFrame w = PhysicalGameStatePanel.newVisualizer(gs, 640, 640, true);
        long nextTimeToUpdate = System.currentTimeMillis() + (long)PERIOD;
        do {
            if (System.currentTimeMillis() >= nextTimeToUpdate) {
                PlayerAction pa1 = ((AI)ai1).getAction(0, new PartiallyObservableGameState(gs, 0));
                PlayerAction pa2 = ((AI)ai2).getAction(1, new PartiallyObservableGameState(gs, 1));
                gs.issueSafe(pa1);
                gs.issueSafe(pa2);
                gameover = gs.cycle();
                w.repaint();
                nextTimeToUpdate += (long)PERIOD;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!gameover && gs.getTime() < MAXCYCLES);
        ai1.gameOver(gs.winner());
        ai2.gameOver(gs.winner());
        System.out.println("Game Over");
    }
}

