/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.ContinuingAI;
import ai.evaluation.SimpleEvaluationFunction;
import ai.mcts.naivemcts.NaiveMCTS;
import gui.MouseController;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PlayGameWithMouseTest {
    public static void main(String[] args) throws Exception {
        UnitTypeTable utt = new UnitTypeTable();
        PhysicalGameState pgs = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", utt);
        GameState gs = new GameState(pgs, utt);
        int MAXCYCLES = 10000;
        int PERIOD = 100;
        boolean gameover = false;
        PhysicalGameStatePanel pgsp = new PhysicalGameStatePanel(gs);
        PhysicalGameStateMouseJFrame w = new PhysicalGameStateMouseJFrame("Game State Visuakizer (Mouse)", 640, 640, pgsp);
        MouseController ai1 = new MouseController(w);
        ContinuingAI ai2 = new ContinuingAI(new NaiveMCTS(PERIOD, -1, 100, 20, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), new SimpleEvaluationFunction(), true));
        long nextTimeToUpdate = System.currentTimeMillis() + (long)PERIOD;
        do {
            if (System.currentTimeMillis() >= nextTimeToUpdate) {
                PlayerAction pa1 = ((AI)ai1).getAction(0, gs);
                PlayerAction pa2 = ((AI)ai2).getAction(1, gs);
                gs.issueSafe(pa1);
                gs.issueSafe(pa2);
                gameover = gs.cycle();
                w.repaint();
                nextTimeToUpdate += (long)PERIOD;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!gameover && gs.getTime() < MAXCYCLES);
        ai1.gameOver(gs.winner());
        ai2.gameOver(gs.winner());
        System.out.println("Game Over");
    }
}

