/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomAI;
import ai.RandomBiasedAI;
import ai.abstraction.HeavyRush;
import ai.abstraction.LightRush;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.AHTNAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ContinuingAI;
import ai.core.InterruptibleAI;
import ai.core.PseudoContinuingAI;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleEvaluationFunction;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.uct.DownsamplingUCT;
import ai.mcts.uct.UCT;
import ai.mcts.uct.UCTUnitActions;
import ai.minimax.ABCD.IDABCD;
import ai.minimax.RTMiniMax.IDRTMinimax;
import ai.minimax.RTMiniMax.IDRTMinimaxRandomized;
import ai.montecarlo.MonteCarlo;
import ai.portfolio.PortfolioAI;
import ai.portfolio.portfoliogreedysearch.PGSAI;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.PuppetNoPlan;
import ai.puppet.PuppetSearchAB;
import ai.puppet.PuppetSearchMCTS;
import ai.puppet.SingleChoiceConfigurableScript;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import rts.PhysicalGameState;
import rts.units.UnitTypeTable;
import tests.Experimenter;
import tests.ExperimenterAsymmetric;

public class RunConfigurableExperiments {
    private static boolean CONTINUING = true;
    private static int TIME = 100;
    private static int MAX_ACTIONS = 100;
    private static int MAX_PLAYOUTS = -1;
    private static int PLAYOUT_TIME = 100;
    private static int MAX_DEPTH = 10;
    private static int RANDOMIZED_AB_REPEATS = 10;
    private static int PUPPET_PLAN_TIME = 5000;
    private static int PUPPET_PLAN_PLAYOUTS = -1;
    private static List<AI> bots1 = new LinkedList<AI>();
    private static List<AI> bots2 = new LinkedList<AI>();
    private static List<PhysicalGameState> maps = new LinkedList<PhysicalGameState>();
    static UnitTypeTable utt = new UnitTypeTable(2, 1);

    public static PathFinding getPathFinding() {
        return new FloodFillPathFinding();
    }

    public static EvaluationFunction getEvaluationFunction() {
        return new SimpleEvaluationFunction();
    }

    public static void loadMaps(String mapFileName) throws IOException {
        if (mapFileName.endsWith(".txt")) {
            try (Stream<String> lines = Files.lines(Paths.get(mapFileName, new String[0]), Charset.defaultCharset());){
                lines.forEachOrdered(line -> {
                    try {
                        if (!line.startsWith("#") && !line.isEmpty()) {
                            maps.add(PhysicalGameState.load(line, utt));
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }
        } else if (mapFileName.endsWith(".xml")) {
            try {
                maps.add(PhysicalGameState.load(mapFileName, utt));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            throw new IllegalArgumentException("Map file name must end in .txt (for a list of maps) or .xml (for a single map).");
        }
    }

    public static AI getBot(String botName) {
        switch (botName) {
            case "RandomAI": {
                return new RandomAI(utt);
            }
            case "RandomBiasedAI": {
                return new RandomBiasedAI();
            }
            case "LightRush": {
                return new LightRush(utt, RunConfigurableExperiments.getPathFinding());
            }
            case "RangedRush": {
                return new RangedRush(utt, RunConfigurableExperiments.getPathFinding());
            }
            case "HeavyRush": {
                return new HeavyRush(utt, RunConfigurableExperiments.getPathFinding());
            }
            case "WorkerRush": {
                return new WorkerRush(utt, RunConfigurableExperiments.getPathFinding());
            }
            case "BasicConfigurableScript": {
                return new BasicConfigurableScript(utt, RunConfigurableExperiments.getPathFinding());
            }
            case "SingleChoiceConfigurableScript": {
                return new SingleChoiceConfigurableScript(RunConfigurableExperiments.getPathFinding(), new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new HeavyRush(utt, RunConfigurableExperiments.getPathFinding())});
            }
            case "PortfolioAI": {
                return new PortfolioAI(new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new RandomBiasedAI()}, new boolean[]{true, true, true, false}, TIME, MAX_PLAYOUTS, PLAYOUT_TIME * 4, RunConfigurableExperiments.getEvaluationFunction());
            }
            case "PGSAI": {
                return new PGSAI(TIME, MAX_PLAYOUTS, PLAYOUT_TIME * 4, 1, 0, RunConfigurableExperiments.getEvaluationFunction(), utt, RunConfigurableExperiments.getPathFinding());
            }
            case "IDRTMinimax": {
                return new IDRTMinimax(TIME, RunConfigurableExperiments.getEvaluationFunction());
            }
            case "IDRTMinimaxRandomized": {
                return new IDRTMinimaxRandomized(TIME, RANDOMIZED_AB_REPEATS, RunConfigurableExperiments.getEvaluationFunction());
            }
            case "IDABCD": {
                return new IDABCD(TIME, MAX_PLAYOUTS, new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), false);
            }
            case "MonteCarlo1": {
                return new MonteCarlo(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "MonteCarlo2": {
                return new MonteCarlo(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_ACTIONS, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "NaiveMCTS1": {
                return new NaiveMCTS(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, 1, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction(), true);
            }
            case "NaiveMCTS2": {
                return new NaiveMCTS(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, 1, 1.0f, 0.0f, 0.25f, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction(), true);
            }
            case "UCT": {
                return new UCT(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_DEPTH, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "DownsamplingUCT": {
                return new DownsamplingUCT(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_ACTIONS, MAX_DEPTH, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "UCTUnitActions": {
                return new UCTUnitActions(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_DEPTH * 10, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "NaiveMCTS3": {
                return new NaiveMCTS(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_DEPTH, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction(), true);
            }
            case "NaiveMCTS4": {
                return new NaiveMCTS(TIME, MAX_PLAYOUTS, PLAYOUT_TIME, MAX_DEPTH, 1.0f, 0.0f, 0.25f, new RandomBiasedAI(), RunConfigurableExperiments.getEvaluationFunction(), true);
            }
            case "AHTN-LL": {
                try {
                    return new AHTNAI("ahtn/microrts-ahtn-definition-lowest-level.lisp", TIME, MAX_PLAYOUTS, PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), new RandomBiasedAI());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "AHTN-LLPF": {
                try {
                    return new AHTNAI("ahtn/microrts-ahtn-definition-low-level.lisp", TIME, MAX_PLAYOUTS, PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), new RandomBiasedAI());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "AHTN-P": {
                try {
                    return new AHTNAI("ahtn/microrts-ahtn-definition-portfolio.lisp", TIME, MAX_PLAYOUTS, PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), new RandomBiasedAI());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "AHTN-F": {
                try {
                    return new AHTNAI("ahtn/microrts-ahtn-definition-flexible-portfolio.lisp", TIME, MAX_PLAYOUTS, PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), new RandomBiasedAI());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "AHTN-FST": {
                try {
                    return new AHTNAI("ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp", TIME, MAX_PLAYOUTS, PLAYOUT_TIME, RunConfigurableExperiments.getEvaluationFunction(), new RandomBiasedAI());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "PuppetABCDSingle": {
                return new PuppetSearchAB(TIME, MAX_PLAYOUTS, PUPPET_PLAN_TIME, PUPPET_PLAN_PLAYOUTS, PLAYOUT_TIME, new SingleChoiceConfigurableScript(RunConfigurableExperiments.getPathFinding(), new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new HeavyRush(utt, RunConfigurableExperiments.getPathFinding())}), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "PuppetABCDSingleNoPlan": {
                return new PuppetNoPlan(new PuppetSearchAB(TIME, MAX_PLAYOUTS, -1, -1, PLAYOUT_TIME, new SingleChoiceConfigurableScript(RunConfigurableExperiments.getPathFinding(), new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new HeavyRush(utt, RunConfigurableExperiments.getPathFinding())}), RunConfigurableExperiments.getEvaluationFunction()));
            }
            case "PuppetABCDBasic": {
                return new PuppetSearchAB(TIME, MAX_PLAYOUTS, PUPPET_PLAN_TIME, PUPPET_PLAN_PLAYOUTS, PLAYOUT_TIME, new BasicConfigurableScript(utt, RunConfigurableExperiments.getPathFinding()), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "PuppetABCDBasicNoPlan": {
                return new PuppetNoPlan(new PuppetSearchAB(TIME, MAX_PLAYOUTS, -1, -1, PLAYOUT_TIME, new BasicConfigurableScript(utt, RunConfigurableExperiments.getPathFinding()), RunConfigurableExperiments.getEvaluationFunction()));
            }
            case "PuppetMCTSSingle": {
                return new PuppetSearchMCTS(TIME, MAX_PLAYOUTS, PUPPET_PLAN_TIME, PUPPET_PLAN_PLAYOUTS, PLAYOUT_TIME, PLAYOUT_TIME, new RandomBiasedAI(), new SingleChoiceConfigurableScript(RunConfigurableExperiments.getPathFinding(), new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new HeavyRush(utt, RunConfigurableExperiments.getPathFinding())}), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "PuppetMCTSSingleNoPlan": {
                return new PuppetNoPlan(new PuppetSearchMCTS(TIME, MAX_PLAYOUTS, -1, -1, PLAYOUT_TIME, PLAYOUT_TIME, new RandomBiasedAI(), new SingleChoiceConfigurableScript(RunConfigurableExperiments.getPathFinding(), new AI[]{new WorkerRush(utt, RunConfigurableExperiments.getPathFinding()), new LightRush(utt, RunConfigurableExperiments.getPathFinding()), new RangedRush(utt, RunConfigurableExperiments.getPathFinding()), new HeavyRush(utt, RunConfigurableExperiments.getPathFinding())}), RunConfigurableExperiments.getEvaluationFunction()));
            }
            case "PuppetMCTSBasic": {
                return new PuppetSearchMCTS(TIME, MAX_PLAYOUTS, PUPPET_PLAN_TIME, PUPPET_PLAN_PLAYOUTS, PLAYOUT_TIME, PLAYOUT_TIME, new RandomBiasedAI(), new BasicConfigurableScript(utt, RunConfigurableExperiments.getPathFinding()), RunConfigurableExperiments.getEvaluationFunction());
            }
            case "PuppetMCTSBasicNoPlan": {
                return new PuppetNoPlan(new PuppetSearchMCTS(TIME, MAX_PLAYOUTS, -1, -1, PLAYOUT_TIME, PLAYOUT_TIME, new RandomBiasedAI(), new BasicConfigurableScript(utt, RunConfigurableExperiments.getPathFinding()), RunConfigurableExperiments.getEvaluationFunction()));
            }
        }
        throw new RuntimeException("AI not found");
    }

    public static void loadBots1(String botFileName) throws IOException {
        try (Stream<String> lines = Files.lines(Paths.get(botFileName, new String[0]), Charset.defaultCharset());){
            lines.forEachOrdered(line -> {
                try {
                    if (!line.startsWith("#") && !line.isEmpty()) {
                        bots1.add(RunConfigurableExperiments.getBot(line));
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    public static void loadBots2(String botFileName) throws IOException {
        try (Stream<String> lines = Files.lines(Paths.get(botFileName, new String[0]), Charset.defaultCharset());){
            lines.forEachOrdered(line -> {
                try {
                    if (!line.startsWith("#") && !line.isEmpty()) {
                        bots2.add(RunConfigurableExperiments.getBot(line));
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    public static void processBots(List<AI> bots) throws Exception {
        if (CONTINUING) {
            LinkedList<AI> botstemp = new LinkedList<AI>();
            for (AI bot : bots) {
                if (bot instanceof AIWithComputationBudget) {
                    if (bot instanceof InterruptibleAI) {
                        botstemp.add(new ContinuingAI(bot));
                        continue;
                    }
                    botstemp.add(new PseudoContinuingAI((AIWithComputationBudget)bot));
                    continue;
                }
                botstemp.add(bot);
            }
            bots.clear();
            bots.addAll(botstemp);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean asymetric = !args[1].equals("-");
        RunConfigurableExperiments.loadBots1(args[0]);
        if (asymetric) {
            RunConfigurableExperiments.loadBots2(args[1]);
        }
        RunConfigurableExperiments.processBots(bots1);
        if (asymetric) {
            RunConfigurableExperiments.processBots(bots2);
        }
        RunConfigurableExperiments.loadMaps(args[2]);
        PrintStream out = new PrintStream(new File(args[3]));
        int iterations = Integer.parseInt(args[4]);
        String traceDir = null;
        boolean saveTrace = false;
        boolean saveZip = false;
        if (args.length >= 6) {
            saveTrace = true;
            saveZip = true;
            traceDir = args[5];
        }
        if (asymetric) {
            ExperimenterAsymmetric.runExperiments(bots1, bots2, maps, utt, iterations, 3000, 300, false, out, saveTrace, saveZip, traceDir);
        } else {
            Experimenter.runExperiments(bots1, maps, utt, iterations, 3000, 300, false, out, -1, true, false, saveTrace, saveZip, traceDir);
        }
    }
}

