/*
 * Decompiled with CFR 0.152.
 */
package tests.trace;

import ai.RandomBiasedAI;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.Trace;
import rts.TraceEntry;
import rts.units.UnitTypeTable;
import tests.MapGenerator;

public class ZipTraceGenerationTest {
    public static void main(String[] args) throws Exception {
        UnitTypeTable utt = new UnitTypeTable();
        MapGenerator mg = new MapGenerator(utt);
        PhysicalGameState pgs = mg.basesWorkers8x8Obstacle();
        GameState gs = new GameState(pgs, utt);
        int MAXCYCLES = 5000;
        boolean gameover = false;
        RandomBiasedAI ai1 = new RandomBiasedAI();
        WorkerRush ai2 = new WorkerRush(utt, new BFSPathFinding());
        Trace trace = new Trace(utt);
        TraceEntry te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
        trace.addEntry(te);
        do {
            PlayerAction pa1 = ((AI)ai1).getAction(0, gs);
            PlayerAction pa2 = ((AI)ai2).getAction(1, gs);
            if (!pa1.isEmpty() || !pa2.isEmpty()) {
                te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
                te.addPlayerAction(pa1.clone());
                te.addPlayerAction(pa2.clone());
                trace.addEntry(te);
            }
            gs.issueSafe(pa1);
            gs.issueSafe(pa2);
        } while (!(gameover = gs.cycle()) && gs.getTime() < MAXCYCLES);
        ai1.gameOver(gs.winner());
        ai2.gameOver(gs.winner());
        te = new TraceEntry(gs.getPhysicalGameState().clone(), gs.getTime());
        trace.addEntry(te);
        trace.toZip("trace.zip");
        System.out.println("Done.");
    }
}

