/*
 * Decompiled with CFR 0.152.
 */
package tournaments;

import ai.core.AIWithComputationBudget;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LoadTournamentAIs {
    public static List<Class> loadTournamentAIsFromFolder(String path) throws Exception {
        ArrayList<Class> cl = new ArrayList<Class>();
        File f = new File(path);
        if (f.isDirectory()) {
            for (File f2 : f.listFiles()) {
                if (!f2.getName().endsWith(".jar")) continue;
                cl.addAll(LoadTournamentAIs.loadTournamentAIsFromJAR(f2.getAbsolutePath()));
            }
        }
        return cl;
    }

    public static List<Class> loadTournamentAIsFromJAR(String jarPath) throws Exception {
        ZipEntry e;
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{new File(jarPath).toURI().toURL()}, LoadTournamentAIs.class.getClassLoader());
        ArrayList<Class> cs = new ArrayList<Class>();
        URL jar = new File(jarPath).toURI().toURL();
        ZipInputStream zip = new ZipInputStream(jar.openStream());
        while ((e = zip.getNextEntry()) != null) {
            Class<?> c;
            String name = e.getName();
            if (!name.endsWith(".class") || Modifier.isAbstract((c = loader.loadClass(name.substring(0, name.length() - 6).replace('/', '.'))).getModifiers()) || !LoadTournamentAIs.isTournamentAIClass(c)) continue;
            cs.add(c);
        }
        return cs;
    }

    public static boolean isTournamentAIClass(Class c) {
        if (c == AIWithComputationBudget.class) {
            return true;
        }
        if ((c = c.getSuperclass()) != null) {
            return LoadTournamentAIs.isTournamentAIClass(c);
        }
        return false;
    }
}

