/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CartesianProduct<E> {
    private final List<List<E>> domains = new ArrayList<List<E>>();

    public CartesianProduct(List<Set<E>> definitionsOfDomains) {
        if (definitionsOfDomains.size() == 0) {
            throw new IllegalArgumentException("There has to be at least one domain!");
        }
        for (Set<E> set : definitionsOfDomains) {
            this.domains.add(new ArrayList<E>(set));
        }
    }

    public List<E> element(int i) {
        LinkedList<E> result = new LinkedList<E>();
        for (List<E> currentDomain : this.domains) {
            int currentSize = currentDomain.size();
            int currentIndex = i % currentSize;
            i /= currentSize;
            result.add(currentDomain.get(currentIndex));
        }
        if (i > 0) {
            result = null;
        }
        return result;
    }

    public int size() {
        int result = 1;
        for (List<E> currentDomain : this.domains) {
            result *= currentDomain.size();
        }
        return result;
    }
}

