/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Sampler {
    static Random generator = new Random();

    public static int random(double[] distribution) {
        return generator.nextInt(distribution.length);
    }

    public static int random(List<Double> distribution) {
        return generator.nextInt(distribution.size());
    }

    public static int max(double[] distribution) throws Exception {
        LinkedList<Integer> best = new LinkedList<Integer>();
        double max = distribution[0];
        for (int i = 0; i < distribution.length; ++i) {
            double f = distribution[i];
            if (f == max) {
                best.add(i);
                continue;
            }
            if (!(f > max)) continue;
            best.clear();
            best.add(i);
            max = f;
        }
        if (best.size() > 0) {
            return (Integer)best.get(generator.nextInt(best.size()));
        }
        throw new Exception("Input distribution empty in Sampler.max!");
    }

    public static int max(List<Double> distribution) throws Exception {
        LinkedList<Integer> best = new LinkedList<Integer>();
        double max = distribution.get(0);
        for (int i = 0; i < distribution.size(); ++i) {
            double f = distribution.get(i);
            if (f == max) {
                best.add(i);
                continue;
            }
            if (!(f > max)) continue;
            best.clear();
            best.add(i);
            max = f;
        }
        if (best.size() > 0) {
            return (Integer)best.get(generator.nextInt(best.size()));
        }
        throw new Exception("Input distribution empty in Sampler.max!");
    }

    public static Double maxScore(double[] distribution) {
        LinkedList<Integer> best = new LinkedList<Integer>();
        double max = distribution[0];
        for (int i = 0; i < distribution.length; ++i) {
            double f = distribution[i];
            if (f == max) {
                best.add(i);
                continue;
            }
            if (!(f > max)) continue;
            best.clear();
            best.add(i);
            max = f;
        }
        return max;
    }

    public static int weighted(double[] distribution) throws Exception {
        double total = 0.0;
        double accum = 0.0;
        for (double f : distribution) {
            total += f;
        }
        if (total == 0.0) {
            return Sampler.random(distribution);
        }
        double tmp = generator.nextDouble() * total;
        for (int i = 0; i < distribution.length; ++i) {
            if (!((accum += distribution[i]) >= tmp)) continue;
            return i;
        }
        throw new Exception("Input distribution empty in Sampler.weighted!");
    }

    public static Object weighted(List<Double> distribution, List<?> outputs) throws Exception {
        double total = 0.0;
        double accum = 0.0;
        for (double f : distribution) {
            total += f;
        }
        if (total == 0.0) {
            return outputs.get(generator.nextInt(outputs.size()));
        }
        double tmp = generator.nextDouble() * total;
        for (int i = 0; i < distribution.size(); ++i) {
            if (!((accum += distribution.get(i).doubleValue()) >= tmp)) continue;
            return outputs.get(i);
        }
        throw new Exception("Input distribution empty in Sampler.weighted!");
    }

    public static int explorationWeighted(double[] distribution, double e) throws Exception {
        double exponent = 0.0;
        double quotient = 1.0 - e;
        exponent = quotient != 0.0 ? 1.0 / quotient - 1.0 : 1000.0;
        double[] exponentiated = new double[distribution.length];
        for (int i = 0; i < distribution.length; ++i) {
            exponentiated[i] = Math.pow(distribution[i], exponent);
        }
        return Sampler.weighted(exponentiated);
    }

    public static int eGreedy(List<Double> distribution, double e) throws Exception {
        if (generator.nextDouble() < e) {
            return Sampler.random(distribution);
        }
        return Sampler.max(distribution);
    }
}

