/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.Writer;

public class XMLWriter {
    private static final int tabsize = 2;
    private String lineSeparator = "\n";
    private int spaces;
    private Writer writer;

    public XMLWriter(Writer w) {
        this.writer = w;
        this.spaces = 0;
    }

    public XMLWriter(Writer w, String a_lineSeparator) {
        this.writer = w;
        this.lineSeparator = a_lineSeparator;
        this.spaces = 0;
    }

    public void resetTab() {
        this.spaces = 0;
    }

    public void tab() {
        this.spaces += 2;
    }

    private void untab() {
        this.spaces -= 2;
    }

    private void indent() {
        for (int i = 0; i < this.spaces; ++i) {
            try {
                this.writer.write(" ");
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTab(int t) {
        if (t >= 0) {
            this.spaces += t * 2;
        }
    }

    public void tag(String tagname, Object val) {
        this.tag(tagname, val.toString());
    }

    public void tag(String tagname, String value) {
        this.indent();
        try {
            this.writer.write("<" + tagname + ">" + value + "</" + tagname + ">" + this.lineSeparator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void tag(String tagname, int value) {
        this.tag(tagname, "" + value);
    }

    public void tag(String tagname, long value) {
        this.tag(tagname, "" + value);
    }

    public void tag(String tagname, double value) {
        this.tag(tagname, "" + value);
    }

    public void tag(String tagname) {
        if (tagname.charAt(0) == '/') {
            this.untab();
        }
        this.indent();
        try {
            this.writer.write("<" + tagname + ">" + this.lineSeparator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tagname.charAt(0) != '/') {
            this.tab();
        }
    }

    public void tagWithAttributes(String tagname, String attributesString) {
        if (tagname.charAt(0) == '/') {
            this.untab();
        }
        this.indent();
        try {
            this.writer.write("<" + tagname + " " + attributesString + ">" + this.lineSeparator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tagname.charAt(0) != '/') {
            this.tab();
        }
    }

    public void rawXML(String xml) {
        try {
            this.writer.write(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Writer getWriter() {
        return this.writer;
    }
}

