import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsTxtRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Host to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/txt_record_set#host DataDnsTxtRecordSet#host}
    */
    readonly host: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/txt_record_set dns_txt_record_set}
*/
export declare class DataDnsTxtRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_txt_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/txt_record_set dns_txt_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsTxtRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsTxtRecordSetConfig);
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    get record(): string;
    get records(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
