import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TxtRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the record set. The `zone` argument will be appended to this value to create the full record path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set#name TxtRecordSet#name}
    */
    readonly name?: string;
    /**
    * The TTL of the record set. Defaults to `3600`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set#ttl TxtRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * The text records this record set will be set to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set#txt TxtRecordSet#txt}
    */
    readonly txt: string[];
    /**
    * DNS zone the record set belongs to. It must be an FQDN, that is, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set#zone TxtRecordSet#zone}
    */
    readonly zone: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set dns_txt_record_set}
*/
export declare class TxtRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "dns_txt_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/txt_record_set dns_txt_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TxtRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: TxtRecordSetConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _txt?;
    get txt(): string[];
    set txt(value: string[]);
    get txtInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
