import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsARecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Host to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set#host DataDnsARecordSet#host}
    */
    readonly host: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set dns_a_record_set}
*/
export declare class DataDnsARecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_a_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set dns_a_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsARecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsARecordSetConfig);
    get addrs(): string[];
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
