import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsCnameRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Host to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/cname_record_set#host DataDnsCnameRecordSet#host}
    */
    readonly host: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/cname_record_set dns_cname_record_set}
*/
export declare class DataDnsCnameRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_cname_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/cname_record_set dns_cname_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsCnameRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsCnameRecordSetConfig);
    get cname(): string;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
