import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SrvRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the record set. The `zone` argument will be appended to this value to create the full record path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#name SrvRecordSet#name}
    */
    readonly name: string;
    /**
    * The TTL of the record set. Defaults to `3600`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#ttl SrvRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * DNS zone the record set belongs to. It must be an FQDN, that is, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#zone SrvRecordSet#zone}
    */
    readonly zone: string;
    /**
    * srv block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#srv SrvRecordSet#srv}
    */
    readonly srv?: SrvRecordSetSrv[] | cdktf.IResolvable;
}
export interface SrvRecordSetSrv {
    /**
    * The port for the service on the target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#port SrvRecordSet#port}
    */
    readonly port: number;
    /**
    * The priority for the record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#priority SrvRecordSet#priority}
    */
    readonly priority: number;
    /**
    * The FQDN of the target, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#target SrvRecordSet#target}
    */
    readonly target: string;
    /**
    * The weight for the record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set#weight SrvRecordSet#weight}
    */
    readonly weight: number;
}
export declare function srvRecordSetSrvToTerraform(struct?: SrvRecordSetSrv | cdktf.IResolvable): any;
export declare class SrvRecordSetSrvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SrvRecordSetSrv | cdktf.IResolvable | undefined;
    set internalValue(value: SrvRecordSetSrv | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
}
export declare class SrvRecordSetSrvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SrvRecordSetSrv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SrvRecordSetSrvOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set dns_srv_record_set}
*/
export declare class SrvRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "dns_srv_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/srv_record_set dns_srv_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SrvRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: SrvRecordSetConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _srv;
    get srv(): SrvRecordSetSrvList;
    putSrv(value: SrvRecordSetSrv[] | cdktf.IResolvable): void;
    resetSrv(): void;
    get srvInput(): cdktf.IResolvable | SrvRecordSetSrv[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
