# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_slcs.ipynb.

# %% auto 0
__all__ = ['safeslice', 'slcchain', 'try2slc', 'asslc']

# %% ../nbs/06_slcs.ipynb 6
#| export


# %% ../nbs/06_slcs.ipynb 8
#| export


# %% ../nbs/06_slcs.ipynb 10
#| export


# %% ../nbs/06_slcs.ipynb 12
from quac import intq
from chck import notnone, isslice, isiter
from sigr import applyfns

# %% ../nbs/06_slcs.ipynb 14
from .atyp import P

# %% ../nbs/06_slcs.ipynb 17
def safeslice(s: slice) -> slice:
    '''Corrects a slice object, replacing None values with defaults to prevent errors.
    
    Returns a slice with default values instead None values from the input slice.
    e.g. slice(IntQ, IntQ, IntQ) -> slice(0, 1, 1)
    
    Parameters
    ----------
    s : slice
        The slice object to correct.
        
    Returns
    -------
    slice
        A corrected slice object with no None values.
    '''
    if not isslice(s): return s
    start = s.start if notnone(s.start) else 0
    stop  = s.stop  if notnone(s.stop)  else min(0, start, max(1, start))
    step  = s.step  if notnone(s.step)  else 1
    return slice(start, stop, step)

# %% ../nbs/06_slcs.ipynb 19
def slcchain(x, funcs, *args: P.args, **kwargs: P.kwargs): 
    '''Applies a sequence of functions (`funcs`) to an initial value `x`, 
    optionally stopping when the typeguard function `isslice` returns `True`.
    
    See Also
    --------
    sigr.applyfns
    ''' 
    return applyfns(x, funcs, *args, check=isslice, **kwargs)

# %% ../nbs/06_slcs.ipynb 23
def try2slc(a) -> slice:
    '''Attempts to convert `a` to a slice object, falling back to `a` if unsuccessful.
    
    Parameters
    ----------
    a : Any
        The input object to convert.
        
    Returns
    -------
    slice
        A slice object if conversion is successful, otherwise `a`.
    '''
    if isslice(a): return a
    try: return slice(*list((a, )if not isiter(a) else a))    
    except: return a

# %% ../nbs/06_slcs.ipynb 25
def asslc(a, *args: P.args, **kwargs: P.kwargs) -> slice:
    '''Ensures `a` is represented as or converted to a slice object, 
    applying corrections and conversions as needed.
    
    Parameters
    ----------
    a : Any
        The input object to convert.
        
    *args : P.args
        Additional positional arguments for conversion functions.
        
    **kwargs : P.kwargs
        Additional keyword arguments for conversion functions.
        
    Other Parameters
    ----------------
    __nones_ok : bool
        If `True`, the result is not corrected to prevent None values.
        
    Returns
    -------
    slice
        A slice object representing `a`, corrected if necessary.
    '''
    if isslice(a): return a
    chain = (safeslice, try2slc, )
    slc = slcchain(a, chain, *args, **kwargs)
    if kwargs.pop('__nones_ok', False): return slc
    return safeslice(slc)
