"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OwnerTypedDict(TypedDict):
    r"""Personal data of your customer."""

    email: str
    r"""The email address of your customer."""
    given_name: str
    r"""The given name (first name) of your customer."""
    family_name: str
    r"""The family name (surname) of your customer."""
    locale: NotRequired[Nullable[str]]
    r"""Preset the language to be used for the login screen, if applicable. For the consent screen, the preferred language of the logged in merchant will be used and this parameter is ignored.

    When this parameter is omitted, the browser language will be used instead.
    """


class Owner(BaseModel):
    r"""Personal data of your customer."""

    email: str
    r"""The email address of your customer."""

    given_name: Annotated[str, pydantic.Field(alias="givenName")]
    r"""The given name (first name) of your customer."""

    family_name: Annotated[str, pydantic.Field(alias="familyName")]
    r"""The family name (surname) of your customer."""

    locale: OptionalNullable[str] = UNSET
    r"""Preset the language to be used for the login screen, if applicable. For the consent screen, the preferred language of the logged in merchant will be used and this parameter is ignored.

    When this parameter is omitted, the browser language will be used instead.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["locale"]
        nullable_fields = ["locale"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateClientLinkAddressTypedDict(TypedDict):
    r"""Address of the organization."""

    country: str
    r"""The country of the address in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    street_and_number: NotRequired[Nullable[str]]
    r"""The street name and house number of the organization."""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the organization. Required if a street address is provided and if the country has a postal code system."""
    city: NotRequired[Nullable[str]]
    r"""The city of the organization. Required if a street address is provided."""


class CreateClientLinkAddress(BaseModel):
    r"""Address of the organization."""

    country: str
    r"""The country of the address in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    street_and_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAndNumber")
    ] = UNSET
    r"""The street name and house number of the organization."""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the organization. Required if a street address is provided and if the country has a postal code system."""

    city: OptionalNullable[str] = UNSET
    r"""The city of the organization. Required if a street address is provided."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["streetAndNumber", "postalCode", "city"]
        nullable_fields = ["streetAndNumber", "postalCode", "city"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateClientLinkRequestBodyTypedDict(TypedDict):
    owner: OwnerTypedDict
    r"""Personal data of your customer."""
    name: str
    r"""Name of the organization."""
    address: CreateClientLinkAddressTypedDict
    r"""Address of the organization."""
    registration_number: NotRequired[Nullable[str]]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union. VAT numbers are verified against the international registry *VIES*."""


class CreateClientLinkRequestBody(BaseModel):
    owner: Owner
    r"""Personal data of your customer."""

    name: str
    r"""Name of the organization."""

    address: CreateClientLinkAddress
    r"""Address of the organization."""

    registration_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="registrationNumber")
    ] = UNSET
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union. VAT numbers are verified against the international registry *VIES*."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["registrationNumber", "vatNumber"]
        nullable_fields = ["registrationNumber", "vatNumber"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateClientLinkClientLinksResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateClientLinkClientLinksResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateClientLinkClientLinksResponseLinksTypedDict(TypedDict):
    documentation: CreateClientLinkClientLinksResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateClientLinkClientLinksResponseLinks(BaseModel):
    documentation: CreateClientLinkClientLinksResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateClientLinkClientLinksResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        CreateClientLinkClientLinksResponseLinks, pydantic.Field(alias="_links")
    ]


class CreateClientLinkClientLinksResponseResponseBody(Exception):
    r"""An error response object."""

    data: CreateClientLinkClientLinksResponseResponseBodyData

    def __init__(self, data: CreateClientLinkClientLinksResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreateClientLinkClientLinksResponseResponseBodyData
        )


class CreateClientLinkClientLinksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateClientLinkClientLinksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateClientLinkClientLinksLinksTypedDict(TypedDict):
    documentation: CreateClientLinkClientLinksDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateClientLinkClientLinksLinks(BaseModel):
    documentation: CreateClientLinkClientLinksDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateClientLinkClientLinksResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[CreateClientLinkClientLinksLinks, pydantic.Field(alias="_links")]


class CreateClientLinkClientLinksResponseBody(Exception):
    r"""An error response object."""

    data: CreateClientLinkClientLinksResponseBodyData

    def __init__(self, data: CreateClientLinkClientLinksResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreateClientLinkClientLinksResponseBodyData
        )


class CreateClientLinkSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateClientLinkSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ClientLinkTypedDict(TypedDict):
    r"""The link you can send your customer to, where they can either log in and link their account, or sign up and proceed with onboarding."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ClientLink(BaseModel):
    r"""The link you can send your customer to, where they can either log in and link their account, or sign up and proceed with onboarding."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateClientLinkDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateClientLinkDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateClientLinkLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[CreateClientLinkSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    client_link: NotRequired[ClientLinkTypedDict]
    r"""The link you can send your customer to, where they can either log in and link their account, or sign up and proceed with onboarding."""
    documentation: NotRequired[CreateClientLinkDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateClientLinkLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[CreateClientLinkSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    client_link: Annotated[Optional[ClientLink], pydantic.Field(alias="clientLink")] = (
        None
    )
    r"""The link you can send your customer to, where they can either log in and link their account, or sign up and proceed with onboarding."""

    documentation: Optional[CreateClientLinkDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateClientLinkResponseBodyTypedDict(TypedDict):
    r"""The newly created client link object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a client link object. Will always contain the string `client-link` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this client link. Example: `cl_vZCnNQsV2UtfXxYifWKWH`."""
    links: NotRequired[CreateClientLinkLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateClientLinkResponseBody(BaseModel):
    r"""The newly created client link object."""

    resource: Optional[str] = "client-link"
    r"""Indicates the response contains a client link object. Will always contain the string `client-link` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this client link. Example: `cl_vZCnNQsV2UtfXxYifWKWH`."""

    links: Annotated[
        Optional[CreateClientLinkLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
