"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateProfileRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: NotRequired[Nullable[str]]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: NotRequired[Nullable[str]]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[Nullable[str]]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[Nullable[List[str]]]
    r"""A list of countries where you expect that the majority of the profile's customers reside, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    business_category: NotRequired[Nullable[str]]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""
    mode: NotRequired[Nullable[str]]
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review the profile before it can start accepting payments.

    Possible values: `live` `test`
    """


class UpdateProfileRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: OptionalNullable[str] = UNSET
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: OptionalNullable[str] = UNSET
    r"""The email address associated with the profile's trade name or brand."""

    phone: OptionalNullable[str] = UNSET
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = UNSET
    r"""A list of countries where you expect that the majority of the profile's customers reside, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    business_category: Annotated[
        OptionalNullable[str], pydantic.Field(alias="businessCategory")
    ] = UNSET
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""

    mode: OptionalNullable[str] = UNSET
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review the profile before it can start accepting payments.

    Possible values: `live` `test`
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        nullable_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: UpdateProfileRequestBodyTypedDict


class UpdateProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        UpdateProfileRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateProfileProfilesResponse422DocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileProfilesResponse422Documentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileProfilesResponse422LinksTypedDict(TypedDict):
    documentation: UpdateProfileProfilesResponse422DocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponse422Links(BaseModel):
    documentation: UpdateProfileProfilesResponse422Documentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponse422ResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        UpdateProfileProfilesResponse422Links, pydantic.Field(alias="_links")
    ]


class UpdateProfileProfilesResponse422ResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileProfilesResponse422ResponseBodyData

    def __init__(self, data: UpdateProfileProfilesResponse422ResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, UpdateProfileProfilesResponse422ResponseBodyData
        )


class UpdateProfileProfilesResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileProfilesResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileProfilesResponseLinksTypedDict(TypedDict):
    documentation: UpdateProfileProfilesResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseLinks(BaseModel):
    documentation: UpdateProfileProfilesResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateProfileProfilesResponseLinks, pydantic.Field(alias="_links")]


class UpdateProfileProfilesResponseResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileProfilesResponseResponseBodyData

    def __init__(self, data: UpdateProfileProfilesResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, UpdateProfileProfilesResponseResponseBodyData
        )


class UpdateProfileProfilesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileProfilesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileProfilesLinksTypedDict(TypedDict):
    documentation: UpdateProfileProfilesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesLinks(BaseModel):
    documentation: UpdateProfileProfilesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateProfileProfilesLinks, pydantic.Field(alias="_links")]


class UpdateProfileProfilesResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileProfilesResponseBodyData

    def __init__(self, data: UpdateProfileProfilesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateProfileProfilesResponseBodyData)


class UpdateProfileReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    status: NotRequired[str]
    r"""The status of the requested changes.

    Possible values: `pending` `rejected`
    """


class UpdateProfileReview(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    status: Optional[str] = None
    r"""The status of the requested changes.

    Possible values: `pending` `rejected`
    """


class UpdateProfileSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDashboardTypedDict(TypedDict):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDashboard(BaseModel):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileChargebacks(BaseModel):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileMethodsTypedDict(TypedDict):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileMethods(BaseModel):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfilePaymentsTypedDict(TypedDict):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfilePayments(BaseModel):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileRefundsTypedDict(TypedDict):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileRefunds(BaseModel):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileCheckoutPreviewURLTypedDict(TypedDict):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileCheckoutPreviewURL(BaseModel):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[UpdateProfileSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[UpdateProfileDashboardTypedDict]
    r"""Link to the profile in the Mollie dashboard."""
    chargebacks: NotRequired[UpdateProfileChargebacksTypedDict]
    r"""The API resource URL of the chargebacks that belong to this profile."""
    methods: NotRequired[UpdateProfileMethodsTypedDict]
    r"""The API resource URL of the methods that are enabled for this profile."""
    payments: NotRequired[UpdateProfilePaymentsTypedDict]
    r"""The API resource URL of the payments that belong to this profile."""
    refunds: NotRequired[UpdateProfileRefundsTypedDict]
    r"""The API resource URL of the refunds that belong to this profile."""
    checkout_preview_url: NotRequired[UpdateProfileCheckoutPreviewURLTypedDict]
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""
    documentation: NotRequired[UpdateProfileDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateProfileLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[UpdateProfileSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[UpdateProfileDashboard] = None
    r"""Link to the profile in the Mollie dashboard."""

    chargebacks: Optional[UpdateProfileChargebacks] = None
    r"""The API resource URL of the chargebacks that belong to this profile."""

    methods: Optional[UpdateProfileMethods] = None
    r"""The API resource URL of the methods that are enabled for this profile."""

    payments: Optional[UpdateProfilePayments] = None
    r"""The API resource URL of the payments that belong to this profile."""

    refunds: Optional[UpdateProfileRefunds] = None
    r"""The API resource URL of the refunds that belong to this profile."""

    checkout_preview_url: Annotated[
        Optional[UpdateProfileCheckoutPreviewURL],
        pydantic.Field(alias="checkoutPreviewUrl"),
    ] = None
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    documentation: Optional[UpdateProfileDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateProfileResponseBodyTypedDict(TypedDict):
    r"""The updated profile object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""
    status: NotRequired[str]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.

    Possible values: `unverified` `verified` `blocked`
    """
    review: NotRequired[UpdateProfileReviewTypedDict]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[UpdateProfileLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class UpdateProfileResponseBody(BaseModel):
    r"""The updated profile object."""

    resource: Optional[str] = "profile"
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""

    status: Optional[str] = None
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.

    Possible values: `unverified` `verified` `blocked`
    """

    review: Optional[UpdateProfileReview] = None
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved automatically, unless a switch to a live profile has been requested. The review object will therefore usually be `null` in test mode."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[UpdateProfileLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
