# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataSourcesResult',
    'AwaitableGetDataSourcesResult',
    'get_data_sources',
    'get_data_sources_output',
]

@pulumi.output_type
class GetDataSourcesResult:
    """
    A collection of values returned by getDataSources.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, data_source_collections=None, data_source_feed_provider=None, display_name=None, filters=None, id=None, logging_query_type=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if data_source_collections and not isinstance(data_source_collections, list):
            raise TypeError("Expected argument 'data_source_collections' to be a list")
        pulumi.set(__self__, "data_source_collections", data_source_collections)
        if data_source_feed_provider and not isinstance(data_source_feed_provider, str):
            raise TypeError("Expected argument 'data_source_feed_provider' to be a str")
        pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logging_query_type and not isinstance(logging_query_type, str):
            raise TypeError("Expected argument 'logging_query_type' to be a str")
        pulumi.set(__self__, "logging_query_type", logging_query_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        CompartmentId of Data source.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="dataSourceCollections")
    def data_source_collections(self) -> Sequence['outputs.GetDataSourcesDataSourceCollectionResult']:
        """
        The list of data_source_collection.
        """
        return pulumi.get(self, "data_source_collections")

    @property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> Optional[str]:
        """
        Possible type of dataSourceFeed Provider(LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        DisplayName of Data source.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataSourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loggingQueryType")
    def logging_query_type(self) -> Optional[str]:
        """
        Logging query type for data source (Sighting/Insight)
        """
        return pulumi.get(self, "logging_query_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDataSourcesResult(GetDataSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourcesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            data_source_collections=self.data_source_collections,
            data_source_feed_provider=self.data_source_feed_provider,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            logging_query_type=self.logging_query_type,
            state=self.state)


def get_data_sources(access_level: Optional[str] = None,
                     compartment_id: Optional[str] = None,
                     compartment_id_in_subtree: Optional[bool] = None,
                     data_source_feed_provider: Optional[str] = None,
                     display_name: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetDataSourcesFilterArgs']]] = None,
                     logging_query_type: Optional[str] = None,
                     state: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourcesResult:
    """
    This data source provides the list of Data Sources in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all Data Sources in a compartment

    The ListDataSources operation returns only the data Sources in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListdataSources on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_sources = oci.CloudGuard.get_data_sources(compartment_id=compartment_id,
        access_level=data_source_access_level,
        compartment_id_in_subtree=data_source_compartment_id_in_subtree,
        data_source_feed_provider=data_source_data_source_feed_provider,
        display_name=data_source_display_name,
        logging_query_type=data_source_logging_query_type,
        state=data_source_state)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
    :param str data_source_feed_provider: A filter to return only resources their feedProvider matches the given DataSourceFeedProvider.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str logging_query_type: A filter to return only resources their query type matches the given LoggingQueryType.
    :param str state: The field life cycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['dataSourceFeedProvider'] = data_source_feed_provider
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['loggingQueryType'] = logging_query_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDataSources:getDataSources', __args__, opts=opts, typ=GetDataSourcesResult).value

    return AwaitableGetDataSourcesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        data_source_collections=pulumi.get(__ret__, 'data_source_collections'),
        data_source_feed_provider=pulumi.get(__ret__, 'data_source_feed_provider'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        logging_query_type=pulumi.get(__ret__, 'logging_query_type'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_data_sources)
def get_data_sources_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                            compartment_id: Optional[pulumi.Input[str]] = None,
                            compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                            data_source_feed_provider: Optional[pulumi.Input[Optional[str]]] = None,
                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDataSourcesFilterArgs']]]]] = None,
                            logging_query_type: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataSourcesResult]:
    """
    This data source provides the list of Data Sources in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all Data Sources in a compartment

    The ListDataSources operation returns only the data Sources in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListdataSources on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_sources = oci.CloudGuard.get_data_sources(compartment_id=compartment_id,
        access_level=data_source_access_level,
        compartment_id_in_subtree=data_source_compartment_id_in_subtree,
        data_source_feed_provider=data_source_data_source_feed_provider,
        display_name=data_source_display_name,
        logging_query_type=data_source_logging_query_type,
        state=data_source_state)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
    :param str data_source_feed_provider: A filter to return only resources their feedProvider matches the given DataSourceFeedProvider.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str logging_query_type: A filter to return only resources their query type matches the given LoggingQueryType.
    :param str state: The field life cycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    ...
