# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerInstanceArgs', 'ContainerInstance']

@pulumi.input_type
class ContainerInstanceArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 containers: pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]],
                 shape: pulumi.Input[str],
                 shape_config: pulumi.Input['ContainerInstanceShapeConfigArgs'],
                 vnics: pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]],
                 container_restart_policy: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_config: Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 graceful_shutdown_timeout_in_seconds: Optional[pulumi.Input[str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]] = None):
        """
        The set of arguments for constructing a ContainerInstance resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the container instance runs.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]] containers: The containers to create on this container instance.
        :param pulumi.Input[str] shape: The shape of the container instance. The shape determines the resources available to the container instance.
        :param pulumi.Input['ContainerInstanceShapeConfigArgs'] shape_config: The size and amount of resources available to the container instance.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]] vnics: The networks available to containers on this container instance.
        :param pulumi.Input[str] container_restart_policy: Container restart policy
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input['ContainerInstanceDnsConfigArgs'] dns_config: Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        :param pulumi.Input[str] fault_domain: The fault domain where the container instance runs.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] graceful_shutdown_timeout_in_seconds: The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]] image_pull_secrets: The image pulls secrets so you can access private registry to pull container images.
        :param pulumi.Input[str] state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]] volumes: A volume is a directory with data that is accessible across multiple containers in a container instance.
               
               You can attach up to 32 volumes to single container instance.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_config", shape_config)
        pulumi.set(__self__, "vnics", vnics)
        if container_restart_policy is not None:
            pulumi.set(__self__, "container_restart_policy", container_restart_policy)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if graceful_shutdown_timeout_in_seconds is not None:
            pulumi.set(__self__, "graceful_shutdown_timeout_in_seconds", graceful_shutdown_timeout_in_seconds)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]]:
        """
        The containers to create on this container instance.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        The shape of the container instance. The shape determines the resources available to the container instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> pulumi.Input['ContainerInstanceShapeConfigArgs']:
        """
        The size and amount of resources available to the container instance.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: pulumi.Input['ContainerInstanceShapeConfigArgs']):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter
    def vnics(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]]:
        """
        The networks available to containers on this container instance.
        """
        return pulumi.get(self, "vnics")

    @vnics.setter
    def vnics(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]]):
        pulumi.set(self, "vnics", value)

    @property
    @pulumi.getter(name="containerRestartPolicy")
    def container_restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Container restart policy
        """
        return pulumi.get(self, "container_restart_policy")

    @container_restart_policy.setter
    def container_restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_restart_policy", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']]:
        """
        Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gracefulShutdownTimeoutInSeconds")
    def graceful_shutdown_timeout_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        """
        return pulumi.get(self, "graceful_shutdown_timeout_in_seconds")

    @graceful_shutdown_timeout_in_seconds.setter
    def graceful_shutdown_timeout_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_shutdown_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]]:
        """
        The image pulls secrets so you can access private registry to pull container images.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]]:
        """
        A volume is a directory with data that is accessible across multiple containers in a container instance.

        You can attach up to 32 volumes to single container instance.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _ContainerInstanceState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 container_count: Optional[pulumi.Input[int]] = None,
                 container_restart_policy: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_config: Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 graceful_shutdown_timeout_in_seconds: Optional[pulumi.Input[str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_config: Optional[pulumi.Input['ContainerInstanceShapeConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 vnics: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]]] = None,
                 volume_count: Optional[pulumi.Input[int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering ContainerInstance resources.
        :param pulumi.Input[str] availability_domain: The availability domain where the container instance runs.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID.
        :param pulumi.Input[int] container_count: The number of containers on the container instance.
        :param pulumi.Input[str] container_restart_policy: Container restart policy
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]] containers: The containers to create on this container instance.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input['ContainerInstanceDnsConfigArgs'] dns_config: Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        :param pulumi.Input[str] fault_domain: The fault domain where the container instance runs.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] graceful_shutdown_timeout_in_seconds: The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]] image_pull_secrets: The image pulls secrets so you can access private registry to pull container images.
        :param pulumi.Input[str] lifecycle_details: A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        :param pulumi.Input[str] shape: The shape of the container instance. The shape determines the resources available to the container instance.
        :param pulumi.Input['ContainerInstanceShapeConfigArgs'] shape_config: The size and amount of resources available to the container instance.
        :param pulumi.Input[str] state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        :param pulumi.Input[str] time_created: The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] time_updated: The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]] vnics: The networks available to containers on this container instance.
        :param pulumi.Input[int] volume_count: The number of volumes that are attached to the container instance.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]] volumes: A volume is a directory with data that is accessible across multiple containers in a container instance.
               
               You can attach up to 32 volumes to single container instance.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if container_count is not None:
            pulumi.set(__self__, "container_count", container_count)
        if container_restart_policy is not None:
            pulumi.set(__self__, "container_restart_policy", container_restart_policy)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if graceful_shutdown_timeout_in_seconds is not None:
            pulumi.set(__self__, "graceful_shutdown_timeout_in_seconds", graceful_shutdown_timeout_in_seconds)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vnics is not None:
            pulumi.set(__self__, "vnics", vnics)
        if volume_count is not None:
            pulumi.set(__self__, "volume_count", volume_count)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="containerCount")
    def container_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of containers on the container instance.
        """
        return pulumi.get(self, "container_count")

    @container_count.setter
    def container_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_count", value)

    @property
    @pulumi.getter(name="containerRestartPolicy")
    def container_restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Container restart policy
        """
        return pulumi.get(self, "container_restart_policy")

    @container_restart_policy.setter
    def container_restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_restart_policy", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]]]:
        """
        The containers to create on this container instance.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']]:
        """
        Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['ContainerInstanceDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gracefulShutdownTimeoutInSeconds")
    def graceful_shutdown_timeout_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        """
        return pulumi.get(self, "graceful_shutdown_timeout_in_seconds")

    @graceful_shutdown_timeout_in_seconds.setter
    def graceful_shutdown_timeout_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_shutdown_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]]:
        """
        The image pulls secrets so you can access private registry to pull container images.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceImagePullSecretArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the container instance. The shape determines the resources available to the container instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['ContainerInstanceShapeConfigArgs']]:
        """
        The size and amount of resources available to the container instance.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['ContainerInstanceShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def vnics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]]]:
        """
        The networks available to containers on this container instance.
        """
        return pulumi.get(self, "vnics")

    @vnics.setter
    def vnics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVnicArgs']]]]):
        pulumi.set(self, "vnics", value)

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of volumes that are attached to the container instance.
        """
        return pulumi.get(self, "volume_count")

    @volume_count.setter
    def volume_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_count", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]]:
        """
        A volume is a directory with data that is accessible across multiple containers in a container instance.

        You can attach up to 32 volumes to single container instance.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


class ContainerInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 container_restart_policy: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceContainerArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceDnsConfigArgs']]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 graceful_shutdown_timeout_in_seconds: Optional[pulumi.Input[str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceImagePullSecretArgs']]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceShapeConfigArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vnics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVnicArgs']]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVolumeArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Container Instance resource in Oracle Cloud Infrastructure Container Instances service.

        Creates a container instance and deploys the containers on it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_instance = oci.container_engine.ContainerInstance("test_container_instance",
            availability_domain=container_instance_availability_domain,
            compartment_id=compartment_id,
            containers=[oci.container_engine.ContainerInstanceContainerArgs(
                image_url=container_instance_containers_image_url,
                arguments=container_instance_containers_arguments,
                commands=container_instance_containers_command,
                defined_tags=container_instance_containers_defined_tags,
                display_name=container_instance_containers_display_name,
                environment_variables=container_instance_containers_environment_variables,
                freeform_tags=container_instance_containers_freeform_tags,
                health_checks=[oci.container_engine.ContainerInstanceContainerHealthCheckArgs(
                    health_check_type=container_instance_containers_health_checks_health_check_type,
                    commands=container_instance_containers_health_checks_command,
                    failure_action=container_instance_containers_health_checks_failure_action,
                    failure_threshold=container_instance_containers_health_checks_failure_threshold,
                    headers=[oci.container_engine.ContainerInstanceContainerHealthCheckHeaderArgs(
                        name=container_instance_containers_health_checks_headers_name,
                        value=container_instance_containers_health_checks_headers_value,
                    )],
                    initial_delay_in_seconds=container_instance_containers_health_checks_initial_delay_in_seconds,
                    interval_in_seconds=container_instance_containers_health_checks_interval_in_seconds,
                    name=container_instance_containers_health_checks_name,
                    path=container_instance_containers_health_checks_path,
                    port=container_instance_containers_health_checks_port,
                    success_threshold=container_instance_containers_health_checks_success_threshold,
                    timeout_in_seconds=container_instance_containers_health_checks_timeout_in_seconds,
                )],
                is_resource_principal_disabled=container_instance_containers_is_resource_principal_disabled,
                resource_config=oci.container_engine.ContainerInstanceContainerResourceConfigArgs(
                    memory_limit_in_gbs=container_instance_containers_resource_config_memory_limit_in_gbs,
                    vcpus_limit=container_instance_containers_resource_config_vcpus_limit,
                ),
                security_context=oci.container_engine.ContainerInstanceContainerSecurityContextArgs(
                    capabilities=oci.container_engine.ContainerInstanceContainerSecurityContextCapabilitiesArgs(
                        add_capabilities=container_instance_containers_security_context_capabilities_add_capabilities,
                        drop_capabilities=container_instance_containers_security_context_capabilities_drop_capabilities,
                    ),
                    is_non_root_user_check_enabled=container_instance_containers_security_context_is_non_root_user_check_enabled,
                    is_root_file_system_readonly=container_instance_containers_security_context_is_root_file_system_readonly,
                    run_as_group=container_instance_containers_security_context_run_as_group,
                    run_as_user=container_instance_containers_security_context_run_as_user,
                    security_context_type=container_instance_containers_security_context_security_context_type,
                ),
                volume_mounts=[oci.container_engine.ContainerInstanceContainerVolumeMountArgs(
                    mount_path=container_instance_containers_volume_mounts_mount_path,
                    volume_name=container_instance_containers_volume_mounts_volume_name,
                    is_read_only=container_instance_containers_volume_mounts_is_read_only,
                    partition=container_instance_containers_volume_mounts_partition,
                    sub_path=container_instance_containers_volume_mounts_sub_path,
                )],
                working_directory=container_instance_containers_working_directory,
            )],
            shape=container_instance_shape,
            shape_config=oci.container_engine.ContainerInstanceShapeConfigArgs(
                ocpus=container_instance_shape_config_ocpus,
                memory_in_gbs=container_instance_shape_config_memory_in_gbs,
            ),
            vnics=[oci.container_engine.ContainerInstanceVnicArgs(
                subnet_id=test_subnet["id"],
                defined_tags=container_instance_vnics_defined_tags,
                display_name=container_instance_vnics_display_name,
                freeform_tags=container_instance_vnics_freeform_tags,
                hostname_label=container_instance_vnics_hostname_label,
                is_public_ip_assigned=container_instance_vnics_is_public_ip_assigned,
                nsg_ids=container_instance_vnics_nsg_ids,
                private_ip=container_instance_vnics_private_ip,
                skip_source_dest_check=container_instance_vnics_skip_source_dest_check,
            )],
            container_restart_policy=container_instance_container_restart_policy,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=container_instance_display_name,
            dns_config=oci.container_engine.ContainerInstanceDnsConfigArgs(
                nameservers=container_instance_dns_config_nameservers,
                options=container_instance_dns_config_options,
                searches=container_instance_dns_config_searches,
            ),
            fault_domain=container_instance_fault_domain,
            freeform_tags={
                "bar-key": "value",
            },
            graceful_shutdown_timeout_in_seconds=container_instance_graceful_shutdown_timeout_in_seconds,
            image_pull_secrets=[oci.container_engine.ContainerInstanceImagePullSecretArgs(
                registry_endpoint=container_instance_image_pull_secrets_registry_endpoint,
                secret_type=container_instance_image_pull_secrets_secret_type,
                password=container_instance_image_pull_secrets_password,
                secret_id=test_secret["id"],
                username=container_instance_image_pull_secrets_username,
            )],
            volumes=[oci.container_engine.ContainerInstanceVolumeArgs(
                name=container_instance_volumes_name,
                volume_type=container_instance_volumes_volume_type,
                backing_store=container_instance_volumes_backing_store,
                configs=[oci.container_engine.ContainerInstanceVolumeConfigArgs(
                    data=container_instance_volumes_configs_data,
                    file_name=container_instance_volumes_configs_file_name,
                    path=container_instance_volumes_configs_path,
                )],
            )])
        ```

        ## Import

        ContainerInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/containerInstance:ContainerInstance test_container_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the container instance runs.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID.
        :param pulumi.Input[str] container_restart_policy: Container restart policy
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceContainerArgs']]]] containers: The containers to create on this container instance.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[pulumi.InputType['ContainerInstanceDnsConfigArgs']] dns_config: Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        :param pulumi.Input[str] fault_domain: The fault domain where the container instance runs.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] graceful_shutdown_timeout_in_seconds: The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceImagePullSecretArgs']]]] image_pull_secrets: The image pulls secrets so you can access private registry to pull container images.
        :param pulumi.Input[str] shape: The shape of the container instance. The shape determines the resources available to the container instance.
        :param pulumi.Input[pulumi.InputType['ContainerInstanceShapeConfigArgs']] shape_config: The size and amount of resources available to the container instance.
        :param pulumi.Input[str] state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVnicArgs']]]] vnics: The networks available to containers on this container instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVolumeArgs']]]] volumes: A volume is a directory with data that is accessible across multiple containers in a container instance.
               
               You can attach up to 32 volumes to single container instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Container Instance resource in Oracle Cloud Infrastructure Container Instances service.

        Creates a container instance and deploys the containers on it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_instance = oci.container_engine.ContainerInstance("test_container_instance",
            availability_domain=container_instance_availability_domain,
            compartment_id=compartment_id,
            containers=[oci.container_engine.ContainerInstanceContainerArgs(
                image_url=container_instance_containers_image_url,
                arguments=container_instance_containers_arguments,
                commands=container_instance_containers_command,
                defined_tags=container_instance_containers_defined_tags,
                display_name=container_instance_containers_display_name,
                environment_variables=container_instance_containers_environment_variables,
                freeform_tags=container_instance_containers_freeform_tags,
                health_checks=[oci.container_engine.ContainerInstanceContainerHealthCheckArgs(
                    health_check_type=container_instance_containers_health_checks_health_check_type,
                    commands=container_instance_containers_health_checks_command,
                    failure_action=container_instance_containers_health_checks_failure_action,
                    failure_threshold=container_instance_containers_health_checks_failure_threshold,
                    headers=[oci.container_engine.ContainerInstanceContainerHealthCheckHeaderArgs(
                        name=container_instance_containers_health_checks_headers_name,
                        value=container_instance_containers_health_checks_headers_value,
                    )],
                    initial_delay_in_seconds=container_instance_containers_health_checks_initial_delay_in_seconds,
                    interval_in_seconds=container_instance_containers_health_checks_interval_in_seconds,
                    name=container_instance_containers_health_checks_name,
                    path=container_instance_containers_health_checks_path,
                    port=container_instance_containers_health_checks_port,
                    success_threshold=container_instance_containers_health_checks_success_threshold,
                    timeout_in_seconds=container_instance_containers_health_checks_timeout_in_seconds,
                )],
                is_resource_principal_disabled=container_instance_containers_is_resource_principal_disabled,
                resource_config=oci.container_engine.ContainerInstanceContainerResourceConfigArgs(
                    memory_limit_in_gbs=container_instance_containers_resource_config_memory_limit_in_gbs,
                    vcpus_limit=container_instance_containers_resource_config_vcpus_limit,
                ),
                security_context=oci.container_engine.ContainerInstanceContainerSecurityContextArgs(
                    capabilities=oci.container_engine.ContainerInstanceContainerSecurityContextCapabilitiesArgs(
                        add_capabilities=container_instance_containers_security_context_capabilities_add_capabilities,
                        drop_capabilities=container_instance_containers_security_context_capabilities_drop_capabilities,
                    ),
                    is_non_root_user_check_enabled=container_instance_containers_security_context_is_non_root_user_check_enabled,
                    is_root_file_system_readonly=container_instance_containers_security_context_is_root_file_system_readonly,
                    run_as_group=container_instance_containers_security_context_run_as_group,
                    run_as_user=container_instance_containers_security_context_run_as_user,
                    security_context_type=container_instance_containers_security_context_security_context_type,
                ),
                volume_mounts=[oci.container_engine.ContainerInstanceContainerVolumeMountArgs(
                    mount_path=container_instance_containers_volume_mounts_mount_path,
                    volume_name=container_instance_containers_volume_mounts_volume_name,
                    is_read_only=container_instance_containers_volume_mounts_is_read_only,
                    partition=container_instance_containers_volume_mounts_partition,
                    sub_path=container_instance_containers_volume_mounts_sub_path,
                )],
                working_directory=container_instance_containers_working_directory,
            )],
            shape=container_instance_shape,
            shape_config=oci.container_engine.ContainerInstanceShapeConfigArgs(
                ocpus=container_instance_shape_config_ocpus,
                memory_in_gbs=container_instance_shape_config_memory_in_gbs,
            ),
            vnics=[oci.container_engine.ContainerInstanceVnicArgs(
                subnet_id=test_subnet["id"],
                defined_tags=container_instance_vnics_defined_tags,
                display_name=container_instance_vnics_display_name,
                freeform_tags=container_instance_vnics_freeform_tags,
                hostname_label=container_instance_vnics_hostname_label,
                is_public_ip_assigned=container_instance_vnics_is_public_ip_assigned,
                nsg_ids=container_instance_vnics_nsg_ids,
                private_ip=container_instance_vnics_private_ip,
                skip_source_dest_check=container_instance_vnics_skip_source_dest_check,
            )],
            container_restart_policy=container_instance_container_restart_policy,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=container_instance_display_name,
            dns_config=oci.container_engine.ContainerInstanceDnsConfigArgs(
                nameservers=container_instance_dns_config_nameservers,
                options=container_instance_dns_config_options,
                searches=container_instance_dns_config_searches,
            ),
            fault_domain=container_instance_fault_domain,
            freeform_tags={
                "bar-key": "value",
            },
            graceful_shutdown_timeout_in_seconds=container_instance_graceful_shutdown_timeout_in_seconds,
            image_pull_secrets=[oci.container_engine.ContainerInstanceImagePullSecretArgs(
                registry_endpoint=container_instance_image_pull_secrets_registry_endpoint,
                secret_type=container_instance_image_pull_secrets_secret_type,
                password=container_instance_image_pull_secrets_password,
                secret_id=test_secret["id"],
                username=container_instance_image_pull_secrets_username,
            )],
            volumes=[oci.container_engine.ContainerInstanceVolumeArgs(
                name=container_instance_volumes_name,
                volume_type=container_instance_volumes_volume_type,
                backing_store=container_instance_volumes_backing_store,
                configs=[oci.container_engine.ContainerInstanceVolumeConfigArgs(
                    data=container_instance_volumes_configs_data,
                    file_name=container_instance_volumes_configs_file_name,
                    path=container_instance_volumes_configs_path,
                )],
            )])
        ```

        ## Import

        ContainerInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/containerInstance:ContainerInstance test_container_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param ContainerInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 container_restart_policy: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceContainerArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceDnsConfigArgs']]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 graceful_shutdown_timeout_in_seconds: Optional[pulumi.Input[str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceImagePullSecretArgs']]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceShapeConfigArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vnics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVnicArgs']]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVolumeArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerInstanceArgs.__new__(ContainerInstanceArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["container_restart_policy"] = container_restart_policy
            if containers is None and not opts.urn:
                raise TypeError("Missing required property 'containers'")
            __props__.__dict__["containers"] = containers
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_config"] = dns_config
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["graceful_shutdown_timeout_in_seconds"] = graceful_shutdown_timeout_in_seconds
            __props__.__dict__["image_pull_secrets"] = image_pull_secrets
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            if shape_config is None and not opts.urn:
                raise TypeError("Missing required property 'shape_config'")
            __props__.__dict__["shape_config"] = shape_config
            __props__.__dict__["state"] = state
            if vnics is None and not opts.urn:
                raise TypeError("Missing required property 'vnics'")
            __props__.__dict__["vnics"] = vnics
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["container_count"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["volume_count"] = None
        super(ContainerInstance, __self__).__init__(
            'oci:ContainerEngine/containerInstance:ContainerInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            container_count: Optional[pulumi.Input[int]] = None,
            container_restart_policy: Optional[pulumi.Input[str]] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceContainerArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dns_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceDnsConfigArgs']]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            graceful_shutdown_timeout_in_seconds: Optional[pulumi.Input[str]] = None,
            image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceImagePullSecretArgs']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            shape_config: Optional[pulumi.Input[pulumi.InputType['ContainerInstanceShapeConfigArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            vnics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVnicArgs']]]]] = None,
            volume_count: Optional[pulumi.Input[int]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVolumeArgs']]]]] = None) -> 'ContainerInstance':
        """
        Get an existing ContainerInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the container instance runs.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID.
        :param pulumi.Input[int] container_count: The number of containers on the container instance.
        :param pulumi.Input[str] container_restart_policy: Container restart policy
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceContainerArgs']]]] containers: The containers to create on this container instance.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[pulumi.InputType['ContainerInstanceDnsConfigArgs']] dns_config: Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        :param pulumi.Input[str] fault_domain: The fault domain where the container instance runs.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] graceful_shutdown_timeout_in_seconds: The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceImagePullSecretArgs']]]] image_pull_secrets: The image pulls secrets so you can access private registry to pull container images.
        :param pulumi.Input[str] lifecycle_details: A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        :param pulumi.Input[str] shape: The shape of the container instance. The shape determines the resources available to the container instance.
        :param pulumi.Input[pulumi.InputType['ContainerInstanceShapeConfigArgs']] shape_config: The size and amount of resources available to the container instance.
        :param pulumi.Input[str] state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        :param pulumi.Input[str] time_created: The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] time_updated: The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVnicArgs']]]] vnics: The networks available to containers on this container instance.
        :param pulumi.Input[int] volume_count: The number of volumes that are attached to the container instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerInstanceVolumeArgs']]]] volumes: A volume is a directory with data that is accessible across multiple containers in a container instance.
               
               You can attach up to 32 volumes to single container instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerInstanceState.__new__(_ContainerInstanceState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["container_count"] = container_count
        __props__.__dict__["container_restart_policy"] = container_restart_policy
        __props__.__dict__["containers"] = containers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_config"] = dns_config
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["graceful_shutdown_timeout_in_seconds"] = graceful_shutdown_timeout_in_seconds
        __props__.__dict__["image_pull_secrets"] = image_pull_secrets
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["shape"] = shape
        __props__.__dict__["shape_config"] = shape_config
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vnics"] = vnics
        __props__.__dict__["volume_count"] = volume_count
        __props__.__dict__["volumes"] = volumes
        return ContainerInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerCount")
    def container_count(self) -> pulumi.Output[int]:
        """
        The number of containers on the container instance.
        """
        return pulumi.get(self, "container_count")

    @property
    @pulumi.getter(name="containerRestartPolicy")
    def container_restart_policy(self) -> pulumi.Output[str]:
        """
        Container restart policy
        """
        return pulumi.get(self, "container_restart_policy")

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Sequence['outputs.ContainerInstanceContainer']]:
        """
        The containers to create on this container instance.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> pulumi.Output['outputs.ContainerInstanceDnsConfig']:
        """
        Allow customers to define DNS settings for containers. If this is not provided, the containers use the default DNS settings of the subnet.
        """
        return pulumi.get(self, "dns_config")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracefulShutdownTimeoutInSeconds")
    def graceful_shutdown_timeout_in_seconds(self) -> pulumi.Output[str]:
        """
        The amount of time that processes in a container have to gracefully end when the container must be stopped. For example, when you delete a container instance. After the timeout is reached, the processes are sent a signal to be deleted.
        """
        return pulumi.get(self, "graceful_shutdown_timeout_in_seconds")

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> pulumi.Output[Sequence['outputs.ContainerInstanceImagePullSecret']]:
        """
        The image pulls secrets so you can access private registry to pull container images.
        """
        return pulumi.get(self, "image_pull_secrets")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the container instance. The shape determines the resources available to the container instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> pulumi.Output['outputs.ContainerInstanceShapeConfig']:
        """
        The size and amount of resources available to the container instance.
        """
        return pulumi.get(self, "shape_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def vnics(self) -> pulumi.Output[Sequence['outputs.ContainerInstanceVnic']]:
        """
        The networks available to containers on this container instance.
        """
        return pulumi.get(self, "vnics")

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> pulumi.Output[int]:
        """
        The number of volumes that are attached to the container instance.
        """
        return pulumi.get(self, "volume_count")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.ContainerInstanceVolume']]:
        """
        A volume is a directory with data that is accessible across multiple containers in a container instance.

        You can attach up to 32 volumes to single container instance.
        """
        return pulumi.get(self, "volumes")

