import { CfnElement } from './cfn-element';
import { Construct } from './construct-compat';
export interface CfnOutputProps {
    /**
     * A String type that describes the output value.
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     */
    readonly description?: string;
    /**
     * The value of the property returned by the aws cloudformation describe-stacks command.
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    readonly value: string;
    /**
     * The name used to export the value of this output across stacks.
     *
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     *
     * @default - the output is not exported
     */
    readonly exportName?: string;
    /**
     * A condition to associate with this output value. If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     */
    readonly condition?: CfnCondition;
}
export declare class CfnOutput extends CfnElement {
    private _description?;
    private _condition?;
    private _value?;
    private _exportName?;
    /**
     * Creates an CfnOutput value for this stack.
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     */
    constructor(scope: Construct, id: string, props: CfnOutputProps);
    /**
     * Returns the description of this Output
     */
    get description(): string | undefined;
    /**
     * Sets this output's description to the parameter
     * @param description the description to update this Output's description to
     */
    set description(description: string | undefined);
    /**
     * Returns the value of this Output
     */
    get value(): any;
    /**
     * Sets this output's value to the parameter
     * @param value the value to update this Output's value to
     */
    set value(value: any);
    /**
     * Returns the condition of this Output
     */
    get condition(): CfnCondition | undefined;
    /**
     * Sets this output's condition to the parameter
     * @param condition the condition to update this Output's condition to
     */
    set condition(condition: CfnCondition | undefined);
    /**
     * Returns the export of this Output
     */
    get exportName(): string | undefined;
    /**
     * Sets this output's export to the parameter
     * @param exportName the export to update this Output's export to
     */
    set exportName(exportName: string | undefined);
}
import { CfnCondition } from './cfn-condition';
