# coding: utf-8

"""
    Daytona Server API

    Daytona Server API

    The version of the OpenAPI document: v0.0.0-dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from api_client.models.clone_target import CloneTarget
from typing import Optional, Set
from typing_extensions import Self


class GitRepository(BaseModel):
    """
    GitRepository
    """  # noqa: E501

    branch: StrictStr
    clone_target: Optional[CloneTarget] = Field(default=None, alias="cloneTarget")
    id: StrictStr
    name: StrictStr
    owner: StrictStr
    path: Optional[StrictStr] = None
    pr_number: Optional[StrictInt] = Field(default=None, alias="prNumber")
    sha: StrictStr
    source: StrictStr
    url: StrictStr
    __properties: ClassVar[List[str]] = [
        "branch",
        "cloneTarget",
        "id",
        "name",
        "owner",
        "path",
        "prNumber",
        "sha",
        "source",
        "url",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "branch": obj.get("branch"),
                "cloneTarget": obj.get("cloneTarget"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "owner": obj.get("owner"),
                "path": obj.get("path"),
                "prNumber": obj.get("prNumber"),
                "sha": obj.get("sha"),
                "source": obj.get("source"),
                "url": obj.get("url"),
            }
        )
        return _obj
