# coding: utf-8

"""
    Daytona Server API

    Daytona Server API

    The version of the OpenAPI document: v0.0.0-dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from api_client.models.file_status import FileStatus
from typing import Optional, Set
from typing_extensions import Self


class GitStatus(BaseModel):
    """
    GitStatus
    """  # noqa: E501

    ahead: Optional[StrictInt] = None
    behind: Optional[StrictInt] = None
    branch_published: Optional[StrictBool] = Field(
        default=None, alias="branchPublished"
    )
    current_branch: StrictStr = Field(alias="currentBranch")
    file_status: List[FileStatus] = Field(alias="fileStatus")
    __properties: ClassVar[List[str]] = [
        "ahead",
        "behind",
        "branchPublished",
        "currentBranch",
        "fileStatus",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in file_status (list)
        _items = []
        if self.file_status:
            for _item_file_status in self.file_status:
                if _item_file_status:
                    _items.append(_item_file_status.to_dict())
            _dict["fileStatus"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "ahead": obj.get("ahead"),
                "behind": obj.get("behind"),
                "branchPublished": obj.get("branchPublished"),
                "currentBranch": obj.get("currentBranch"),
                "fileStatus": (
                    [FileStatus.from_dict(_item) for _item in obj["fileStatus"]]
                    if obj.get("fileStatus") is not None
                    else None
                ),
            }
        )
        return _obj
