# coding: utf-8

"""
    Daytona Server API

    Daytona Server API

    The version of the OpenAPI document: v0.0.0-dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from api_client.models.completion_context import CompletionContext
from api_client.models.position import Position
from typing import Optional, Set
from typing_extensions import Self


class LspCompletionParams(BaseModel):
    """
    LspCompletionParams
    """  # noqa: E501

    context: Optional[CompletionContext] = None
    language_id: StrictStr = Field(alias="languageId")
    path_to_project: StrictStr = Field(alias="pathToProject")
    position: Position
    uri: StrictStr
    __properties: ClassVar[List[str]] = [
        "context",
        "languageId",
        "pathToProject",
        "position",
        "uri",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LspCompletionParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of context
        if self.context:
            _dict["context"] = self.context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict["position"] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LspCompletionParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "context": (
                    CompletionContext.from_dict(obj["context"])
                    if obj.get("context") is not None
                    else None
                ),
                "languageId": obj.get("languageId"),
                "pathToProject": obj.get("pathToProject"),
                "position": (
                    Position.from_dict(obj["position"])
                    if obj.get("position") is not None
                    else None
                ),
                "uri": obj.get("uri"),
            }
        )
        return _obj
